/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tools;

import de.aristaflow.adept2.model.timemodel.tools.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractGraph<V, E>
implements Graph<V, E> {
    protected int maxNodeID = 0;
    protected Map<V, Integer> vertices = new LinkedHashMap<V, Integer>();
    private Object[][] edges;

    public AbstractGraph(Collection<V> vertices) {
        for (V n : vertices) {
            if (this.vertices.containsKey(n)) continue;
            this.vertices.put((Integer)n, this.maxNodeID++);
        }
        this.ensureCapacity(this.maxNodeID);
    }

    int getNodeKey(V sourceNode) {
        Integer key = this.vertices.get(sourceNode);
        if (key == null) {
            throw new IllegalArgumentException(String.valueOf(key));
        }
        assert (key != null);
        return key;
    }

    protected void ensureCapacity(int size) {
        if (this.edges == null) {
            int newSize = size;
            this.edges = new Object[newSize][newSize];
        } else if (this.edges.length <= size) {
            int newSize = (int)((double)size * 1.1);
            Object[][] newArray = new Object[newSize][newSize];
            int i = 0;
            while (i < this.edges.length) {
                System.arraycopy(this.edges[i], 0, newArray[i], 0, this.edges.length);
                ++i;
            }
            this.edges = newArray;
        }
    }

    @Override
    public Collection<E> getEdges() {
        ArrayList<E> eg = new ArrayList<E>(this.edges.length * 2);
        int i = 0;
        while (i < this.maxNodeID) {
            int j = 0;
            while (j < this.maxNodeID) {
                E edge = this.internalGetEdge(i, j);
                if (edge != null) {
                    eg.add(edge);
                }
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableList(eg);
    }

    @Override
    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    public abstract boolean addEdge(V var1, V var2, E var3);

    @Override
    public abstract E getEdge(V var1, V var2);

    protected boolean internalSetEdge(int key1, int key2, E edge) {
        boolean exists = this.edges[key1][key2] != null;
        this.edges[key1][key2] = edge;
        return exists;
    }

    E internalGetEdge(int key1, int key2) {
        return (E)this.edges[key1][key2];
    }
}

