/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tools;

import de.aristaflow.adept2.model.timemodel.tools.DirectedGraph;
import de.aristaflow.adept2.model.timemodel.tools.Graph;
import de.aristaflow.adept2.model.timemodel.tools.GraphVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DepthFirstSearch<V, E> {
    private Graph<V, E> graph;
    private boolean directed;

    public DepthFirstSearch(Graph<V, E> graph) {
        this.graph = graph;
        this.directed = graph instanceof DirectedGraph;
    }

    public void performDepthFirstSearch(GraphVisitor<V, E> visitor, V startNode) {
        Collection<V> vertices = this.graph.getVertices();
        int vertexCount = vertices.size();
        visitor.discoverGraph(this.graph);
        this.runDFS(visitor, startNode, new HashSet((int)((double)vertexCount * 1.5)), new HashSet((int)((double)this.graph.getEdges().size() * 1.5)));
        visitor.finishGraph(this.graph);
    }

    protected void runDFS(GraphVisitor<V, E> visitor, V u, Set<V> markedVertices, HashSet<E> markedEdges) {
        visitor.discoverVertex(u);
        markedVertices.add(u);
        for (V v : this.graph.getVertices()) {
            E edge = this.graph.getEdge(u, v);
            if (edge == null) continue;
            markedEdges.add(edge);
            visitor.discoverEdge(u, v, edge);
            if (!markedVertices.contains(v)) {
                this.runDFS(visitor, v, markedVertices, markedEdges);
            }
            visitor.finishEdge(u, v, edge);
        }
        visitor.finishVertex(u);
    }

    static enum VertexState {
        White,
        Gray,
        Black;

    }
}

