/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation;

import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.ModellingClientService;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    public static boolean useAdvancedGraphics;
    public static final String PROP_USE_ANTIALIASING = "AntiAliasing";

    static {
        useAdvancedGraphics = true;
    }

    public static String getPluginID() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    private boolean checkGraphics() {
        boolean enable = true;
        if (this.getPreferenceStore().contains(PROP_USE_ANTIALIASING)) {
            String value = this.getPreferenceStore().getString(PROP_USE_ANTIALIASING);
            if ("true".equals(value)) {
                enable = true;
            }
            if ("false".equals(value)) {
                enable = false;
            }
        }
        if (System.getProperty("antialiasing") != null) {
            enable = Boolean.parseBoolean(System.getProperty("antialiasing"));
        }
        this.logger.info(String.format("Using advanced graphics: '%s'.", enable));
        return enable;
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        useAdvancedGraphics = this.checkGraphics();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ADEPT2ClientService getService() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(ADEPT2ClientService.class.getName());
        return (ADEPT2ClientService)context.getService(ref);
    }

    public static ModellingClientService getModellingClientService() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(ADEPT2ClientService.class.getName());
        return (ModellingClientService)context.getService(ref);
    }

    public static Image getSharedImage(String key) {
        return Activator.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return Activator.getDefault().getImageRegistry().getDescriptor(key);
    }
}

