/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;

public class OutlinePage
extends ContentOutlinePage
implements IAdaptable {
    private PageBook pageBook;
    private Control outline;
    private Canvas overview;
    private IAction showOutlineAction;
    private IAction showOverviewAction;
    static final int ID_OUTLINE = 0;
    static final int ID_OVERVIEW = 1;
    Thumbnail thumbnail;
    private DisposeListener disposeListener;
    private final SelectionSynchronizer synchroniser;

    public OutlinePage(EditPartViewer viewer, SelectionSynchronizer synchroniser) {
        super(viewer);
        this.synchroniser = synchroniser;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public boolean isDisposed() {
        return this.getControl().isDisposed();
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.outline = new Text((Composite)this.pageBook, 2);
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.pageBook.showPage(this.outline);
        Text t = (Text)this.outline;
        t.setText("Zoom: Ctrl+Mousewheel\nScroll: Space+LeftMouse\nSelect: (ctrl) + LeftMouse\n");
        this.getSite().getActionBars().getToolBarManager();
        this.showOutlineAction = new Action(){

            public void run() {
                OutlinePage.this.showPage(0);
            }
        };
        this.showOverviewAction = new Action(){

            public void run() {
                OutlinePage.this.showPage(1);
            }
        };
        this.showPage(1);
    }

    public void dispose() {
        this.unhookOutlineViewer();
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return this.getViewer().getProperty(ZoomManager.class.toString());
        }
        return null;
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected void initializeOverview() {
        LightweightSystem lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.getViewer().getRootEditPart();
        if (rep instanceof ScalableRootEditPart) {
            ScalableRootEditPart root = (ScalableRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (OutlinePage.this.thumbnail != null) {
                        OutlinePage.this.thumbnail.deactivate();
                        OutlinePage.this.thumbnail = null;
                    }
                }
            };
            this.getEditor().addDisposeListener(this.disposeListener);
        }
    }

    public void setContents(Object contents) {
        this.getViewer().setContents(contents);
    }

    protected void showPage(int id) {
        if (id == 0) {
            this.showOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage(this.outline);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(false);
            }
        } else if (id == 1) {
            if (this.thumbnail == null) {
                this.initializeOverview();
            }
            this.showOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
            this.thumbnail.setVisible(true);
        }
    }

    protected void unhookOutlineViewer() {
        this.synchroniser.removeViewer(this.getViewer());
        if (this.disposeListener != null && this.getEditor() != null && !this.getEditor().isDisposed()) {
            this.getEditor().removeDisposeListener(this.disposeListener);
        }
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getViewer().getControl();
    }
}

