/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation;

import de.aristaflow.adept2.ui.processvisualisation.Activator;
import java.util.List;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.preference.IPreferenceStore;

public class PaletteFactory {
    private static final String PALETTE_DOCK_LOCATION = "PaletteFactory.Location";
    private static final String PALETTE_SIZE = "PaletteFactory.Size";
    private static final String PALETTE_STATE = "PaletteFactory.State";
    private PaletteDrawer selectionDrawer = null;
    private PaletteRoot palette = new PaletteRoot();

    public PaletteFactory() {
        this.palette.setLabel("Selection");
        this.selectionDrawer = new PaletteDrawer("no special selection");
        this.palette.add((PaletteEntry)this.selectionDrawer);
    }

    public PaletteRoot getRoot() {
        return this.palette;
    }

    public PaletteDrawer getSelectionDrawer() {
        return this.selectionDrawer;
    }

    public void resetSelectionDrawer() {
        List entries = this.selectionDrawer.getChildren();
        Object[] objectArray = entries.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object entry = objectArray[n2];
            this.selectionDrawer.remove((PaletteEntry)entry);
            ++n2;
        }
        this.selectionDrawer.setLabel("no special selection");
    }

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            private IPreferenceStore getPreferenceStore() {
                return Activator.getDefault().getPreferenceStore();
            }

            public int getDockLocation() {
                return this.getPreferenceStore().getInt(PaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return this.getPreferenceStore().getInt(PaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return this.getPreferenceStore().getInt(PaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                this.getPreferenceStore().setValue(PaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                this.getPreferenceStore().setValue(PaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                this.getPreferenceStore().setValue(PaletteFactory.PALETTE_SIZE, width);
            }
        };
    }
}

