/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation;

import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class ProblemMarker {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".ProblemMarker";
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_INFO = 0;
    public static final int SEVERITY_NONE = -1;
    public static final String ELEMENT_TYPE = "elementType";
    public static final String ELEMENT_ID = "elementId";
    protected static final Logger logger = LoggerTools.getLogger(ProblemMarker.class);

    public static IMarker addMarkerToFile(IResource resource, Object element, String message, int severity) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        IMarker marker = null;
        try {
            marker = resource.createMarker(ID);
            marker.setAttribute("message", (Object)message);
            if (element instanceof URI) {
                URI processElementIdentifier = (URI)element;
                marker.setAttribute("location", (Object)element.toString());
                marker.setAttribute(ELEMENT_TYPE, (Object)ProcessElementIdentifierTools.getElementType((URI)processElementIdentifier));
                marker.setAttribute(ELEMENT_ID, (Object)processElementIdentifier.toString());
            }
            marker.setAttribute("severity", severity);
        }
        catch (CoreException e) {
            logger.severe("Error adding Marker: " + e.getMessage());
        }
        return marker;
    }

    public static IMarker addMarkerToFile(IResource resource, String message, String location, int severity) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null!");
        }
        IMarker marker = null;
        try {
            marker = resource.createMarker(ID);
            marker.setAttribute("message", (Object)message);
            if (location != null) {
                marker.setAttribute("location", (Object)location);
            }
            marker.setAttribute("severity", severity);
        }
        catch (CoreException e) {
            logger.severe("Error adding Marker: " + e.getMessage());
        }
        return marker;
    }

    public static Image getStatusIcon(int status) {
        Image statusIcon;
        switch (status) {
            case 2: {
                statusIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                break;
            }
            case 1: {
                statusIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                break;
            }
            case 0: {
                statusIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                break;
            }
            case -1: {
                statusIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
                break;
            }
            default: {
                statusIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
            }
        }
        return statusIcon;
    }
}

