/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation;

import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroup;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.PanningSelectionTool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;

public class SwapSelectionToolEntry
extends ToolEntry {
    private SelectionDefinition definition;
    private SelectionGroup group;
    private SelectionTool tool;

    public SwapSelectionToolEntry(SelectionGroup group, SelectionDefinition definition) {
        super(definition.getName(), definition.getDescription(), ImageDescriptor.createFromFile(Activator.class, (String)"icons/sample.gif"), ImageDescriptor.createFromFile(Activator.class, (String)"icons/sample.gif"));
        ColorImageDescriptor icon = new ColorImageDescriptor(definition.getColor() != null ? definition.getColor() : ColorConstants.gray);
        this.setSmallIcon(icon);
        this.setLargeIcon(icon);
        this.group = group;
        this.definition = definition;
    }

    public SelectionGroup getGroup() {
        return this.group;
    }

    public SelectionDefinition getDefinition() {
        return this.definition;
    }

    public Tool createTool() {
        if (this.tool == null) {
            this.tool = new SwapSelectionTool(this.group, this.definition);
        }
        return this.tool;
    }

    private static class ColorImageDescriptor
    extends ImageDescriptor {
        private final ImageData image;

        public ColorImageDescriptor(Color color) {
            RGB[] rgb = new RGB[]{new RGB(color.getRed(), color.getGreen(), color.getBlue())};
            PaletteData palette = new PaletteData(rgb);
            this.image = new ImageData(16, 16, 1, palette);
            int pixelValue = palette.getPixel(rgb[0]);
            int x = 0;
            while (x < 16) {
                int y = 0;
                while (y < 16) {
                    this.image.setPixel(x, y, pixelValue);
                    ++y;
                }
                ++x;
            }
        }

        public ImageData getImageData() {
            return this.image;
        }
    }

    public static class SwapSelectionTool
    extends PanningSelectionTool {
        private SelectionDefinition definition = null;
        private SelectionGroup group = null;

        SwapSelectionTool(SelectionGroup group, SelectionDefinition definition) {
            this.definition = definition;
            this.group = group;
        }

        public void mouseDown(MouseEvent e, EditPartViewer viewer) {
            if (e.button == 2) {
                this.group.switchActiveSelection();
                return;
            }
            EditPart editPart = viewer.findObjectAt(new Point(e.x, e.y));
            if (editPart instanceof IProcessEditPart) {
                this.group.getParent().editPartClicked((IProcessEditPart)editPart, e.stateMask == 262144 && e.button == 1);
            }
        }

        public void keyDown(KeyEvent evt, EditPartViewer viewer) {
            if (evt.keyCode == 131072) {
                this.group.switchActiveSelection();
            }
            if (evt.keyCode == 262144) {
                Shell shell = viewer.getControl().getShell();
                shell.setCursor(SharedCursors.CURSOR_TREE_ADD);
            }
            super.keyDown(evt, viewer);
        }

        public void keyUp(KeyEvent evt, EditPartViewer viewer) {
            if (evt.keyCode == 131072) {
                this.group.switchActiveSelection();
            }
            if (evt.keyCode == 262144) {
                Shell shell = viewer.getControl().getShell();
                shell.setCursor(null);
            }
            super.keyUp(evt, viewer);
        }

        public void activate() {
            super.activate();
            this.group.setActivSelection(this.definition);
        }
    }
}

