/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation;

import de.aristaflow.adept2.model.graphical.RenderOptions;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.widgets.LabelTextFormatter;
import de.aristaflow.adept2.ui.processvisualisation.widgets.LabelTextProvider;
import de.aristaflow.adept2.util.LoggerTools;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UISettings {
    public static final String HORIZONTAL_SPACING = "HorizontalSpacing";
    public static final String VERTICAL_SPACING = "VerticalSpacing";
    public static final String GRAPH_FIGURE_PROVIDER_ID = "GraphFigureProviderID";
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".UISettings";
    PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    boolean dataEdgesVisible = true;
    boolean systemDataEdgesVisible = true;
    boolean decisionDataEdgesVisible = true;
    boolean dataElementsVisible = true;
    boolean systemDataElementsVisible = true;
    boolean decisionDataElementsVisible = true;
    boolean dependencyVisibilityMode = false;
    boolean syncEdgeVisible = true;
    int horizontalSpacing = 60;
    int verticalSpacing = 20;
    LabelTextProvider textProvider;
    boolean scrollToChanges = true;
    protected final Logger logger = LoggerTools.getLogger((Object)this);

    public UISettings(GraphicalViewer viewer) {
        this.updateFromPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.textProvider = new LabelTextProvider(viewer, Activator.getService().getActiveAgent().getLocale());
    }

    public UISettings(RenderOptions options) {
        this.updateFromOptions(options);
    }

    private void updateFromPreferenceStore(IPreferenceStore prefStore) {
        this.dataEdgesVisible = prefStore.getBoolean("EditorDataEdgesVisiblePreference");
        this.dataElementsVisible = prefStore.getBoolean("EditorDataElementsVisiblePreference");
        this.systemDataEdgesVisible = prefStore.getBoolean("EditorSystemDataEdgesVisiblePreference");
        this.systemDataElementsVisible = prefStore.getBoolean("EditorSystemDataElementsVisiblePreference");
        this.syncEdgeVisible = prefStore.getBoolean("EdiorSyncEdgeVisiblePreference");
        this.decisionDataElementsVisible = prefStore.getBoolean("EditorDecisionDataElementVisiblePreference");
        this.decisionDataEdgesVisible = prefStore.getBoolean("EditorDecisionDataEdgesVisiblePreference");
        this.dependencyVisibilityMode = prefStore.getBoolean("EditorDependencyVisibilityModePreference");
        this.horizontalSpacing = prefStore.getInt("EditorHorizontalSpacingPreference");
        this.verticalSpacing = prefStore.getInt("EditorVerticalSpacingPreference");
        this.scrollToChanges = prefStore.getBoolean("EditorScrollToChanges");
    }

    private void updateFromOptions(RenderOptions options) {
        this.dataEdgesVisible = options.dataEdgesVisible();
        this.dataElementsVisible = options.dataElementsVisible();
        this.systemDataEdgesVisible = options.systemDataEdgesVisible();
        this.systemDataElementsVisible = options.systemDataElementsVisible();
        this.syncEdgeVisible = options.syncEdgesVisible();
        this.decisionDataElementsVisible = options.decisionDataElementsVisible();
        this.decisionDataEdgesVisible = options.decisionDataEdgesVisible();
        this.dependencyVisibilityMode = false;
        this.scrollToChanges = false;
        Map advOptions = options.getAdvancedOptions();
        if (advOptions.containsKey(HORIZONTAL_SPACING)) {
            this.horizontalSpacing = Integer.parseInt((String)advOptions.get(HORIZONTAL_SPACING));
        }
        if (advOptions.containsKey(VERTICAL_SPACING)) {
            this.verticalSpacing = Integer.parseInt((String)advOptions.get(VERTICAL_SPACING));
        }
    }

    protected void firePropertyChange() {
        this.listeners.firePropertyChange(new PropertyChangeEvent(this, ID, null, null));
    }

    public void addUIListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removeUIListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public boolean isDataEdgesVisible() {
        return this.dataEdgesVisible;
    }

    public void setDataEdgesVisible(boolean dataEdgesVisible) {
        this.dataEdgesVisible = dataEdgesVisible;
        this.firePropertyChange();
    }

    public boolean isSystemDataEdgeVisible() {
        return this.systemDataEdgesVisible;
    }

    public void setSystemDataEdgesVisible(boolean systemDataEdgesVisible) {
        this.systemDataEdgesVisible = systemDataEdgesVisible;
        this.firePropertyChange();
    }

    public boolean isDataElementsVisible() {
        return this.dataElementsVisible;
    }

    public void setDataElementsVisible(boolean dataElementsVisible) {
        this.dataElementsVisible = dataElementsVisible;
        this.firePropertyChange();
    }

    public boolean isSystemDataElementVisible() {
        return this.systemDataElementsVisible;
    }

    public void setSystemDataElementsVisible(boolean systemDataElementsVisible) {
        this.systemDataElementsVisible = systemDataElementsVisible;
        this.firePropertyChange();
    }

    public boolean isDecisionDataElementVisible() {
        return this.decisionDataElementsVisible;
    }

    public void setDecisionDataElementsVisible(boolean decisionDataElementsVisible) {
        this.decisionDataElementsVisible = decisionDataElementsVisible;
        this.firePropertyChange();
    }

    public boolean isDecisionDataEdgeVisible() {
        return this.decisionDataEdgesVisible;
    }

    public void setDecisionDataEdgesVisible(boolean decisionDataEdgesVisible) {
        this.decisionDataEdgesVisible = decisionDataEdgesVisible;
        this.firePropertyChange();
    }

    public boolean isSyncEdgeVisible() {
        return this.syncEdgeVisible;
    }

    public void setSyncEdgeVisible(boolean syncEdgeVisible) {
        this.syncEdgeVisible = syncEdgeVisible;
        this.firePropertyChange();
    }

    public boolean isDependencyVisibilityModeOn() {
        return this.dependencyVisibilityMode;
    }

    public void setDependencyVisiblityMode(boolean dependencyVisibilityMode) {
        this.dependencyVisibilityMode = dependencyVisibilityMode;
        this.firePropertyChange();
    }

    public LabelTextProvider getTextProvider() {
        return this.textProvider;
    }

    public void setTextProvider(LabelTextProvider textProvider) {
        this.textProvider = textProvider;
        this.firePropertyChange();
    }

    public void addLabelTextFormatter(Class<?> source, LabelTextFormatter formatter) {
        this.textProvider.addLabelTextFormatter(source, formatter);
        this.firePropertyChange();
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
        this.firePropertyChange();
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
        this.firePropertyChange();
    }

    public void showConfigDialog(Shell parent) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent, (String)"de.aristaflow.adept2.ui.processvisualisation.preferences.EditorPreferencesPage", (String[])new String[]{"de.aristaflow.adept2.ui.processvisualisation.preferences.EditorPreferencesPage"}, (Object)this);
        dialog.open();
        this.firePropertyChange();
    }

    public void setSpacing(int horizontal, int vertical) {
        this.horizontalSpacing = horizontal;
        this.verticalSpacing = vertical;
        this.firePropertyChange();
    }

    public int getIntValue(String preferenceName) {
        if (preferenceName.equals("EditorHorizontalSpacingPreference")) {
            return this.getHorizontalSpacing();
        }
        if (preferenceName.equals("EditorVerticalSpacingPreference")) {
            return this.getVerticalSpacing();
        }
        this.logger.severe("Unkown UISettings Preference: " + preferenceName);
        return 0;
    }

    public boolean getBooleanValue(String preferenceName) {
        if (preferenceName.equals("EditorDataEdgesVisiblePreference")) {
            return this.isDataEdgesVisible();
        }
        if (preferenceName.equals("EditorDataElementsVisiblePreference")) {
            return this.isDataElementsVisible();
        }
        if (preferenceName.equals("EditorSystemDataEdgesVisiblePreference")) {
            return this.isSystemDataEdgeVisible();
        }
        if (preferenceName.equals("EditorSystemDataElementsVisiblePreference")) {
            return this.isSystemDataElementVisible();
        }
        if (preferenceName.equals("EditorDecisionDataElementVisiblePreference")) {
            return this.isDecisionDataElementVisible();
        }
        if (preferenceName.equals("EditorDecisionDataEdgesVisiblePreference")) {
            return this.isDecisionDataEdgeVisible();
        }
        if (preferenceName.equals("EdiorSyncEdgeVisiblePreference")) {
            return this.isSyncEdgeVisible();
        }
        if (preferenceName.equals("EditorDependencyVisibilityModePreference")) {
            return this.isDependencyVisibilityModeOn();
        }
        if (preferenceName.endsWith("EditorScrollToChanges")) {
            return this.scrollToChanges();
        }
        this.logger.severe("Unkown UISettings Preference: " + preferenceName);
        return false;
    }

    public void setValue(String preferenceName, int intValue) {
        if (preferenceName.equals("EditorHorizontalSpacingPreference")) {
            this.setHorizontalSpacing(intValue);
        } else if (preferenceName.equals("EditorVerticalSpacingPreference")) {
            this.setVerticalSpacing(intValue);
        } else {
            this.logger.severe("Unkown UISettings Preference: " + preferenceName);
        }
    }

    public void setValue(String preferenceName, boolean booleanValue) {
        if (preferenceName.equals("EditorDataEdgesVisiblePreference")) {
            this.setDataEdgesVisible(booleanValue);
        } else if (preferenceName.equals("EditorDataElementsVisiblePreference")) {
            this.setDataElementsVisible(booleanValue);
        } else if (preferenceName.equals("EditorSystemDataEdgesVisiblePreference")) {
            this.setSystemDataEdgesVisible(booleanValue);
        } else if (preferenceName.equals("EditorSystemDataElementsVisiblePreference")) {
            this.setSystemDataElementsVisible(booleanValue);
        } else if (preferenceName.equals("EditorDecisionDataElementVisiblePreference")) {
            this.setDecisionDataElementsVisible(booleanValue);
        } else if (preferenceName.equals("EditorDecisionDataEdgesVisiblePreference")) {
            this.setDecisionDataEdgesVisible(booleanValue);
        } else if (preferenceName.equals("EdiorSyncEdgeVisiblePreference")) {
            this.setSyncEdgeVisible(booleanValue);
        } else if (preferenceName.equals("EditorDependencyVisibilityModePreference")) {
            this.setDependencyVisiblityMode(booleanValue);
        } else if (preferenceName.equals("EditorScrollToChanges")) {
            this.setScrollToChanges(booleanValue);
        } else {
            this.logger.severe("Unkown UISettings Preference: " + preferenceName);
        }
    }

    public void setScrollToChanges(boolean booleanValue) {
        this.scrollToChanges = booleanValue;
    }

    public boolean scrollToChanges() {
        return this.scrollToChanges;
    }
}

