/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.actions;

import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ExportImage
implements IWorkbenchWindowActionDelegate {
    private static final String PREF_IMAGE_SAVE_PATH = "imagesavepath";
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    private IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        GraphicalViewer viewer = (GraphicalViewer)this.window.getActivePage().getActiveEditor().getAdapter(GraphicalViewer.class);
        if (viewer == null) {
            this.logger.severe("Can't find viewer to take snapshot of!");
            return;
        }
        ImageOptions optionDialog = new ImageOptions(new Shell());
        if (optionDialog.open() == 1) {
            return;
        }
        this.createImage(viewer, optionDialog);
    }

    private void createImage(GraphicalViewer viewer, ImageOptions options) {
        File file;
        Display device = viewer.getControl().getDisplay();
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        Rectangle r = figure.getBounds();
        double dpiScale = options.getScaleFactor();
        r.width = (int)((double)r.width * dpiScale);
        r.height = (int)((double)r.height * dpiScale);
        if (r.width * r.height > 6000000) {
            MessageBox confirm = new MessageBox(this.window.getShell(), 288);
            confirm.setMessage("Saving large images may require more memory than available.\nAttempt anyway?");
            confirm.setText("Possible problem detected");
            if (confirm.open() != 32) {
                return;
            }
        }
        if ((file = this.openFile(options.getFileExtension())) == null) {
            return;
        }
        GC gc = null;
        Image image = null;
        SWTGraphics g = null;
        try {
            try {
                FileOutputStream result = new FileOutputStream(file);
                image = new Image((Device)device, r.width, r.height);
                gc = new GC((Drawable)image);
                g = new SWTGraphics(gc);
                g.translate(r.x * -1, r.y * -1);
                g.scale(dpiScale);
                figure.paint((Graphics)g);
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save((OutputStream)result, options.getFileFormat());
                result.close();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "The image could not be written.", ex);
                if (g != null) {
                    g.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    protected File openFile(String extension) {
        File file;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String initialPath = preferenceStore.getString(PREF_IMAGE_SAVE_PATH);
        if (initialPath == null) {
            initialPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), 8192);
        dialog.setText("Save As");
        dialog.setFilterPath(initialPath);
        dialog.setFilterExtensions(new String[]{"*" + extension});
        String fileName = dialog.open();
        if (fileName == null) {
            this.logger.severe("No image file path selected for saving.");
            return null;
        }
        preferenceStore.setValue(PREF_IMAGE_SAVE_PATH, fileName);
        if (!fileName.contains(".")) {
            fileName = String.valueOf(fileName) + extension;
        }
        if ((file = new File(fileName)).exists()) {
            MessageBox confirm = new MessageBox(window.getShell(), 288);
            confirm.setMessage("The file already exists. Replace the file?");
            confirm.setText("Confirm file replace");
            if (confirm.open() != 32) {
                return null;
            }
            if (!file.canWrite()) {
                this.logger.log(Level.SEVERE, "The output file is not writable.");
                return null;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "The output file for the image cannot be created", e);
                return null;
            }
        }
        return file;
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.window.getActivePage().getActiveEditor() instanceof ProcessVisualiser);
    }

    static class ImageOptions
    extends Dialog {
        private Combo scaleFactorList;
        private Combo fileFormatList;
        private double scaleFactor;
        private int fileFormat;
        private String fileExtension;

        public ImageOptions(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText("Choose snapshot options");
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite options = new Composite(composite, composite.getStyle());
            options.setLayout((Layout)new GridLayout(2, false));
            new Label(options, 0).setText("Scale");
            this.scaleFactorList = new Combo(options, 12);
            this.scaleFactorList.add("1");
            this.scaleFactorList.add("2");
            this.scaleFactorList.add("3");
            this.scaleFactorList.select(0);
            new Label(options, 0).setText("File format");
            this.fileFormatList = new Combo(options, 12);
            this.fileFormatList.add("BMP");
            this.fileFormatList.add("JPG");
            this.fileFormatList.select(1);
            return composite;
        }

        protected void okPressed() {
            this.cacheFileFormat();
            this.cacheScaleFactor();
            super.okPressed();
        }

        public int getFileFormat() {
            return this.fileFormat;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        private void cacheFileFormat() {
            switch (this.fileFormatList.getSelectionIndex()) {
                case 0: {
                    this.fileFormat = 0;
                    this.fileExtension = ".bmp";
                    break;
                }
                case 1: {
                    this.fileFormat = 4;
                    this.fileExtension = ".jpg";
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid dropdown list state: " + this.scaleFactorList.getSelectionIndex());
                }
            }
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        private void cacheScaleFactor() {
            switch (this.scaleFactorList.getSelectionIndex()) {
                case 0: {
                    this.scaleFactor = 1.0;
                    break;
                }
                case 1: {
                    this.scaleFactor = 2.0;
                    break;
                }
                case 2: {
                    this.scaleFactor = 3.0;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid dropdown list state: " + this.scaleFactorList.getSelectionIndex());
                }
            }
        }
    }
}

