/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.actions;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PrintTemplateAction
extends WorkbenchPartAction {
    public PrintTemplateAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText("Print");
        this.setToolTipText("Print the diagram");
        this.setId(ActionFactory.PRINT.getId());
    }

    protected boolean calculateEnabled() {
        return Printer.getPrinterList().length > 0;
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        PrintOptions optionDialog = new PrintOptions(new Shell());
        int status = optionDialog.open();
        if (status == 1) {
            return;
        }
        this.doPrint(viewer, optionDialog.getPrintMode());
    }

    private void doPrint(GraphicalViewer viewer, int printMode) {
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null) {
            PrintGraphicalViewerOperation op = new PrintGraphicalViewerOperation(new Printer(data), viewer);
            op.setPrintMode(printMode);
            op.run(this.getWorkbenchPart().getTitle());
        }
    }

    static class PrintOptions
    extends Dialog {
        private Combo printModeList;
        private int printMode;

        public PrintOptions(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText("Print Options");
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            new Label(composite, 0).setText("Choose the scaling mode");
            this.printModeList = new Combo(composite, 12);
            this.printModeList.add("Fit to page");
            this.printModeList.add("Fit to page height");
            this.printModeList.add("Fit to page width");
            this.printModeList.add("Tile across pages");
            this.printModeList.select(0);
            this.printModeList.setEnabled(true);
            return composite;
        }

        protected void okPressed() {
            this.printMode = this.findPrintMode();
            super.okPressed();
        }

        public int getPrintMode() {
            return this.printMode;
        }

        private int findPrintMode() {
            switch (this.printModeList.getSelectionIndex()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 1;
                }
            }
            throw new RuntimeException("Invalid dropdown list state: " + this.printModeList.getSelectionIndex());
        }
    }
}

