/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.debug;

import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import java.util.Stack;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class GraphVisualizationConsoleFactory
implements IConsoleFactory,
MouseListener {
    protected final MessageConsole console = new MessageConsole("GraphVisualizationConsole", null);
    protected MessageConsoleStream message;
    protected ProcessVisualiser activeVisualisation;

    public GraphVisualizationConsoleFactory() {
        this.initialize();
    }

    private void initialize() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.activeVisualisation = (ProcessVisualiser)page.getActiveEditor();
        this.message = this.console.newMessageStream();
        this.message.println("Template Name: " + this.activeVisualisation.getTemplate().getNodes().size());
        this.activeVisualisation.getGraphicalViewer().getControl().addMouseListener((MouseListener)this);
        page.addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().equals(GraphVisualizationConsoleFactory.this.activeVisualisation)) {
                    GraphVisualizationConsoleFactory.this.activeVisualisation.getGraphicalViewer().getControl().removeMouseListener((MouseListener)GraphVisualizationConsoleFactory.this);
                    GraphVisualizationConsoleFactory.this.activeVisualisation = (ProcessVisualiser)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    GraphVisualizationConsoleFactory.this.clearConsoleDocument(GraphVisualizationConsoleFactory.this.console);
                    GraphVisualizationConsoleFactory.this.message.println("Number of nodes: " + GraphVisualizationConsoleFactory.this.activeVisualisation.getTemplate().getNodes().size());
                    GraphVisualizationConsoleFactory.this.activeVisualisation.getGraphicalViewer().getControl().addMouseListener((MouseListener)GraphVisualizationConsoleFactory.this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        });
    }

    public void openConsole() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.addConsoles(new IConsole[]{this.console});
    }

    public void clearConsoleDocument(MessageConsole mConsole) {
        mConsole.getDocument().set("");
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        EditPart part = this.activeVisualisation.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part != null && part instanceof DefaultNodeEditPart) {
            DefaultNodeEditPart nodePart = (DefaultNodeEditPart)part;
            this.generateConsoleOutput(nodePart);
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void generateConsoleOutput(NodeEditPart part) {
        if (part.getModel() instanceof Node) {
            IFigure container;
            BlockEditPart blockPart;
            if (part.getChildren().size() == 0) {
                this.message.println("EditPart for node with id: " + ((Node)part.getModel()).getID() + " does not have children");
            } else {
                this.message.println("Children of editpart for node with id: " + ((Node)part.getModel()).getID());
                for (Object child : part.getChildren()) {
                    if (child instanceof NodeEditPart) {
                        NodeEditPart nodePart = (NodeEditPart)child;
                        this.message.println("Child (NodeID): " + ((Node)nodePart.getModel()).getID());
                        continue;
                    }
                    if (!(child instanceof BranchEditPart)) continue;
                    BranchEditPart branchPart = (BranchEditPart)child;
                    this.message.println("Child (BranchID): " + branchPart.getModel());
                }
            }
            this.message.println("Figure tree for node with id: " + ((Node)part.getModel()).getID());
            this.printFigureTreeForFigure((IFigure)((DefaultNodeEditPart)part).nodeFigure);
            this.message.println("Container figure for node with id: " + ((Node)part.getModel()).getID());
            if (part instanceof BlockEditPart) {
                blockPart = (BlockEditPart)part;
                container = blockPart.getContainerFigure();
                this.message.println("Container size: " + container.getChildren().size());
                for (Object child : container.getChildren()) {
                    if (child instanceof NodeFigure) {
                        NodeFigure castedFigure = (NodeFigure)((Object)child);
                        this.message.println("Label: " + castedFigure.getPrimaryLabel().getText());
                        continue;
                    }
                    this.message.println(child.getClass().getName());
                }
            } else {
                this.message.println("No container figure");
            }
            this.message.println("Branch figure(s) for node with id: " + ((Node)part.getModel()).getID());
            if (part instanceof BlockEditPart) {
                blockPart = (BlockEditPart)part;
                container = blockPart.getContainerFigure();
                for (Object child : container.getChildren()) {
                    if (child instanceof NodeFigure) continue;
                    IFigure childFigure = (IFigure)child;
                    IFigure branchFigure = (IFigure)childFigure.getChildren().get(0);
                    this.message.println("Branch figure: node figure elements: ");
                    this.printBranchFigure(branchFigure);
                }
            } else {
                this.message.println("No branch figure");
            }
            this.message.println();
        }
    }

    private void printFigureTreeForFigure(IFigure figure) {
        Stack<IFigure> figureStack = new Stack<IFigure>();
        figureStack.push(figure);
        while (!figureStack.isEmpty()) {
            IFigure currentFigure = (IFigure)figureStack.pop();
            if (currentFigure instanceof NodeFigure) {
                NodeFigure castedFigure = (NodeFigure)currentFigure;
                this.message.println("Label: " + castedFigure.getPrimaryLabel().getText());
            } else if (currentFigure instanceof RoundedRectangle) {
                this.message.println("RoundedRectangle");
            } else if (currentFigure instanceof RectangleFigure) {
                this.message.println("RectangleFigure");
            } else if (currentFigure instanceof ImageFigure) {
                this.message.println("ImageFigure");
            } else {
                this.message.println("Not an instanceof NodeFigure: " + figure.getClass().getName());
            }
            for (Object childFigure : currentFigure.getChildren()) {
                IFigure castedChild = (IFigure)childFigure;
                figureStack.push(castedChild);
            }
        }
    }

    private void printBranchFigure(IFigure figure) {
        for (Object currentFigure : figure.getChildren()) {
            if (currentFigure instanceof NodeFigure) {
                NodeFigure castedFigure = (NodeFigure)((Object)currentFigure);
                this.message.println("Label: " + castedFigure.getPrimaryLabel().getText());
                continue;
            }
            IFigure iFigure = (IFigure)currentFigure;
            NodeFigure nodeFigure = (NodeFigure)((Object)iFigure.getChildren().get(0));
            this.message.println("Container Figure; Label of split node: " + nodeFigure.getPrimaryLabel().getText());
        }
    }
}

