/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.model;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.icons.ProcessImages;
import de.aristaflow.adept2.ui.processvisualisation.parts.MultiAnchor;
import de.aristaflow.adept2.ui.processvisualisation.parts.NodeAnchor;
import de.aristaflow.adept2.ui.processvisualisation.widgets.AndJoinFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.AndSplitFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.OrJoinFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.OrSplitFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ModelGlue {
    protected static final Logger logger = LoggerTools.getLogger(ModelGlue.class);
    private static final Color veryLightGreen = new Color(null, 150, 255, 150);
    private static final Color veryLightGray = new Color(null, 230, 230, 230);

    public static ConnectionAnchor getNodeAnchor(ProcessConstants.NodeType type, IFigure figure) {
        switch (type) {
            case NT_AND_JOIN: {
                return new MultiAnchor(figure, false, false);
            }
            case NT_XOR_JOIN: {
                return new MultiAnchor(figure, false, false);
            }
            case NT_ENDLOOP: {
                return new MultiAnchor(figure, false, true);
            }
            case NT_NORMAL: 
            case NT_STARTFLOW: 
            case NT_ENDFLOW: {
                return new NodeAnchor(figure);
            }
        }
        throw new IllegalArgumentException("Can't find figure for: " + type);
    }

    public static NodeFigure getNodeFigure(ProcessConstants.NodeType type) {
        switch (type) {
            case NT_AND_JOIN: {
                return new AndJoinFigure();
            }
            case NT_XOR_JOIN: {
                return new OrJoinFigure();
            }
            case NT_ENDLOOP: {
                return new NodeFigure();
            }
            case NT_AND_SPLIT: {
                return new AndSplitFigure();
            }
            case NT_XOR_SPLIT: {
                return new OrSplitFigure();
            }
            case NT_NORMAL: 
            case NT_STARTFLOW: 
            case NT_ENDFLOW: 
            case NT_STARTLOOP: {
                return new NodeFigure();
            }
        }
        throw new IllegalArgumentException("Can't find figure for: " + type);
    }

    public static ProcessConnection createFigureForEdge(Edge edge) {
        switch (edge.getType()) {
            case ET_CONTROL: {
                return new ProcessConnection();
            }
            case ET_LOOP: {
                return new ProcessConnection.LoopConnection();
            }
            case ET_SYNC: {
                return new ProcessConnection.SyncConnection();
            }
        }
        throw new IllegalArgumentException("Can't create figure for " + edge);
    }

    public static Image getNodeIcon(ProcessConstants.NodeState state) {
        switch (state) {
            case NS_ACTIVATED: {
                return ProcessImages.getImage((String)"activated.png");
            }
            case NS_COMPLETED: {
                return ProcessImages.getImage((String)"completed.png");
            }
            case NS_ENQUIRED: {
                return ProcessImages.getImage((String)"enquired.png");
            }
            case NS_FAILED: {
                return ProcessImages.getImage((String)"failed.png");
            }
            case NS_NOT_ACTIVATED: {
                return ProcessImages.getImage((String)"empty.png");
            }
            case NS_RUNNING: {
                return ProcessImages.getImage((String)"running.png");
            }
            case NS_SELECTED: {
                return ProcessImages.getImage((String)"selected.png");
            }
            case NS_SKIPPED: {
                return ProcessImages.getImage((String)"skipped.png");
            }
            case NS_SUSPENDED: {
                return ProcessImages.getImage((String)"suspended.png");
            }
        }
        RuntimeException t = new RuntimeException("No image defined for node state " + state);
        logger.log(Level.SEVERE, t.getMessage(), t);
        throw t;
    }

    public static Image getEdgeIcon(ProcessConstants.EdgeState state) {
        switch (state) {
            case ES_FALSE: {
                return ProcessImages.getImage((String)"false_signaled.png");
            }
            case ES_NS: {
                return null;
            }
            case ES_TRUE: {
                return ProcessImages.getImage((String)"true_signaled.png");
            }
        }
        RuntimeException t = new RuntimeException("No image defined for edge state " + state);
        logger.log(Level.SEVERE, t.getMessage(), t);
        throw t;
    }

    public static List<Node> walkList(int start, int end, Template t) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int current = start;
        while (current != end) {
            int[] nextNodes = t.getSuccByEdgeType(current, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
            if (nextNodes.length == 0) {
                logger.info("walkList: dead end reached!!");
                break;
            }
            switch (t.getNodeType(current)) {
                case NT_NORMAL: {
                    nodes.add(t.getNode(current));
                    current = nextNodes[0];
                    break;
                }
                case NT_STARTFLOW: 
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: 
                case NT_STARTLOOP: {
                    nodes.add(t.getNode(current));
                    current = t.getNodeCorrespondingBlockNodeID(current);
                    break;
                }
                case NT_ENDFLOW: 
                case NT_AND_JOIN: 
                case NT_XOR_JOIN: 
                case NT_ENDLOOP: {
                    current = nextNodes[0];
                }
            }
        }
        return nodes;
    }

    public static List<Integer> sortNodes(int[] nodes, final Template t) {
        ArrayList<Integer> nodeCopy = new ArrayList<Integer>();
        int[] nArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            nodeCopy.add(i);
            ++n2;
        }
        Collections.sort(nodeCopy, new Comparator<Integer>(){

            @Override
            public int compare(Integer nodeID1, Integer nodeID2) {
                return t.getNodeBranchID(nodeID1.intValue()) - t.getNodeBranchID(nodeID2.intValue());
            }
        });
        return nodeCopy;
    }

    public static Color getEdgeColor(ProcessConstants.EdgeState state) {
        switch (state) {
            case ES_FALSE: {
                return ColorConstants.gray;
            }
            case ES_TRUE: {
                return ColorConstants.green;
            }
        }
        return null;
    }

    public static Color getNodeColor(ProcessConstants.NodeState state) {
        switch (state) {
            case NS_RUNNING: {
                return veryLightGreen;
            }
            case NS_SELECTED: 
            case NS_SUSPENDED: {
                return ColorConstants.orange;
            }
            case NS_ACTIVATED: {
                return ColorConstants.yellow;
            }
            case NS_ENQUIRED: 
            case NS_COMPLETED: {
                return ColorConstants.green;
            }
            case NS_FAILED: {
                return ColorConstants.red;
            }
            case NS_SKIPPED: {
                return veryLightGray;
            }
        }
        return null;
    }
}

