/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.processvisualisation.model.ModelGlue;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.MultiAnchor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class BlockEditPart
extends DefaultNodeEditPart {
    IFigure containerFigure = null;
    IFigure childFigure;
    Map<Integer, IFigure> childLists = new HashMap<Integer, IFigure>();

    protected Node getCastedModel() {
        return (Node)this.getModel();
    }

    protected void setHorizontalSpacing(int distance) {
        FlowLayout outer = (FlowLayout)this.containerFigure.getLayoutManager();
        outer.setMinorSpacing(distance);
        FlowLayout inner = (FlowLayout)this.childFigure.getLayoutManager();
        if (this.isVertical()) {
            inner.setMajorSpacing(distance);
        } else {
            inner.setMinorSpacing(distance);
        }
        for (IFigure figure : this.childFigure.getChildren()) {
            ((FlowLayout)figure.getLayoutManager()).setMinorSpacing(distance);
        }
    }

    protected void setVerticalSpacing(int distance) {
        FlowLayout outer = (FlowLayout)this.containerFigure.getLayoutManager();
        outer.setMajorSpacing(distance);
        FlowLayout inner = (FlowLayout)this.childFigure.getLayoutManager();
        if (this.isVertical()) {
            inner.setMinorSpacing(distance);
        } else {
            inner.setMajorSpacing(distance);
        }
        for (IFigure figure : this.childFigure.getChildren()) {
            ((FlowLayout)figure.getLayoutManager()).setMajorSpacing(distance);
        }
    }

    protected List getModelChildren() {
        ArrayList<Integer> elements = new ArrayList<Integer>();
        int[] nArray = this.getSuccessors();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int nodeID = nArray[n2];
            elements.add(this.template.getNodeBranchID(nodeID));
            ++n2;
        }
        elements.add((Integer)this.getTemplate().getNode(this.getEndNodeID()));
        return elements;
    }

    protected int[] getSuccessors() {
        return this.getTemplate().getSuccByEdgeType(this.getCastedModel().getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
    }

    protected void addChildVisual(EditPart child, int index) {
        if (!(child.getModel() instanceof Node) && !(child instanceof BranchEditPart)) {
            throw new IllegalArgumentException("This Element cannot be added: " + child);
        }
        if (child.getModel() instanceof Node) {
            if (((Node)child.getModel()).getID() == this.getEndNodeID()) {
                this.containerFigure.add(((AbstractGraphicalEditPart)child).getFigure(), -1);
                return;
            }
        } else {
            this.childFigure.add(((GraphicalEditPart)child).getFigure());
        }
    }

    protected int getEndNodeID() {
        return this.getTemplate().getNodeCorrespondingBlockNodeID(this.getCastedModel().getID());
    }

    protected void removeChildVisual(EditPart child) {
        AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)child;
        if (child instanceof Node && ((Node)child.getModel()).getID() == this.getEndNodeID()) {
            this.containerFigure.remove(part.getFigure());
            return;
        }
        if (this.childFigure.getChildren().contains(part.getFigure())) {
            this.childFigure.remove(part.getFigure());
        }
    }

    @Override
    protected void updateVisuals() {
        super.updateVisuals();
        this.setHorizontalSpacing(this.uiSettings.getHorizontalSpacing());
        this.setVerticalSpacing(this.uiSettings.getVerticalSpacing());
    }

    @Override
    protected IFigure createFigure() {
        this.nodeFigure = ModelGlue.getNodeFigure(this.getTemplate().getNodeType(this.getCastedModel().getID()));
        this.childFigure = this.createChildFigure();
        this.containerFigure = this.createContainerFigure();
        this.containerFigure.add((IFigure)this.nodeFigure);
        this.containerFigure.add(this.childFigure);
        this.anchor = new MultiAnchor(this.nodeFigure.getAnchorFigure(), true, this.getTemplate().getNodeType(this.getCastedModel().getID()) == ProcessConstants.NodeType.NT_STARTLOOP);
        ((MultiAnchor)this.anchor).setPart(this);
        this.updateVisuals();
        return this.containerFigure;
    }

    private IFigure createContainerFigure() {
        Figure figure = new Figure(){

            public Insets getInsets() {
                return new Insets(5);
            }

            public boolean containsPoint(int x, int y) {
                if (BlockEditPart.this.nodeFigure.containsPoint(x, y)) {
                    return true;
                }
                for (Object part : BlockEditPart.this.getChildren()) {
                    if (!((AbstractGraphicalEditPart)part).getFigure().containsPoint(x, y)) continue;
                    return true;
                }
                return false;
            }
        };
        FlowLayout layout = new FlowLayout(true);
        layout.setMinorAlignment(0);
        figure.setLayoutManager((LayoutManager)layout);
        return figure;
    }

    protected IFigure createChildFigure() {
        Figure figure = new Figure();
        FlowLayout layout = new FlowLayout(!this.isVertical());
        layout.setMinorAlignment(0);
        layout.setMajorAlignment(0);
        figure.setLayoutManager((LayoutManager)layout);
        return figure;
    }

    protected boolean isVertical() {
        return this.getTemplate().getNodeType(this.getCastedModel().getID()) == ProcessConstants.NodeType.NT_AND_SPLIT || this.getTemplate().getNodeType(this.getCastedModel().getID()) == ProcessConstants.NodeType.NT_XOR_SPLIT;
    }

    public void refresh() {
        super.refresh();
        this.sortBranches();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.getLayer("Connection Layer").invalidateTree();
    }

    public int getLocationForEdge(Connection conn) {
        for (ConnectionEditPart connectionEditPart : this.getSourceConnections()) {
            if (connectionEditPart.getFigure() != conn) continue;
            Node destNode = (Node)connectionEditPart.getTarget().getModel();
            int branchID = this.template.getNodeBranchID(destNode.getID());
            IFigure figure = null;
            for (Object child : this.getChildren()) {
                if (!(child instanceof BranchEditPart) || (Integer)((BranchEditPart)child).getModel() != branchID) continue;
                figure = ((BranchEditPart)child).getFigure();
                break;
            }
            assert (figure != null);
            return figure.getBounds().getRight().y;
        }
        return 0;
    }

    public int getLocationForLoop() {
        return this.containerFigure.getBounds().getBottom().y + 5;
    }

    public IFigure getContainerFigure() {
        return this.containerFigure;
    }

    public Map<Integer, IFigure> getChildLists() {
        return this.childLists;
    }

    protected void refreshChildren() {
        EditPart editPart;
        HashMap<Object, EditPart> modelToEditPart = new HashMap<Object, EditPart>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            editPart = (EditPart)children.get(i);
            modelToEditPart.put(editPart.getModel(), editPart);
            ++i;
        }
        List modelObjects = this.getModelChildren();
        i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            if (i >= children.size() || !((EditPart)children.get(i)).getModel().equals(model)) {
                editPart = (EditPart)modelToEditPart.get(model);
                if (editPart != null) {
                    this.reorderChild(editPart, i);
                } else {
                    editPart = this.createChild(model);
                    this.addChild(editPart, i);
                }
            }
            ++i;
        }
        ArrayList trash = new ArrayList();
        while (i < children.size()) {
            trash.add(children.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            EditPart ep = (EditPart)trash.get(i);
            this.removeChild(ep);
            ++i;
        }
    }

    private void sortBranches() {
        ArrayList<BranchEditPart> branchEditParts = new ArrayList<BranchEditPart>();
        for (Object editPart : this.getChildren()) {
            if (!(editPart instanceof BranchEditPart)) continue;
            branchEditParts.add((BranchEditPart)editPart);
        }
        Collections.sort(branchEditParts, new Comparator<BranchEditPart>(){

            @Override
            public int compare(BranchEditPart bPart1, BranchEditPart bPart2) {
                return (Integer)bPart1.getModel() - (Integer)bPart2.getModel();
            }
        });
        this.childFigure.getChildren().clear();
        int joinID = this.template.getNodeCorrespondingBlockNodeID(this.getCastedModel().getID());
        int branchID = this.template.getNodeBranchID(joinID);
        BranchEditPart emptyBranchPart = null;
        for (BranchEditPart branchPart : branchEditParts) {
            if ((Integer)branchPart.getModel() != branchID) {
                this.childFigure.add(branchPart.getFigure());
                continue;
            }
            emptyBranchPart = branchPart;
        }
        if (emptyBranchPart != null) {
            this.childFigure.add(emptyBranchPart.getFigure());
        }
    }
}

