/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ConstraintAnchor
extends AbstractConnectionAnchor
implements ConnectionAnchor {
    private final ReferencePoint referencePoint;
    private boolean source;

    public ConstraintAnchor(IFigure owner, ReferencePoint referencePoint, boolean source) {
        super(owner);
        this.referencePoint = referencePoint;
        this.source = source;
    }

    public Point getLocation(Point reference) {
        int horizontal;
        Rectangle r = this.getOwner().getBounds().getCopy();
        this.getOwner().translateToAbsolute((Translatable)r);
        if (this.referencePoint != null) {
            switch (this.referencePoint) {
                case START: {
                    horizontal = 16384;
                    break;
                }
                case COMPLETION: {
                    horizontal = 131072;
                    break;
                }
                default: {
                    horizontal = 0x1000000;
                    break;
                }
            }
        } else {
            horizontal = 0x1000000;
        }
        Point point = this.getCornerLocation(r, horizontal);
        return point;
    }

    private Point getCornerLocation(Rectangle r, int horizontal) {
        int x;
        int y = r.getCenter().y;
        switch (horizontal) {
            case 16384: {
                x = r.x;
                break;
            }
            case 131072: {
                x = r.x + r.width - 1;
                break;
            }
            default: {
                x = r.x + r.width / 2;
            }
        }
        Point point = new Point(x, y);
        return point;
    }

    public static enum ReferencePoint {
        START,
        COMPLETION;

    }
}

