/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ConstraintEdgeConnectionRouter
extends AbstractRouter {
    private static final int DELTA = 15;
    private static final int EPSILON = 45;

    public int getNestingDepth(IFigure figure) {
        IFigure parent = figure.getParent();
        int depth = 0;
        while (parent != null) {
            if (parent instanceof BranchEditPart.BranchFigure) {
                ++depth;
            }
            parent = parent.getParent();
        }
        return depth;
    }

    private int getEndDirection(Connection conn, Rectangle startRect, Rectangle endRect) {
        IFigure start = conn.getSourceAnchor().getOwner();
        IFigure end = conn.getTargetAnchor().getOwner();
        int startDepth = this.getNestingDepth(start);
        int endDepth = this.getNestingDepth(end);
        return this.determineDirection(endRect, startRect, endDepth - startDepth);
    }

    private int getStartDirection(Connection conn, Rectangle startRect, Rectangle endRect) {
        IFigure start = conn.getSourceAnchor().getOwner();
        IFigure end = conn.getTargetAnchor().getOwner();
        int startDepth = this.getNestingDepth(start);
        int endDepth = this.getNestingDepth(end);
        return this.determineDirection(startRect, endRect, startDepth - endDepth);
    }

    private int determineDirection(Rectangle startRect, Rectangle endRect, int nestingDepth) {
        int myCenter = startRect.getCenter().y;
        int myTop = startRect.y();
        int myBottom = startRect.bottom();
        int otherCenter = endRect.getCenter().y;
        int myHeight = startRect.height;
        int vertical = Math.abs(myCenter - otherCenter) < 5 ? 1024 : (myCenter < otherCenter ? (myBottom + myHeight >= otherCenter ? (nestingDepth >= 0 ? 128 : 1024) : 1024) : (myTop - myHeight <= otherCenter ? (nestingDepth >= 0 ? 1024 : 128) : 128));
        return vertical;
    }

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Rectangle startRect = conn.getSourceAnchor().getOwner().getBounds();
        Rectangle endRect = conn.getTargetAnchor().getOwner().getBounds();
        int startNormal = this.getStartDirection(conn, startRect, endRect);
        int endNormal = this.getEndDirection(conn, startRect, endRect);
        int startHeight = startRect.height;
        if (startNormal == 128) {
            startPoint.translate(0, -startHeight / 2);
        } else {
            startPoint.translate(0, startHeight / 2);
        }
        int endHeight = endRect.height;
        if (endNormal == 128) {
            endPoint.translate(0, -endHeight / 2);
        } else {
            endPoint.translate(0, endHeight / 2);
        }
        PointList conPoints = new PointList();
        conPoints.addPoint(startPoint);
        this.determineBendPoints(startPoint, endPoint, startNormal, endNormal, conPoints);
        conPoints.addPoint(endPoint);
        conn.setPoints(conPoints);
    }

    private void determineBendPoints(Point startPoint, Point endPoint, int startNormal, int endNormal, PointList conPoints) {
        Point startDelta = null;
        Point endDelta = null;
        int startX = startPoint.x;
        int startY = startPoint.y;
        int endX = endPoint.x;
        int endY = endPoint.y;
        if (startNormal == 128) {
            if (endX - startX < -45) {
                startDelta = new Point(startX - 15, startY - 15);
            } else if (endX - startX > 45) {
                startDelta = new Point(startX + 15, startY - 15);
            }
        } else if (endX - startX < -45) {
            startDelta = new Point(startX - 15, startY + 15);
        } else if (endX - startX > 45) {
            startDelta = new Point(startX + 15, startY + 15);
        }
        if (endNormal == 128) {
            if (endX - startX < -45) {
                endDelta = new Point(endX + 15, endY - 15);
            } else if (endX - startX > 45) {
                endDelta = new Point(endX - 15, endY - 15);
            }
        } else if (endX - startX < -45) {
            endDelta = new Point(endX + 15, endY + 15);
        } else if (endX - startX > 45) {
            endDelta = new Point(endX - 15, endY + 15);
        }
        if (startDelta != null) {
            conPoints.addPoint(startDelta);
        }
        if (endDelta != null) {
            conPoints.addPoint(endDelta);
        }
    }
}

