/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLag;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.ui.processvisualisation.parts.ConstraintAnchor;
import de.aristaflow.adept2.ui.processvisualisation.parts.ConstraintEdgeConnectionRouter;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ConstraintEdgePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.ui.views.properties.IPropertySource;

public class ConstraintEdgeEditPart
extends EdgeEditPart {
    protected Object getConstraint() {
        TimeLag timeLag = null;
        TimeModelConstants.RelationType[] relationTypeArray = TimeModelConstants.RelationType.values();
        int n = relationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeModelConstants.RelationType r = relationTypeArray[n2];
            timeLag = TimeModelTools.getTimeLag((ConstraintEdge)this.getCastedModel(), (TimeModelConstants.RelationType)r);
            if (timeLag != null) break;
            ++n2;
        }
        return timeLag;
    }

    protected ConstraintEdge getCastedModel() {
        return (ConstraintEdge)this.getModel();
    }

    @Override
    public void updateVisuals() {
        Object constraint = this.getConstraint();
        if (constraint instanceof TimeLag) {
            StringBuilder s = new StringBuilder();
            switch (this.getSourceReferencePoint()) {
                case COMPLETION: {
                    s.append("E");
                    break;
                }
                case START: {
                    s.append("S");
                    break;
                }
            }
            s.append(TimeModelTools.toString((TimeLag)((TimeLag)constraint)));
            switch (this.getTargetReferencePoint()) {
                case COMPLETION: {
                    s.append("E");
                    break;
                }
                case START: {
                    s.append("S");
                    break;
                }
            }
            s.append(" ");
            this.connectionFigure.setText(s.toString());
        } else {
            this.connectionFigure.setText(null);
        }
        this.refresh();
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        this.connectionFigure.setConnectionRouter((ConnectionRouter)new ConstraintEdgeConnectionRouter());
        this.connectionFigure.setVisible(true);
    }

    @Override
    protected IFigure createFigure() {
        this.connectionFigure = new ProcessConnection.ConstraintConnection(this.getCastedModel());
        this.refreshVisuals();
        return this.connectionFigure;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new ConstraintEdgePropertySource(this.getTemplate());
            }
            this.propertySource.setModel(this.getCastedModel());
            return this.propertySource;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public Template getTemplate() {
        return super.getTemplate();
    }

    @Override
    public Instance getInstance() {
        return super.getInstance();
    }

    public ConstraintAnchor.ReferencePoint getTargetReferencePoint() {
        Object constraint = this.getConstraint();
        if (constraint instanceof TimeLag) {
            TimeModelConstants.RelationType relationType = ((TimeLag)constraint).getRelationType();
            switch (relationType) {
                case START_END: 
                case END_END: {
                    return ConstraintAnchor.ReferencePoint.COMPLETION;
                }
                case START_START: 
                case END_START: {
                    return ConstraintAnchor.ReferencePoint.START;
                }
            }
            return null;
        }
        return null;
    }

    public ConstraintAnchor.ReferencePoint getSourceReferencePoint() {
        Object constraint = this.getConstraint();
        if (constraint instanceof TimeLag) {
            TimeModelConstants.RelationType relationType = ((TimeLag)constraint).getRelationType();
            switch (relationType) {
                case START_START: 
                case START_END: {
                    return ConstraintAnchor.ReferencePoint.START;
                }
                case END_START: 
                case END_END: {
                    return ConstraintAnchor.ReferencePoint.COMPLETION;
                }
            }
            return null;
        }
        return null;
    }
}

