/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.DataEdgePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.views.properties.IPropertySource;

public class DataEdgeEditPart
extends EdgeEditPart {
    protected static final Logger logger = LoggerTools.getLogger(DataEdgeEditPart.class);

    private DataEdge getCastedModel() {
        return (DataEdge)this.getModel();
    }

    @Override
    protected IFigure createFigure() {
        this.connectionFigure = new ProcessConnection.DataEdgeConnection();
        this.updateVisuals();
        return this.connectionFigure;
    }

    @Override
    public void updateVisuals() {
        this.uiSettings.getTextProvider().formatLabel(this.connectionFigure, null, null);
        boolean isSystemEdge = false;
        if (this.getTarget() == null || this.getSource() == null) {
            int dataElementID;
            ActivityConstants.AccessType type;
            ActivityConstants.AccessType decisionType = null;
            if (this.getTarget() instanceof DataElementEditPart) {
                type = ActivityConstants.AccessType.SYSTEM_WRITE;
                decisionType = ActivityConstants.AccessType.WRITE;
                dataElementID = ((DataElement)this.getTarget().getModel()).getID();
            } else if (this.getSource() instanceof DataElementEditPart) {
                type = ActivityConstants.AccessType.SYSTEM_READ;
                dataElementID = ((DataElement)this.getSource().getModel()).getID();
            } else {
                return;
            }
            if (decisionType != null && this.handleDecisionEdge(dataElementID, decisionType)) {
                return;
            }
            int[] nodeIDs = this.getTemplate().getAccessingNodeIDsForDataElement(dataElementID, type);
            if (nodeIDs.length != 0) {
                if (nodeIDs.length != 1) {
                    logger.severe("Can't handle more than a single system writer edge");
                }
                isSystemEdge = true;
            }
        } else if (this.getSource() instanceof DataElementEditPart) {
            if (this.getTemplate().getDataEdge(this.destNodeID, this.srcNodeID, ActivityConstants.AccessType.SYSTEM_READ) != null) {
                isSystemEdge = true;
            }
        } else {
            if (this.handleDecisionEdge(this.destNodeID, ActivityConstants.AccessType.WRITE)) {
                return;
            }
            if (this.getTemplate().getDataEdge(this.srcNodeID, this.destNodeID, ActivityConstants.AccessType.SYSTEM_WRITE) != null) {
                isSystemEdge = true;
            }
        }
        if (isSystemEdge) {
            this.connectionFigure.setVisible(this.uiSettings.isSystemDataElementVisible() ? this.uiSettings.isSystemDataEdgeVisible() : false);
        } else {
            this.connectionFigure.setVisible(this.uiSettings.isDataElementsVisible() ? this.uiSettings.isDataEdgesVisible() : false);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateVisuals();
    }

    private boolean handleDecisionEdge(int dataElementID, ActivityConstants.AccessType decisionType) {
        int[] decisionNodeIDs = this.getTemplate().getAccessingNodeIDsForDataElement(dataElementID, decisionType);
        boolean allDecision = false;
        int[] nArray = decisionNodeIDs;
        int n = decisionNodeIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int decisionNodeID = nArray[n2];
            if (this.getTemplate().getNodeType(decisionNodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT && this.getTemplate().getNodeType(decisionNodeID) != ProcessConstants.NodeType.NT_ENDLOOP) {
                allDecision = false;
                break;
            }
            allDecision = true;
            ++n2;
        }
        if (allDecision) {
            this.connectionFigure.setVisible(this.uiSettings.isDecisionDataElementVisible() ? this.uiSettings.isDecisionDataEdgeVisible() : false);
            return true;
        }
        return false;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                EditPart source = this.getSource();
                EditPart target = this.getTarget();
                this.propertySource = source instanceof DataElementEditPart ? (this.getInstance() != null ? new DataEdgePropertySource(this.getInstance(), ((Node)target.getModel()).getID(), ((DataElement)source.getModel()).getID(), this.getCastedModel().getType()) : new DataEdgePropertySource(this.getTemplate(), ((Node)target.getModel()).getID(), ((DataElement)source.getModel()).getID(), this.getCastedModel().getType())) : (this.getInstance() != null ? new DataEdgePropertySource(this.getInstance(), ((Node)source.getModel()).getID(), ((DataElement)target.getModel()).getID(), this.getCastedModel().getType()) : new DataEdgePropertySource(this.getTemplate(), ((Node)source.getModel()).getID(), ((DataElement)target.getModel()).getID(), this.getCastedModel().getType()));
            }
            this.propertySource.setModel(this.getCastedModel());
            return this.propertySource;
        }
        return super.getAdapter(adapter);
    }
}

