/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementAnchor;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.DataElementPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.widgets.DataFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class DataElementEditPart
extends DefaultNodeEditPart {
    private DataElementPropertySource propertySource;

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getSourceConnections().size() > 0 || this.getTargetConnections().size() > 0) {
            Figure f = (Figure)this.getViewer().getEditPartRegistry().get(TemplateEditPart.DataElementID);
            f.revalidate();
        }
    }

    @Override
    protected void updateVisuals() {
        this.uiSettings.getTextProvider().formatLabel(this.nodeFigure, this.getModel(), this.instance);
        int[] writeNodeIDs = this.getTemplate().getAccessingNodeIDsForDataElement(this.getCastedModel().getID(), ActivityConstants.AccessType.WRITE);
        int[] readNodeIDs = this.getTemplate().getAccessingNodeIDsForDataElement(this.getCastedModel().getID(), ActivityConstants.AccessType.READ);
        if (writeNodeIDs.length != 0 && readNodeIDs.length == 0) {
            boolean allDecision = false;
            int[] nArray = writeNodeIDs;
            int n = writeNodeIDs.length;
            int n2 = 0;
            while (n2 < n) {
                int writeNodeID = nArray[n2];
                if (this.getTemplate().getNodeType(writeNodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT && this.getTemplate().getNodeType(writeNodeID) != ProcessConstants.NodeType.NT_ENDLOOP) {
                    allDecision = false;
                    break;
                }
                allDecision = true;
                ++n2;
            }
            if (allDecision) {
                this.nodeFigure.setVisible(this.uiSettings.isDecisionDataElementVisible());
                return;
            }
        }
        boolean isSystemDataElement = false;
        if (readNodeIDs.length == 0 && writeNodeIDs.length == 0 && (this.getTemplate().getAccessingNodeIDsForDataElement(this.getCastedModel().getID(), ActivityConstants.AccessType.SYSTEM_WRITE).length != 0 || this.getTemplate().getAccessingNodeIDsForDataElement(this.getCastedModel().getID(), ActivityConstants.AccessType.SYSTEM_READ).length != 0)) {
            isSystemDataElement = true;
        }
        if (isSystemDataElement) {
            this.nodeFigure.setVisible(this.uiSettings.isSystemDataElementVisible());
        } else {
            this.nodeFigure.setVisible(this.uiSettings.isDataElementsVisible());
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.nodeFigure.setBackgroundColor(color);
    }

    private DataElement getCastedModel() {
        return (DataElement)this.getModel();
    }

    @Override
    protected List getModelSourceConnections() {
        ArrayList<DataEdge> in = new ArrayList<DataEdge>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.dataFlowReadAccess();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            int[] nArray = this.getTemplate().getAccessingNodeIDsForDataElement(this.getCastedModel().getID(), accessType);
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int accessingNodeID = nArray[n4];
                in.add(this.getTemplate().getDataEdge(accessingNodeID, this.getCastedModel().getID(), accessType));
                ++n4;
            }
            ++n2;
        }
        return in;
    }

    @Override
    protected List getModelTargetConnections() {
        ArrayList<DataEdge> out = new ArrayList<DataEdge>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.dataFlowWriteAccess();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            int[] nArray = this.getTemplate().getAccessingNodeIDsForDataElement(this.getCastedModel().getID(), accessType);
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int accessingNodeID = nArray[n4];
                out.add(this.getTemplate().getDataEdge(accessingNodeID, this.getCastedModel().getID(), accessType));
                ++n4;
            }
            ++n2;
        }
        return out;
    }

    @Override
    protected IFigure createFigure() {
        this.nodeFigure = new DataFigure(this);
        ((DataFigure)this.nodeFigure).setVirtual(((DataElement)this.getModel()).isVirtual());
        this.anchor = new DataElementAnchor(this.nodeFigure.getAnchorFigure());
        this.nodeFigure.setBorder(NodeFigure.BORDER_NOTSELECTED);
        this.updateVisuals();
        return this.nodeFigure;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DataElementEditPart.this.logger.info("DataElementEditPart: property change = " + evt.getProperty());
                Object property = evt.getProperty();
                if (property.equals(UpdateManager.DataElementProperties.DE_READERS) || property.equals(UpdateManager.DataElementProperties.DE_SYSTEM_READERS)) {
                    DataElementEditPart.this.refreshSourceConnections();
                } else if (property.equals(UpdateManager.DataElementProperties.DE_WRITERS) || property.equals(UpdateManager.DataElementProperties.DE_SYSTEM_WRITERS)) {
                    DataElementEditPart.this.refreshTargetConnections();
                } else {
                    ((DataFigure)DataElementEditPart.this.nodeFigure).setVirtual(((DataElement)DataElementEditPart.this.getModel()).isVirtual());
                    if (DataElementEditPart.this.instance != null) {
                        DataElementEditPart.this.propertySource = new DataElementPropertySource(DataElementEditPart.this.instance);
                    } else {
                        DataElementEditPart.this.propertySource = new DataElementPropertySource(DataElementEditPart.this.template);
                    }
                }
                DataElementEditPart.this.uiSettings.getTextProvider().formatLabel(DataElementEditPart.this.nodeFigure, (Object)DataElementEditPart.this.getCastedModel(), DataElementEditPart.this.instance);
            }
        });
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = this.instance != null ? new DataElementPropertySource(this.instance) : new DataElementPropertySource(this.template);
            }
            this.propertySource.setModel(this.getCastedModel());
            return this.propertySource;
        }
        return super.getAdapter(adapter);
    }
}

