/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.ui.processvisualisation.widgets.DataFigure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class DataElementLayout
extends AbstractHintLayout {
    private IFigure graph;

    protected Dimension calculatePreferredSize(IFigure container, int origwHint, int orighHint) {
        int wHint = origwHint;
        int hHint = orighHint;
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        Dimension prefSize = new Dimension();
        for (IFigure child : container.getChildren()) {
            prefSize.height = Math.max(prefSize.height, child.getPreferredSize((int)wHint, (int)hHint).height);
        }
        prefSize.width = Math.max(prefSize.width, this.calculateLayout(container, false));
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    public void layout(IFigure parent) {
        this.calculateLayout(parent, true);
    }

    public int calculateLayout(IFigure parent, boolean update) {
        Rectangle relativeArea;
        if (update) {
            this.graph.revalidate();
        }
        WorkingData data = new WorkingData();
        data.area = relativeArea = parent.getClientArea();
        int wHint = -1;
        int hHint = -1;
        wHint = parent.getClientArea().width;
        data.data = new ArrayList(parent.getChildren().size());
        data.rowHeight = 0;
        for (IFigure f : parent.getChildren()) {
            Dimension pref = f.getPreferredSize(wHint, hHint);
            if (!f.isVisible()) {
                pref.width = 1;
            }
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            data.rowHeight = Math.max(data.rowHeight, r.height);
            r.x = f instanceof DataFigure ? ((DataFigure)f).getPreferredLocation() : 0;
            WorkUnit u = new WorkUnit();
            u.figure = f;
            u.bounds = r;
            data.data.add(u);
        }
        Collections.sort(data.data, new Comparator<WorkUnit>(){

            @Override
            public int compare(WorkUnit u1, WorkUnit u2) {
                return u1.bounds.x - u2.bounds.x;
            }
        });
        int minX = 0;
        int maxX = 0;
        for (WorkUnit u : data.data) {
            u.bounds.x = Math.max(minX, u.bounds.x);
            minX = u.bounds.x + u.bounds.width + 5;
            if (update) {
                this.setBoundsOfChild(parent, u.figure, u.bounds);
            }
            maxX = Math.max(maxX, u.bounds.x + u.bounds.width);
        }
        data = null;
        return maxX;
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setDependantFigure(IFigure graph) {
        this.graph = graph;
    }

    static class WorkUnit {
        Rectangle bounds;
        IFigure figure;

        WorkUnit() {
        }

        public String toString() {
            return this.figure + "@" + this.bounds.x;
        }
    }

    static class WorkingData {
        int rowHeight;
        ArrayList<WorkUnit> data;
        Rectangle area;

        WorkingData() {
        }
    }
}

