/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.ui.processvisualisation.ProblemMarker;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.model.ModelGlue;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.ConstraintAnchor;
import de.aristaflow.adept2.ui.processvisualisation.parts.ConstraintEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.ExtendSelectEditPartTracker;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.NodeEditPolicy;
import de.aristaflow.adept2.ui.processvisualisation.parts.ProcessEditPartFactory;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.NodePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import de.aristaflow.adept2.util.LoggerTools;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class DefaultNodeEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
ChangeListener,
IProcessEditPart,
PropertyChangeListener,
IActionFilter {
    public static final String HAS_SUBPROCESS_INSTANCE = "hasSubProcessInstance";
    public static final String HAS_SUBPROCESS = "hasSubProcess";
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    public NodeFigure nodeFigure;
    protected ConnectionAnchor anchor = null;
    private NodePropertySource propertySource;
    protected UISettings uiSettings;
    protected Template template;
    protected Instance instance;
    protected Color backgroundColor;
    private Color textColor;
    private Color borderColor;
    private int currentErrorStatus = -1;

    public void activate() {
        super.activate();
        this.uiSettings.addUIListener(this);
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ProcessEditPartFactory factory = (ProcessEditPartFactory)this.getViewer().getEditPartFactory();
            factory.deactivate((EditPart)this);
            this.uiSettings.removeUIListener(this);
        }
    }

    private Node getCastedModel() {
        return (Node)this.getModel();
    }

    @Override
    public Template getTemplate() {
        if (this.instance != null) {
            return this.instance.getTemplate();
        }
        return this.template;
    }

    @Override
    public void setTemplate(Template t) {
        this.template = t;
    }

    protected List getModelSourceConnections() {
        int i;
        ArrayList<Object> out = new ArrayList<Object>();
        this.addOutEdgesToList(out, ProcessConstants.EdgeType.ET_CONTROL);
        this.addOutEdgesToList(out, ProcessConstants.EdgeType.ET_LOOP);
        this.addOutEdgesToList(out, ProcessConstants.EdgeType.ET_SYNC);
        int[] written = this.getTemplate().getAccessedDataElementIDsForNode(this.getCastedModel().getID(), ActivityConstants.AccessType.WRITE);
        int[] systemWritten = this.getTemplate().getAccessedDataElementIDsForNode(this.getCastedModel().getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
        int[] nArray = written;
        int n = written.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            out.add(this.getTemplate().getDataEdge(this.getCastedModel().getID(), i, ActivityConstants.AccessType.WRITE));
            ++n2;
        }
        nArray = systemWritten;
        n = systemWritten.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            out.add(this.getTemplate().getDataEdge(this.getCastedModel().getID(), i, ActivityConstants.AccessType.SYSTEM_WRITE));
            ++n2;
        }
        for (StructuredConstraintEdge constr : this.getTemplate().getConstraintEdgeStructure()) {
            if (constr.getSourceNodeID() != this.getCastedModel().getID()) continue;
            out.add(constr.getConstraintEdge());
        }
        return out;
    }

    protected void addOutEdgesToList(List<Object> list, ProcessConstants.EdgeType type) {
        int[] edges;
        int[] nArray = edges = this.getTemplate().getSuccByEdgeType(this.getCastedModel().getID(), new ProcessConstants.EdgeType[]{type});
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            list.add(this.getTemplate().getEdge(this.getCastedModel().getID(), i, type));
            ++n2;
        }
    }

    protected List getModelTargetConnections() {
        int i;
        ArrayList<Object> in = new ArrayList<Object>();
        this.addInEdgesToList(in, ProcessConstants.EdgeType.ET_CONTROL);
        this.addInEdgesToList(in, ProcessConstants.EdgeType.ET_LOOP);
        this.addInEdgesToList(in, ProcessConstants.EdgeType.ET_SYNC);
        int[] read = this.getTemplate().getAccessedDataElementIDsForNode(this.getCastedModel().getID(), ActivityConstants.AccessType.READ);
        int[] systemRead = this.getTemplate().getAccessedDataElementIDsForNode(this.getCastedModel().getID(), ActivityConstants.AccessType.SYSTEM_READ);
        int[] nArray = read;
        int n = read.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            in.add(this.getTemplate().getDataEdge(this.getCastedModel().getID(), i, ActivityConstants.AccessType.READ));
            ++n2;
        }
        nArray = systemRead;
        n = systemRead.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            in.add(this.getTemplate().getDataEdge(this.getCastedModel().getID(), i, ActivityConstants.AccessType.SYSTEM_READ));
            ++n2;
        }
        for (StructuredConstraintEdge constr : this.getTemplate().getConstraintEdgeStructure()) {
            if (constr.getDestinationNodeID() != this.getCastedModel().getID()) continue;
            in.add(constr.getConstraintEdge());
        }
        return in;
    }

    protected void addInEdgesToList(List<Object> list, ProcessConstants.EdgeType type) {
        int[] edges;
        int[] nArray = edges = this.getTemplate().getPredByEdgeType(this.getCastedModel().getID(), new ProcessConstants.EdgeType[]{type});
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            int source = nArray[n2];
            list.add(this.getTemplate().getEdge(source, this.getCastedModel().getID(), type));
            ++n2;
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        return new ExtendSelectEditPartTracker((EditPart)this);
    }

    @Deprecated
    public void setSelected(int value) {
        this.nodeFigure.setSelected(value > 0);
        this.nodeFigure.setFocused(value > 1);
        this.logger.info("someone else than the SelectionManager changes the visualSelection and Focus");
    }

    protected IFigure createFigure() {
        ProcessConstants.NodeType type = this.getTemplate().getNodeType(this.getCastedModel().getID());
        this.nodeFigure = ModelGlue.getNodeFigure(type);
        this.anchor = ModelGlue.getNodeAnchor(type, this.nodeFigure.getAnchorFigure());
        this.nodeFigure.setBorder(NodeFigure.BORDER_NOTSELECTED);
        this.updateVisuals();
        return this.nodeFigure;
    }

    protected void updateVisuals() {
        this.uiSettings.getTextProvider().formatLabel(this.nodeFigure, this.getModel(), this.instance);
    }

    private ConnectionAnchor getAnchor() {
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection instanceof ConstraintEdgeEditPart) {
            return new ConstraintAnchor(this.nodeFigure.getAnchorFigure(), ((ConstraintEdgeEditPart)connection).getSourceReferencePoint(), true);
        }
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection instanceof ConstraintEdgeEditPart) {
            return new ConstraintAnchor(this.nodeFigure.getAnchorFigure(), ((ConstraintEdgeEditPart)connection).getTargetReferencePoint(), false);
        }
        return this.getAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[ " + this.getModel() + "]";
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DefaultNodeEditPart.this.logger.info("DefaultNodeEditPart: property change = " + evt.getProperty() + " on node " + DefaultNodeEditPart.this.getCastedModel().getID());
                Object property = evt.getProperty();
                if (property.equals(UpdateManager.NodeProperties.NODE_IN_DATA) || property.equals(UpdateManager.NodeProperties.NODE_IN_EDGES)) {
                    DefaultNodeEditPart.this.refreshTargetConnections();
                    ProcessConstants.NodeType type = DefaultNodeEditPart.this.getTemplate().getNodeType(DefaultNodeEditPart.this.getCastedModel().getID());
                    if (type != ProcessConstants.NodeType.NT_AND_JOIN && type != ProcessConstants.NodeType.NT_XOR_JOIN && type != ProcessConstants.NodeType.NT_ENDLOOP && type != ProcessConstants.NodeType.NT_ENDFLOW) {
                        int modelSplitNodeID = DefaultNodeEditPart.this.getTemplate().getNodeSplitNodeID(DefaultNodeEditPart.this.getCastedModel().getID());
                        EditPart part = DefaultNodeEditPart.this.getParent().getParent();
                        if (part instanceof BlockEditPart && ((BlockEditPart)part).getModel() instanceof Node) {
                            Node splitNode = (Node)((BlockEditPart)part).getModel();
                            if (splitNode.getID() != modelSplitNodeID) {
                                DefaultNodeEditPart.this.getParent().getParent().getParent().refresh();
                            } else {
                                DefaultNodeEditPart.this.getParent().refresh();
                            }
                        }
                    } else {
                        DefaultNodeEditPart.this.getParent().refresh();
                    }
                } else if (property.equals(UpdateManager.NodeProperties.NODE_OUT_DATA) || property.equals(UpdateManager.NodeProperties.NODE_OUT_EDGES)) {
                    DefaultNodeEditPart.this.refreshSourceConnections();
                    ProcessConstants.NodeType type = DefaultNodeEditPart.this.getTemplate().getNodeType(DefaultNodeEditPart.this.getCastedModel().getID());
                    if (type == ProcessConstants.NodeType.NT_AND_JOIN || type == ProcessConstants.NodeType.NT_XOR_JOIN || type == ProcessConstants.NodeType.NT_ENDLOOP || type == ProcessConstants.NodeType.NT_ENDFLOW) {
                        DefaultNodeEditPart.this.getParent().getParent().refresh();
                    } else {
                        DefaultNodeEditPart.this.getParent().refresh();
                    }
                } else {
                    DefaultNodeEditPart.this.uiSettings.getTextProvider().formatLabel(DefaultNodeEditPart.this.nodeFigure, (Object)DefaultNodeEditPart.this.getCastedModel(), DefaultNodeEditPart.this.instance);
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = this.instance != null ? new NodePropertySource(this.instance) : new NodePropertySource(this.getTemplate());
            }
            this.propertySource.setModel(this.getCastedModel());
            return this.propertySource;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void setErrorStatus(int status) {
        if (status == -1 || status > this.currentErrorStatus) {
            this.nodeFigure.setErrorIcon(ProblemMarker.getStatusIcon(status));
            this.currentErrorStatus = status;
        }
    }

    @Override
    public void setUISettings(UISettings settings) {
        this.uiSettings = settings;
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.updateVisuals();
    }

    @Override
    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (color == null && this.instance != null) {
            Color nodeColor = color;
            if (this.instance.getTemplate().getNode(this.getCastedModel().getID()) != null) {
                nodeColor = ModelGlue.getNodeColor(this.instance.getNodeState(this.getCastedModel().getID()));
            }
            this.backgroundColor = nodeColor;
            this.nodeFigure.setBackgroundColor(this.backgroundColor);
        } else {
            this.backgroundColor = color;
            this.nodeFigure.setBackgroundColor(color);
        }
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.nodeFigure.setBorderColor(color);
    }

    @Override
    public void setTextColor(Color color) {
        this.textColor = color;
        this.nodeFigure.setTextColor(color);
    }

    @Override
    public void setFocused(boolean focus) {
        this.nodeFigure.setFocused(focus);
    }

    @Override
    public void setSelected(boolean select) {
        this.nodeFigure.setSelected(select);
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(HAS_SUBPROCESS_INSTANCE) && this.instance != null && !(this.getModel() instanceof DataElement) && !this.instance.getNodeLWPInstanceID(this.getCastedModel().getID()).isEmpty()) {
            return Boolean.valueOf(value);
        }
        if (name.equals(HAS_SUBPROCESS) && !(this.getModel() instanceof DataElement) && (this.getCastedModel().getExecutableBusinessProcess() instanceof LightWeightProcess || this.getCastedModel().getExecutableBusinessProcess() instanceof VariableParallelismEBP)) {
            return Boolean.valueOf(value);
        }
        if (name.equals("isEditable")) {
            return this.instance instanceof ChangeableInstance || this.template instanceof ChangeableTemplate;
        }
        return false;
    }

    public void revealTo(ZoomManager mgr) {
        Point p = this.nodeFigure.getLocation();
        mgr.setViewLocation(new Point(p.x, p.y - 200));
    }
}

