/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.ProblemMarker;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.model.ModelGlue;
import de.aristaflow.adept2.ui.processvisualisation.parts.ExtendSelectEditPartTracker;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.ProcessEditPartFactory;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.EdgePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.widgets.LabelTextFormatter;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class EdgeEditPart
extends AbstractConnectionEditPart
implements ChangeListener,
IProcessEditPart,
PropertyChangeListener,
IActionFilter {
    protected ProcessConnection connectionFigure;
    protected AbstractPropertySource propertySource;
    protected UISettings uiSettings;
    private Template template;
    private Instance instance;
    protected int srcNodeID;
    protected int destNodeID;

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    @Override
    public Template getTemplate() {
        if (this.instance != null) {
            return this.instance.getTemplate();
        }
        return this.template;
    }

    public void activate() {
        super.activate();
        this.uiSettings.addUIListener(this);
        this.updateVisuals();
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ProcessEditPartFactory factory = (ProcessEditPartFactory)this.getViewer().getEditPartFactory();
            factory.deactivate((EditPart)this);
            this.uiSettings.removeUIListener(this);
        }
    }

    protected void createEditPolicies() {
    }

    public DragTracker getDragTracker(Request req) {
        return new ExtendSelectEditPartTracker((EditPart)this);
    }

    private Edge getCastedModel() {
        return (Edge)this.getModel();
    }

    public void setSelected(int value) {
    }

    protected IFigure createFigure() {
        this.connectionFigure = ModelGlue.createFigureForEdge(this.getCastedModel());
        this.updateVisuals();
        return this.connectionFigure;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                EdgeEditPart.this.updateVisuals();
            }
        });
    }

    public void updateVisuals() {
        LabelTextFormatter.EdgeData edgeData = null;
        if (this.getSource() != null && this.getTarget() != null) {
            int startID = ((Node)this.getSource().getModel()).getID();
            int destID = ((Node)this.getTarget().getModel()).getID();
            edgeData = new LabelTextFormatter.EdgeData(startID, destID, this.getCastedModel().getType(), this.getTemplate(), this.instance);
        } else if (this.getSource() != null) {
            int startID = ((Node)this.getSource().getModel()).getID();
            int destID = Integer.MIN_VALUE;
            edgeData = new LabelTextFormatter.EdgeData(startID, destID, this.getCastedModel().getType(), this.getTemplate(), this.instance);
        } else {
            return;
        }
        this.uiSettings.getTextProvider().formatLabel(this.connectionFigure, this.getModel(), edgeData);
    }

    @Override
    public void setErrorStatus(int status) {
        this.connectionFigure.setImage(ProblemMarker.getStatusIcon(status));
    }

    @Override
    public void setUISettings(UISettings settings) {
        this.uiSettings = settings;
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.updateVisuals();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                int startID = ((Node)this.getSource().getModel()).getID();
                int destID = ((Node)this.getTarget().getModel()).getID();
                this.propertySource = this.getInstance() != null ? new EdgePropertySource(this.getInstance(), startID, destID, this.getCastedModel().getType()) : new EdgePropertySource(this.getTemplate(), startID, destID, this.getCastedModel().getType());
            }
            this.propertySource.setModel(this.getCastedModel());
            return this.propertySource;
        }
        return super.getAdapter(adapter);
    }

    public void setSource(EditPart editPart) {
        super.setSource(editPart);
        if (editPart != null) {
            if (editPart.getModel() instanceof Node) {
                this.srcNodeID = ((Node)editPart.getModel()).getID();
            } else if (editPart.getModel() instanceof DataElement) {
                this.srcNodeID = ((DataElement)editPart.getModel()).getID();
            }
        }
    }

    public void setTarget(EditPart editPart) {
        super.setTarget(editPart);
        if (editPart != null) {
            if (editPart.getModel() instanceof Node) {
                this.destNodeID = ((Node)editPart.getModel()).getID();
            } else if (editPart.getModel() instanceof DataElement) {
                this.destNodeID = ((DataElement)editPart.getModel()).getID();
            }
        }
    }

    public int getSourceNodeID() {
        return this.srcNodeID;
    }

    public int getDestNodeID() {
        return this.destNodeID;
    }

    @Override
    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    public void setActive(Color color) {
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.connectionFigure.setForegroundColor(color);
    }

    @Override
    public void setBorderColor(Color color) {
    }

    @Override
    public void setFocused(boolean focus) {
    }

    @Override
    public void setTextColor(Color color) {
    }

    @Override
    public Color getBackgroundColor() {
        return this.connectionFigure.getForegroundColor();
    }

    @Override
    public Color getBorderColor() {
        return null;
    }

    @Override
    public Color getTextColor() {
        return null;
    }

    @Override
    public void setSelected(boolean select) {
        this.connectionFigure.setLineWidth(select ? 2 : 1);
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals("isEditable")) {
            return this.instance instanceof ChangeableInstance || this.template instanceof ChangeableTemplate;
        }
        return false;
    }
}

