/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;

public class LabelLocator
extends ConnectionLocator {
    private static final int MAX_LABEL_WIDTH = 50;

    public LabelLocator(Connection connection) {
        super(connection);
    }

    protected Point getReferencePoint() {
        Point p;
        Connection conn = this.getConnection();
        PointList points = conn.getPoints();
        if (points.size() == 2) {
            p = Point.SINGLETON;
            Point p1 = points.getPoint(0);
            Point p2 = points.getPoint(1);
            conn.translateToAbsolute((Translatable)p1);
            conn.translateToAbsolute((Translatable)p2);
            p.x = (p2.x - p1.x) / 2 + p1.x;
            p.y = (p2.y - p1.y) / 2 + p1.y;
        } else {
            p = points.getPoint(1);
            conn.translateToAbsolute((Translatable)p);
        }
        if (points.getFirstPoint().y == p.y) {
            this.setRelativePosition(1);
        } else if (points.getFirstPoint().y < p.y) {
            if (Math.abs(points.getFirstPoint().x - p.x) < Math.abs(points.getLastPoint().x - p.x)) {
                this.setRelativePosition(12);
            } else {
                this.setRelativePosition(12);
            }
        } else if (Math.abs(points.getFirstPoint().x - p.x) < Math.abs(points.getLastPoint().x - p.x)) {
            this.setRelativePosition(9);
        } else {
            this.setRelativePosition(9);
        }
        return p;
    }

    public void relocate(IFigure target) {
        Dimension fullSize = target.getPreferredSize();
        Dimension prefSize = new Dimension(50, fullSize.height);
        if (fullSize.width < prefSize.width) {
            prefSize = fullSize;
        }
        Point center = this.getReferencePoint();
        target.translateToRelative((Translatable)center);
        target.setBounds(this.getNewBounds(prefSize, center));
    }
}

