/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementAnchor;
import de.aristaflow.adept2.ui.processvisualisation.parts.MultiAnchor;
import de.aristaflow.adept2.ui.processvisualisation.parts.NodeAnchor;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;

public class ProcessConnectionRouter
extends AbstractRouter {
    public static final String ROUTE_LOOP = "LOOP_EDGE";
    private UISettings uiSettings;

    public ProcessConnectionRouter(UISettings settings) {
        this.uiSettings = settings;
    }

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            throw new IllegalArgumentException("Can't route to null anchor!");
        }
        PointList points = conn.getPoints();
        points.removeAllPoints();
        Point start = this.getStartPoint(conn);
        Point end = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)start);
        conn.translateToRelative((Translatable)end);
        int bendDistance = this.uiSettings.getHorizontalSpacing();
        if (conn.getSourceAnchor() instanceof DataElementAnchor) {
            start = conn.getSourceAnchor().getLocation(null);
            end = ((NodeAnchor)conn.getTargetAnchor()).getDataLocation();
            conn.translateToRelative((Translatable)start);
            conn.translateToRelative((Translatable)end);
        } else if (conn.getTargetAnchor() instanceof DataElementAnchor) {
            start = ((NodeAnchor)conn.getSourceAnchor()).getDataLocation();
            end = conn.getTargetAnchor().getLocation(null);
            conn.translateToRelative((Translatable)start);
            conn.translateToRelative((Translatable)end);
        } else if (conn instanceof ProcessConnection.SyncConnection) {
            start = ((NodeAnchor)conn.getSourceAnchor()).getSyncLocation(conn.getTargetAnchor().getReferencePoint());
            end = ((NodeAnchor)conn.getTargetAnchor()).getSyncLocation(conn.getSourceAnchor().getReferencePoint());
            conn.translateToRelative((Translatable)start);
            conn.translateToRelative((Translatable)end);
        } else if (Math.abs(start.x - end.x) >= 10) {
            if (conn.getSourceAnchor() instanceof MultiAnchor && conn.getTargetAnchor() instanceof MultiAnchor) {
                MultiAnchor source = (MultiAnchor)conn.getSourceAnchor();
                MultiAnchor target = (MultiAnchor)conn.getTargetAnchor();
                if (source.isLoop() && target.isLoop() && conn.getRoutingConstraint() == ROUTE_LOOP) {
                    int y = 0;
                    if (target.getPart() != null) {
                        y = target.getPart().getLocationForLoop();
                    } else if (source.getPart() != null) {
                        y = source.getPart().getLocationForLoop();
                    } else {
                        throw new RuntimeException("Can't route loop connection: MultiAnchor has no attached EditPart!");
                    }
                    points.addPoint(source.getLoopAnchor().x, y);
                    points.addPoint(target.getLoopAnchor().x, y);
                    start = source.getLoopAnchor();
                    end = target.getLoopAnchor();
                } else if (source.isStart() && target.isEnd()) {
                    int y = source.getPart().getLocationForEdge(conn);
                    if (Math.abs(start.y - y) >= 15) {
                        points.addPoint(Math.min(start.x + bendDistance, end.x), y);
                        points.addPoint(Math.max(end.x - bendDistance, start.x), y);
                    }
                } else if (source.isEnd() && target.isEnd()) {
                    if (Math.abs(start.y - end.y) > 2) {
                        points.addPoint(Math.max(end.x - bendDistance, start.x), start.y);
                    }
                } else if (Math.abs(start.y - end.y) > 2) {
                    points.addPoint(Math.min(start.x + bendDistance, end.x), end.y);
                }
            } else if (conn.getSourceAnchor() instanceof MultiAnchor) {
                if (Math.abs(start.y - end.y) > 2) {
                    points.addPoint(start.x + bendDistance, end.y);
                }
            } else if (conn.getTargetAnchor() instanceof MultiAnchor && Math.abs(start.y - end.y) > 2) {
                points.addPoint(Math.max(end.x - bendDistance, start.x), start.y);
            }
        }
        points.insertPoint(start, 0);
        points.addPoint(end);
        conn.setPoints(points);
    }
}

