/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.ConstraintEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.SyncEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class ProcessEditPartFactory
implements EditPartFactory {
    private UpdateManager updateManager;
    UISettings uiSettings;
    protected Template template;
    private Instance instance;

    public ProcessEditPartFactory(UpdateManager updateManager, UISettings settings, Template template, Instance instance) {
        this.updateManager = updateManager;
        this.uiSettings = settings;
        this.template = template;
        this.instance = instance;
    }

    public EditPart createEditPart(EditPart context, Object modelElement) {
        EditPart part = this.getPartForElement(modelElement);
        part.setModel(modelElement);
        if (!(part instanceof BranchEditPart)) {
            this.updateManager.addListener(modelElement, (ChangeListener)part);
        }
        if (part instanceof IProcessEditPart) {
            IProcessEditPart processEditPart = (IProcessEditPart)part;
            processEditPart.setUISettings(this.uiSettings);
            processEditPart.setTemplate(this.getTemplate());
            processEditPart.setInstance(this.instance);
        }
        return part;
    }

    public void deactivate(EditPart part) {
        if (part instanceof ChangeListener) {
            this.updateManager.removeListener(part.getModel(), (ChangeListener)part);
        }
    }

    private EditPart getPartForElement(Object modelElement) {
        if (modelElement instanceof Node) {
            switch (this.getTemplate().getNodeType(((Node)modelElement).getID())) {
                case NT_STARTFLOW: 
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: 
                case NT_STARTLOOP: {
                    return new BlockEditPart();
                }
            }
            return new DefaultNodeEditPart();
        }
        if (modelElement instanceof Template) {
            return new TemplateEditPart();
        }
        if (modelElement instanceof Instance) {
            return new TemplateEditPart();
        }
        if (modelElement instanceof ConstraintEdge) {
            return new ConstraintEdgeEditPart();
        }
        if (modelElement instanceof Edge) {
            if (((Edge)modelElement).getType() == ProcessConstants.EdgeType.ET_SYNC) {
                return new SyncEdgeEditPart();
            }
            if (((Edge)modelElement).getType() == ProcessConstants.EdgeType.ET_CONSTRAINT) {
                return new ConstraintEdgeEditPart();
            }
            return new EdgeEditPart();
        }
        if (modelElement instanceof DataElement) {
            return new DataElementEditPart();
        }
        if (modelElement instanceof DataEdge) {
            return new DataEdgeEditPart();
        }
        if (modelElement instanceof Integer) {
            return new BranchEditPart();
        }
        throw new RuntimeException("Can't find an EditPart for " + modelElement);
    }

    protected Template getTemplate() {
        if (this.instance != null) {
            return this.instance.getTemplate();
        }
        return this.template;
    }
}

