/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.parts;

import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementLayout;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.ProcessConnectionRouter;
import de.aristaflow.adept2.ui.processvisualisation.parts.ProcessEditPartFactory;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.TemplatePropertySource;
import de.aristaflow.adept2.util.LoggerTools;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class TemplateEditPart
extends AbstractGraphicalEditPart
implements ChangeListener,
PropertyChangeListener,
IProcessEditPart,
IActionFilter {
    public static final String HAS_PARENT_PROCESS = "hasParentProcess";
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    public static final Object DataElementID = new Object();
    private TemplatePropertySource propertySource;
    protected UISettings uiSettings;
    IFigure parentFigure;
    IFigure graphFigure = null;
    IFigure datablockFigure;
    private Template template;
    private Instance instance;

    public void activate() {
        super.activate();
        this.uiSettings.addUIListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ProcessEditPartFactory factory = (ProcessEditPartFactory)this.getViewer().getEditPartFactory();
        factory.deactivate((EditPart)this);
        this.uiSettings.removeUIListener(this);
    }

    @Override
    public void setUISettings(UISettings settings) {
        this.uiSettings = settings;
    }

    public DragTracker getDragTracker(Request request) {
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
    }

    protected IFigure createFigure() {
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ProcessConnectionRouter(this.uiSettings));
        if (Activator.useAdvancedGraphics) {
            connLayer.setAntialias(1);
        }
        this.graphFigure = this.createGraphFigure();
        this.datablockFigure = this.createDatablockFigure(this.graphFigure);
        this.getViewer().getEditPartRegistry().put(DataElementID, this.datablockFigure);
        this.parentFigure = this.createParentFigure();
        this.parentFigure.add(this.datablockFigure);
        this.parentFigure.add(this.graphFigure);
        Figure group = new Figure();
        FlowLayout layout = new FlowLayout(false);
        layout.setMajorAlignment(0);
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(true);
        group.setLayoutManager((LayoutManager)layout);
        group.add(this.parentFigure);
        this.updateVisuals();
        return group;
    }

    protected IFigure createGraphFigure() {
        Figure figure = Activator.useAdvancedGraphics ? new Figure(){

            public void paint(Graphics graphics) {
                graphics.setAntialias(1);
                super.paint(graphics);
            }
        } : new Figure();
        figure.setLayoutManager((LayoutManager)new FlowLayout());
        return figure;
    }

    protected IFigure createParentFigure() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setStretchMinorAxis(true);
        Figure figure = new Figure();
        figure.setBorder((Border)new MarginBorder(20));
        figure.setLayoutManager((LayoutManager)layout);
        figure.setOpaque(true);
        figure.setBackgroundColor(ColorConstants.white);
        return figure;
    }

    protected IFigure createDatablockFigure(IFigure graph) {
        DataElementLayout layout = new DataElementLayout();
        layout.setDependantFigure(graph);
        Figure figure = new Figure();
        figure.setLayoutManager((LayoutManager)layout);
        RectangleFigure placeholder = new RectangleFigure();
        placeholder.setSize(0, 100);
        placeholder.setVisible(false);
        figure.add((IFigure)placeholder);
        return figure;
    }

    private Template getCastedModel() {
        return (Template)this.getModel();
    }

    protected void addChildVisual(EditPart child, int index) {
        IFigure figure = ((AbstractGraphicalEditPart)child).getFigure();
        if (child.getModel() instanceof Node) {
            this.graphFigure.add(figure);
        } else if (child.getModel() instanceof DataElement) {
            this.datablockFigure.add(figure);
        } else {
            throw new IllegalArgumentException("This Element cannot be added: " + child);
        }
    }

    protected List getModelChildren() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(this.getCastedModel().getStartNode());
        for (DataElement data : this.getCastedModel().getDataElements()) {
            nodes.add(data);
        }
        return nodes;
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TemplateEditPart.this.logger.info("Unhandled Property change: " + evt);
                TemplateEditPart.this.refresh();
            }
        });
    }

    protected void removeChildVisual(EditPart child) {
        AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)child;
        if (child instanceof DataElementEditPart) {
            this.datablockFigure.remove(part.getFigure());
        }
        if (part.getModel() instanceof Node) {
            this.graphFigure.remove(part.getFigure());
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = this.instance != null ? new TemplatePropertySource(this.instance) : new TemplatePropertySource(this.getCastedModel());
            }
            this.propertySource.setModel(this.getCastedModel());
            return this.propertySource;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.updateVisuals();
    }

    protected void updateVisuals() {
    }

    public void setFgColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    @Override
    public void setErrorStatus(int status) {
        System.out.println("Error: TemplateEditPart does not implement error status..");
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public Color getFGColor() {
        return this.getFigure().getForegroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getFigure().setBackgroundColor(color);
    }

    @Override
    public void setBorderColor(Color color) {
    }

    @Override
    public void setFocused(boolean focus) {
    }

    @Override
    public void setTextColor(Color color) {
    }

    @Override
    public Color getBackgroundColor() {
        return this.getFigure().getBackgroundColor();
    }

    @Override
    public Color getBorderColor() {
        return null;
    }

    @Override
    public Color getTextColor() {
        return null;
    }

    @Override
    public void setSelected(boolean select) {
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(HAS_PARENT_PROCESS) && this.instance != null && this.instance.getParentEBPReference() != null) {
            return Boolean.valueOf(value);
        }
        if (name.equals("isEditable")) {
            return this.instance instanceof ChangeableInstance || this.template instanceof ChangeableTemplate;
        }
        return false;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }
}

