/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "de.aristaflow.adept2.ui.processvisualisation.preferences.EditorPreferencesPage";
    private UISettings uiSettings;
    protected final Logger logger;
    protected List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();

    public EditorPreferencesPage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Default Editor Display Options");
        this.logger = LoggerTools.getLogger((Object)((Object)this));
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new UIBooleanFieldEditor("EditorDataEdgesVisiblePreference", "Data E&dges Visible", this.getFieldEditorParent()));
        UIBooleanFieldEditor dataElements = new UIBooleanFieldEditor("EditorDataElementsVisiblePreference", "Data E&lements Visible", this.getFieldEditorParent());
        dataElements.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)dataElements);
        this.addField((FieldEditor)new UIBooleanFieldEditor("EditorSystemDataEdgesVisiblePreference", "System Data E&dges Visible", this.getFieldEditorParent()));
        UIBooleanFieldEditor systemDataElements = new UIBooleanFieldEditor("EditorSystemDataElementsVisiblePreference", "System Data E&lements Visible", this.getFieldEditorParent());
        systemDataElements.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)systemDataElements);
        this.addField((FieldEditor)new UIBooleanFieldEditor("EditorDecisionDataEdgesVisiblePreference", "Decision Data E&dges Visible", this.getFieldEditorParent()));
        UIBooleanFieldEditor decisionDataElements = new UIBooleanFieldEditor("EditorDecisionDataElementVisiblePreference", "Decision Data E&lements Visible", this.getFieldEditorParent());
        decisionDataElements.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)decisionDataElements);
        this.addField((FieldEditor)new UIBooleanFieldEditor("EdiorSyncEdgeVisiblePreference", "&Sync Edges Visible", this.getFieldEditorParent()));
        this.addField((FieldEditor)new UIBooleanFieldEditor("EditorDependencyVisibilityModePreference", "&Dependency Visibility Mode", this.getFieldEditorParent()));
        this.addField((FieldEditor)new UIBooleanFieldEditor("EditorScrollToChanges", "Scroll to &Changed Nodes", this.getFieldEditorParent()));
        this.addField((FieldEditor)new UIIntegerFieldEditor("EditorHorizontalSpacingPreference", "Horizontal Spacing:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new UIIntegerFieldEditor("EditorVerticalSpacingPreference", "Vertical Spacing:", this.getFieldEditorParent()));
        String[][] values = new String[][]{{"Default", "default"}, {"Enabled", "true"}, {"Disabled", "false"}};
        this.addField((FieldEditor)new ComboFieldEditor("AntiAliasing", "Use Advanced Graphics (requires restart)", values, this.getFieldEditorParent()));
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fieldEditors.add(editor);
    }

    public void init(IWorkbench workbench) {
    }

    protected UISettings getUISettings() {
        return this.uiSettings;
    }

    public void applyData(Object data) {
        if (data instanceof UISettings) {
            this.uiSettings = (UISettings)data;
            this.setDescription("Editor Display Options for current Editor");
            for (FieldEditor f : this.fieldEditors) {
                f.load();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor editor;
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource() instanceof UIBooleanFieldEditor && ((UIBooleanFieldEditor)((Object)event.getSource())).getPreferenceName().equals("EditorDataElementsVisiblePreference")) {
            FieldEditor editor2 = this.getFieldEditor("EditorDataEdgesVisiblePreference");
            if (editor2 != null) {
                if (((Boolean)event.getNewValue()).booleanValue()) {
                    editor2.setEnabled(true, this.getFieldEditorParent());
                } else {
                    ((UIBooleanFieldEditor)editor2).setEnabled(false, this.getFieldEditorParent());
                }
            }
        } else if (event.getProperty().equals("field_editor_value") && event.getSource() instanceof UIBooleanFieldEditor && ((UIBooleanFieldEditor)((Object)event.getSource())).getPreferenceName().equals("EditorSystemDataElementsVisiblePreference")) {
            FieldEditor editor3 = this.getFieldEditor("EditorSystemDataEdgesVisiblePreference");
            if (editor3 != null) {
                if (((Boolean)event.getNewValue()).booleanValue()) {
                    editor3.setEnabled(true, this.getFieldEditorParent());
                } else {
                    ((UIBooleanFieldEditor)editor3).setEnabled(false, this.getFieldEditorParent());
                }
            }
        } else if (event.getProperty().equals("field_editor_value") && event.getSource() instanceof UIBooleanFieldEditor && ((UIBooleanFieldEditor)((Object)event.getSource())).getPreferenceName().equals("EditorDecisionDataElementVisiblePreference") && (editor = this.getFieldEditor("EditorDecisionDataEdgesVisiblePreference")) != null) {
            if (((Boolean)event.getNewValue()).booleanValue()) {
                editor.setEnabled(true, this.getFieldEditorParent());
            } else {
                ((UIBooleanFieldEditor)editor).setEnabled(false, this.getFieldEditorParent());
            }
        }
    }

    public FieldEditor getFieldEditor(String preferenceName) {
        FieldEditor searchedEditor = null;
        for (FieldEditor editor : this.fieldEditors) {
            if (!editor.getPreferenceName().equals(preferenceName)) continue;
            searchedEditor = editor;
        }
        return searchedEditor;
    }

    protected class UIBooleanFieldEditor
    extends BooleanFieldEditor {
        private Composite parent;

        public UIBooleanFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
            this.parent = parent;
        }

        protected void doLoad() {
            if (EditorPreferencesPage.this.getUISettings() != null) {
                Button checkBox = this.getChangeControl(this.parent);
                if (checkBox != null) {
                    checkBox.setSelection(EditorPreferencesPage.this.getUISettings().getBooleanValue(this.getPreferenceName()));
                    checkBox.notifyListeners(13, new Event());
                }
                if (this.getPreferenceName().equals("EditorDataEdgesVisiblePreference") && !EditorPreferencesPage.this.getUISettings().isDataElementsVisible()) {
                    this.setEnabled(false, this.parent);
                } else if (this.getPreferenceName().equals("EditorSystemDataEdgesVisiblePreference") && !EditorPreferencesPage.this.getUISettings().isSystemDataElementVisible()) {
                    this.setEnabled(false, this.parent);
                } else if (this.getPreferenceName().equals("EditorDecisionDataEdgesVisiblePreference") && !EditorPreferencesPage.this.getUISettings().isDecisionDataElementVisible()) {
                    this.setEnabled(false, this.parent);
                }
            } else {
                super.doLoad();
                if (this.getPreferenceName().equals("EditorDataEdgesVisiblePreference") && !this.getPreferenceStore().getBoolean("EditorDataElementsVisiblePreference")) {
                    this.setEnabled(false, this.parent);
                } else if (this.getPreferenceName().equals("EditorSystemDataEdgesVisiblePreference") && !this.getPreferenceStore().getBoolean("EditorSystemDataElementsVisiblePreference")) {
                    this.setEnabled(false, this.parent);
                } else if (this.getPreferenceName().equals("EditorDecisionDataEdgesVisiblePreference") && !this.getPreferenceStore().getBoolean("EditorDecisionDataElementVisiblePreference")) {
                    this.setEnabled(false, this.parent);
                }
            }
        }

        protected void doLoadDefault() {
            if (EditorPreferencesPage.this.getUISettings() != null) {
                Button checkBox = this.getChangeControl(this.parent);
                if (checkBox != null) {
                    boolean value = this.getPreferenceStore().getBoolean(this.getPreferenceName());
                    checkBox.setSelection(value);
                    checkBox.notifyListeners(13, new Event());
                }
            } else {
                Button checkBox = this.getChangeControl(this.parent);
                if (checkBox != null) {
                    this.setEnabled(true, this.parent);
                }
                super.doLoadDefault();
            }
        }

        protected void doStore() {
            if (EditorPreferencesPage.this.getUISettings() != null) {
                EditorPreferencesPage.this.getUISettings().setValue(this.getPreferenceName(), this.getBooleanValue());
            } else {
                super.doStore();
            }
        }
    }

    protected class UIIntegerFieldEditor
    extends IntegerFieldEditor {
        public UIIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void doLoad() {
            if (EditorPreferencesPage.this.getUISettings() != null) {
                Text text = this.getTextControl();
                if (text != null) {
                    text.setText("" + EditorPreferencesPage.this.getUISettings().getIntValue(this.getPreferenceName()));
                }
            } else {
                super.doLoad();
            }
        }

        protected void doStore() {
            if (EditorPreferencesPage.this.getUISettings() != null) {
                EditorPreferencesPage.this.getUISettings().setValue(this.getPreferenceName(), this.getIntValue());
            } else {
                super.doStore();
            }
        }
    }
}

