/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedComboBoxPropertyDescriptor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedPropertyDescriptor;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class AbstractPropertySource
implements IPropertySource {
    protected final Logger logger;
    protected Object model;
    protected List<IPropertyDescriptor> descriptors;
    protected Template template;
    protected Instance instance;

    public AbstractPropertySource(Template template) {
        this.setTemplate(template);
        this.logger = LoggerTools.getLogger((Object)this);
    }

    public AbstractPropertySource(Instance instance) {
        this.setInstance(instance);
        this.logger = LoggerTools.getLogger((Object)this);
    }

    protected void setTemplate(Template template) {
        this.template = template;
    }

    protected void setInstance(Instance instance) {
        this.instance = instance;
        this.setTemplate(instance.getTemplate());
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.createDescriptor();
        }
        return this.descriptors.toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    protected abstract List<IPropertyDescriptor> createDescriptor();

    public Object getPropertyValue(Object id) {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    protected abstract boolean hasValueChanged(Object var1, Object var2);

    protected abstract void changePropertyValue(Object var1, Object var2);

    public final void setPropertyValue(Object id, Object value) {
        if (this.hasValueChanged(id, value)) {
            this.changePropertyValue(id, value);
        }
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public boolean arePropertiesChangeable(Object ... ids) {
        return false;
    }

    protected void startChangeTransaction() {
        if (this.instance != null) {
            StartTransaction.performOperation((ChangeableInstance)this.getChangeableInstance(), (UpdateManager)Activator.getService().getUpdateManager());
        } else {
            StartTransaction.performOperation((ChangeableTemplate)this.getChangeableTemplate(), (UpdateManager)Activator.getService().getUpdateManager());
        }
    }

    protected abstract void refreshModel(Template var1);

    protected void endChangeTransaction(String transactionLabel) {
        if (this.instance != null) {
            EndTransaction.performOperation((ChangeableInstance)this.getChangeableInstance(), (UpdateManager)Activator.getService().getUpdateManager(), (String)transactionLabel);
        } else {
            EndTransaction.performOperation((ChangeableTemplate)this.getChangeableTemplate(), (UpdateManager)Activator.getService().getUpdateManager(), (String)transactionLabel);
        }
    }

    protected GraphicalViewer getViewer() {
        GraphicalViewer viewer = null;
        IEditorPart pv = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (pv instanceof ProcessVisualiser) {
            viewer = ((ProcessVisualiser)pv).getGraphicalViewer();
        }
        return viewer;
    }

    protected boolean isChangeableTemplate() {
        return this.template instanceof ChangeableTemplate;
    }

    protected ChangeableTemplate getChangeableTemplate() {
        return this.template instanceof ChangeableTemplate ? (ChangeableTemplate)this.template : null;
    }

    protected ChangeableInstance getChangeableInstance() {
        ChangeableInstance changeableInstance = null;
        if (this.instance != null && this.instance instanceof ChangeableInstance) {
            changeableInstance = (ChangeableInstance)this.instance;
        }
        return changeableInstance;
    }

    public Template getTemplate() {
        return this.template;
    }

    protected PropertyDescriptor addDescriptor(List<IPropertyDescriptor> desc, String PROPERTY, String description, String category) {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)PROPERTY, description);
        descriptor.setCategory(category);
        desc.add((IPropertyDescriptor)descriptor);
        return descriptor;
    }

    protected PropertyDescriptor addTextDescriptor(List<IPropertyDescriptor> desc, String PROPERTY, String description, String category) {
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)PROPERTY, description);
        descriptor.setCategory(category);
        desc.add((IPropertyDescriptor)descriptor);
        return descriptor;
    }

    protected PropertyDescriptor addComboDescriptor(List<IPropertyDescriptor> desc, String PROPERTY, String description, String category, String[] valuesArray) {
        ComboBoxPropertyDescriptor descriptor = new ComboBoxPropertyDescriptor((Object)PROPERTY, description, valuesArray);
        descriptor.setCategory(category);
        desc.add((IPropertyDescriptor)descriptor);
        return descriptor;
    }

    protected PropertyDescriptor addExtendedComboBoxDescriptor(List<IPropertyDescriptor> desc, String PROPERTY, String description, String category, String[] valuesArray) {
        ExtendedComboBoxPropertyDescriptor descriptor = new ExtendedComboBoxPropertyDescriptor(PROPERTY, description, valuesArray, this);
        descriptor.setCategory(category);
        desc.add((IPropertyDescriptor)descriptor);
        return descriptor;
    }

    protected PropertyDescriptor addExtendedDescriptor(List<IPropertyDescriptor> desc, String PROPERTY, String description, String category, Class<?> cellEditor, LabelProvider provider) {
        ExtendedPropertyDescriptor descriptor = new ExtendedPropertyDescriptor(PROPERTY, description, cellEditor, this.instance, this.template);
        descriptor.setLabelProvider((ILabelProvider)provider);
        descriptor.setCategory(category);
        desc.add((IPropertyDescriptor)descriptor);
        return descriptor;
    }

    protected PropertyDescriptor addIntegerDescriptor(List<IPropertyDescriptor> desc, String PROPERTY, String description, String category) {
        PropertyDescriptor descriptor = this.addDescriptor(desc, PROPERTY, description, category);
        descriptor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return "Value has to be an Integer";
                }
                return null;
            }
        });
        return descriptor;
    }
}

