/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.core.changeoperations.UpdateExecutableBusinessProcess;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExecutableBusinessProcessPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExecutionControlPropertiesLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExecutionControlPropertiesPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.MetaDataCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.MetaDataPropertySource;
import java.util.List;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ActivityPropertySource
extends ExecutableBusinessProcessPropertySource {
    private static final String PROPERTY_ACTIVITY_TEMPLATE_ID = String.valueOf(ID) + "/ActivityTemplateID";
    private static final String PROPERTY_EXECUTABLE_COMPONENT_NAME = String.valueOf(ID) + "/ExecutableComponentName";
    private static final String PROPERTY_TEST_MODE = String.valueOf(ID) + "/TestMode";
    private static final String PROPERTY_OPERATION_NAME = String.valueOf(ID) + "/OperationName";
    private static final String PROPERTY_ACTIVITY_CONFIGURATION = String.valueOf(ID) + "/ActivityConfiguration";
    private static final String PROPERTY_EXECUTION_CONTROL_PROPERTIES = String.valueOf(ID) + "/ExecutionControlProperties";
    private static final String PROPERTY_CONFIGURATION_NAME = String.valueOf(ID) + "/ConfigurationName";
    private MetaDataPropertySource metaDataPropertySource;
    private ExecutionControlPropertiesPropertySource executionControlPropertiesPropertySource;

    public ActivityPropertySource(Template template, Node node) {
        super(template, node);
    }

    public ActivityPropertySource(Instance instance, Node node) {
        super(instance, node);
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        List<IPropertyDescriptor> desc = super.createDescriptor();
        this.addDescriptor(desc, PROPERTY_ACTIVITY_TEMPLATE_ID, "Activity Template ID", "Misc");
        this.addExtendedDescriptor(desc, PROPERTY_EXECUTION_CONTROL_PROPERTIES, "Execution Control Properties", "Misc", null, new ExecutionControlPropertiesLabelProvider());
        this.addDescriptor(desc, PROPERTY_EXECUTABLE_COMPONENT_NAME, "Executable Component Name", "Misc");
        this.addDescriptor(desc, PROPERTY_TEST_MODE, "Test Mode", "Misc");
        this.addDescriptor(desc, PROPERTY_OPERATION_NAME, "Operation Name", "Misc");
        if (this.instance != null) {
            if (this.arePropertiesChangeable(PROPERTY_ACTIVITY_CONFIGURATION)) {
                this.addExtendedDescriptor(desc, PROPERTY_ACTIVITY_CONFIGURATION, "Activity Configuration", "Misc", MetaDataCellEditor.class, new MetaDataLabelProvider());
            } else {
                this.addExtendedDescriptor(desc, PROPERTY_ACTIVITY_CONFIGURATION, "Activity Configuration", "Misc", null, new MetaDataLabelProvider());
            }
            if (this.arePropertiesChangeable(PROPERTY_CONFIGURATION_NAME)) {
                this.addTextDescriptor(desc, PROPERTY_CONFIGURATION_NAME, "Configuration Name", "Misc");
            } else {
                this.addDescriptor(desc, PROPERTY_CONFIGURATION_NAME, "Configuration Name", "Misc");
            }
        } else if (this.isChangeableTemplate()) {
            this.addTextDescriptor(desc, PROPERTY_CONFIGURATION_NAME, "Configuration Name", "Misc");
            this.addExtendedDescriptor(desc, PROPERTY_ACTIVITY_CONFIGURATION, "Activity Configuration", "Misc", MetaDataCellEditor.class, new MetaDataLabelProvider());
        } else {
            this.addDescriptor(desc, PROPERTY_CONFIGURATION_NAME, "Configuration Name", "Misc");
            this.addExtendedDescriptor(desc, PROPERTY_ACTIVITY_CONFIGURATION, "Activity Configuration", "Misc", null, new MetaDataLabelProvider());
        }
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_ACTIVITY_TEMPLATE_ID)) {
            return this.getActivity().getID().toString();
        }
        if (id.equals(PROPERTY_EXECUTION_CONTROL_PROPERTIES)) {
            if (this.executionControlPropertiesPropertySource == null) {
                this.executionControlPropertiesPropertySource = this.instance != null ? new ExecutionControlPropertiesPropertySource(this.instance) : new ExecutionControlPropertiesPropertySource(this.getTemplate());
            }
            this.executionControlPropertiesPropertySource.setModel(this.model);
            return this.executionControlPropertiesPropertySource;
        }
        if (id.equals(PROPERTY_EXECUTABLE_COMPONENT_NAME)) {
            return this.getActivity().getExecutableComponentName();
        }
        if (id.equals(PROPERTY_TEST_MODE)) {
            return this.getActivity().supportsTestExecution();
        }
        if (id.equals(PROPERTY_OPERATION_NAME)) {
            return this.getActivity().getOperationName();
        }
        if (id.equals(PROPERTY_ACTIVITY_CONFIGURATION)) {
            if (this.metaDataPropertySource == null) {
                this.metaDataPropertySource = this.instance != null ? new MetaDataPropertySource(this.instance, this.getNode()) : new MetaDataPropertySource(this.getTemplate(), this.getNode());
            }
            this.metaDataPropertySource.setModel(this.model);
            return this.metaDataPropertySource;
        }
        if (id.equals(PROPERTY_CONFIGURATION_NAME)) {
            String configurationName = this.getActivity().getConfigurationName();
            if (configurationName == null) {
                configurationName = "";
            }
            return configurationName;
        }
        return super.getPropertyValue(id);
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        if (PROPERTY_CONFIGURATION_NAME.equals(id)) {
            String configurationName = (String)value;
            if (configurationName.trim().length() == 0) {
                configurationName = null;
            }
            Activity oldActivity = (Activity)this.getCastedModel().getExecutableBusinessProcess();
            Activity ebp = Activator.getService().getProcessModelFactory().createActivity(oldActivity.getID(), oldActivity.getExecutableComponentName(), oldActivity.getOperationName(), configurationName, oldActivity.getActivityName(), oldActivity.getDescription(), oldActivity.getImplementationClass(), oldActivity.getSeparatedClassPaths(), oldActivity.isSingleton(), oldActivity.getSystemComponent(), oldActivity.getGUIContextID(), oldActivity.getExecutionControlProperties(), oldActivity.supportsViewOnly(), oldActivity.supportsTestExecution(), oldActivity.getIconID(), oldActivity.getAttributeOrigins(), oldActivity.getConfiguration(), oldActivity.getTestConfiguration(), oldActivity.getParameterChangePolicy(), oldActivity.getParameters(ActivityConstants.AccessType.READ), oldActivity.getParameters(ActivityConstants.AccessType.WRITE), (PluginDataContainer)oldActivity, oldActivity.getUserAttributes());
            this.startChangeTransaction();
            if (this.instance != null) {
                UpdateExecutableBusinessProcess.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (int)this.getCastedModel().getID(), (ExecutableBusinessProcess)ebp, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.ExecutableBusinessProcessProperty[])new ProcessConstants.ExecutableBusinessProcessProperty[]{ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION_NAME});
            } else {
                UpdateExecutableBusinessProcess.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (int)this.getCastedModel().getID(), (ExecutableBusinessProcess)ebp, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.ExecutableBusinessProcessProperty[])new ProcessConstants.ExecutableBusinessProcessProperty[]{ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION_NAME});
            }
            String transactionLabel = "Changing Configuration Name on Node '" + this.getCastedModel().getID() + "')";
            this.endChangeTransaction(transactionLabel);
        } else {
            super.changePropertyValue(id, value);
        }
    }

    private Activity getActivity() {
        return (Activity)this.getCastedModel().getExecutableBusinessProcess();
    }

    @Override
    public boolean arePropertiesChangeable(Object ... ids) {
        if (!(this.instance instanceof ChangeableInstance)) {
            return false;
        }
        boolean changeable = false;
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            if (id.equals(PROPERTY_ACTIVITY_CONFIGURATION)) {
                if (UpdateExecutableBusinessProcess.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (int)this.getCastedModel().getID(), (ExecutableBusinessProcess)this.getCastedModel().getExecutableBusinessProcess(), (ProcessConstants.ExecutableBusinessProcessProperty[])new ProcessConstants.ExecutableBusinessProcessProperty[]{ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION})) {
                    changeable = true;
                }
            } else if (PROPERTY_CONFIGURATION_NAME.equals(id)) {
                if (UpdateExecutableBusinessProcess.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (int)this.getCastedModel().getID(), (ExecutableBusinessProcess)this.getCastedModel().getExecutableBusinessProcess(), (ProcessConstants.ExecutableBusinessProcessProperty[])new ProcessConstants.ExecutableBusinessProcessProperty[]{ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION_NAME})) {
                    changeable = true;
                }
            } else {
                if (id.equals(PROPERTY_ACTIVITY_TEMPLATE_ID) || id.equals(PROPERTY_EXECUTION_CONTROL_PROPERTIES) || id.equals(PROPERTY_EXECUTABLE_COMPONENT_NAME) || id.equals(PROPERTY_TEST_MODE) || id.equals(PROPERTY_OPERATION_NAME) || id.equals(PROPERTY_ACTIVITY_CONFIGURATION)) {
                    changeable = false;
                    break;
                }
                changeable = super.arePropertiesChangeable(ids);
                if (!changeable) break;
            }
            ++n2;
        }
        return changeable;
    }

    protected static class MetaDataLabelProvider
    extends LabelProvider {
        protected MetaDataLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "EMPTY";
            }
            Activity attribute = (Activity)((Node)element).getExecutableBusinessProcess();
            return "[" + attribute.getConfiguration().getAllEntries().size() + "]";
        }
    }
}

