/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedComboBoxPropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class DataEdgePropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.DataEdgePropertySource";
    public static final String PROPERTY_ACCESS_TYPE = String.valueOf(ID) + "/AccessType";
    public static final String PROPERTY_DATA = String.valueOf(ID) + "/Data";
    public static final String PROPERTY_NODE = String.valueOf(ID) + "/Node";
    public static final String PROPERTY_OPTIONAL = String.valueOf(ID) + "/isOptional";
    private int nodeID;
    private int dataElementID;
    private ActivityConstants.AccessType type;

    public DataEdgePropertySource(Template template, int nodeID, int dataElementID, ActivityConstants.AccessType type) {
        super(template);
        this.nodeID = nodeID;
        this.dataElementID = dataElementID;
        this.type = type;
    }

    public DataEdgePropertySource(Instance instance, int nodeID, int dataElementID, ActivityConstants.AccessType type) {
        super(instance);
        this.nodeID = nodeID;
        this.dataElementID = dataElementID;
        this.type = type;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.descriptors = this.createDescriptor();
        return this.descriptors.toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(8);
        this.addDescriptor(desc, PROPERTY_ACCESS_TYPE, "Access Type", "Info");
        if (this.instance != null) {
            if (this.arePropertiesChangeable(PROPERTY_OPTIONAL)) {
                this.addExtendedComboBoxDescriptor(desc, PROPERTY_OPTIONAL, "Optional", "Info", new String[]{"true", "false"});
            } else {
                this.addDescriptor(desc, PROPERTY_OPTIONAL, "Optional", "Info");
            }
        } else if (this.isChangeableTemplate() && this.arePropertiesChangeable(PROPERTY_OPTIONAL)) {
            this.addExtendedComboBoxDescriptor(desc, PROPERTY_OPTIONAL, "Optional", "Info", new String[]{"true", "false"});
        } else {
            this.addDescriptor(desc, PROPERTY_OPTIONAL, "Optional", "Info");
        }
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_ACCESS_TYPE)) {
            return this.getCastedModel().getType();
        }
        if (id.equals(PROPERTY_OPTIONAL)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedComboBoxPropertyDescriptor) {
                    return this.getCastedModel().isOptional() ? 0 : 1;
                }
                ++n2;
            }
            return this.getCastedModel().isOptional();
        }
        return null;
    }

    private DataEdge getCastedModel() {
        return (DataEdge)this.model;
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        if (this.instance != null && this.getCastedModel() != this.instance.getTemplate().getDataEdge(this.nodeID, this.dataElementID, this.type)) {
            this.refreshModel(this.instance.getTemplate());
        }
        if (id.equals(PROPERTY_OPTIONAL)) {
            ChangeableTemplate changeTemplate = (ChangeableTemplate)this.template;
            boolean optional = (Integer)value == 0;
            DataEdge dataEdge = Activator.getService().getProcessModelFactory().createDataEdge(this.type, optional, null);
            this.startChangeTransaction();
            SessionToken session = Activator.getService().getSessionToken();
            if (this.instance != null) {
                UpdateDataEdge.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.instance), (int)this.nodeID, (int)this.dataElementID, (ActivityConstants.AccessType)this.type, (DataEdge)dataEdge, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL});
            } else {
                UpdateDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (int)this.nodeID, (int)this.dataElementID, (ActivityConstants.AccessType)this.type, (DataEdge)dataEdge, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL});
            }
            String transactionLabel = "Changing data edge";
            this.endChangeTransaction(transactionLabel);
        }
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        if (id.equals(PROPERTY_OPTIONAL)) {
            boolean optional;
            boolean bl = optional = (Integer)value == 0;
            if (this.getCastedModel().isOptional() == optional) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean arePropertiesChangeable(Object ... ids) {
        boolean changeable = false;
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Object id;
                block3: {
                    block4: {
                        id = objectArray[n2];
                        if (!id.equals(PROPERTY_OPTIONAL)) break block3;
                        if (this.instance == null) break block4;
                        if (this.instance instanceof ChangeableInstance && UpdateDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (int)this.nodeID, (int)this.dataElementID, (ActivityConstants.AccessType)this.type, (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL})) {
                            changeable = true;
                        }
                        break block5;
                    }
                    if (!UpdateDataEdge.isPossible((Template)this.template, (int)this.nodeID, (int)this.dataElementID, (ActivityConstants.AccessType)this.type, (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL})) break block5;
                    changeable = true;
                    break block5;
                }
                if (id.equals(PROPERTY_ACCESS_TYPE)) {
                    changeable = false;
                    break;
                }
            }
            ++n2;
        }
        return changeable;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        DataEdge newModel = newTemplate.getDataEdge(this.nodeID, this.dataElementID, this.type);
        this.setTemplate(newTemplate);
        this.setModel(newModel);
    }
}

