/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.CommonConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedComboBoxPropertyDescriptor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedPropertyDescriptor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.IdentifierCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.IdentifierLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.UserAttributesCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.UserAttributesLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.UserAttributesPropertySource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class DataElementPropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.DataElementPropertySource";
    public static final String PROPERTY_DESCRIPTION = String.valueOf(ID) + "/Description";
    private static final String PROPERTY_ID = String.valueOf(ID) + "/ID";
    public static final String PROPERTY_NAME = String.valueOf(ID) + "/Name";
    public static final String PROPERTY_TYPE = String.valueOf(ID) + "/Type";
    private static final String PROPERTY_USER_ATTRIBUTES = String.valueOf(ID) + "/UserAttributes";
    public static final String PROPERTY_USER_DEFINED_TYPE = String.valueOf(ID) + "/UserDefinedAttributes";
    public static final String PROPERTY_IDENTIFIER = String.valueOf(ID) + "/Identifier";
    private static final String PROPERTY_VIRTUAL = String.valueOf(ID) + "/Virtual";
    public static final String PROPERTY_PUBLIC = String.valueOf(ID) + "/Public";
    private UserAttributesPropertySource userAttributesPropertySource;

    public DataElementPropertySource(Template template) {
        super(template);
    }

    public DataElementPropertySource(Instance instance) {
        super(instance);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.descriptors = this.createDescriptor();
        return this.descriptors.toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(9);
        String[] dataElementTypeStrings = new String[ProcessConstants.AdeptDataType.values().length];
        int i = 0;
        ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
        int n = adeptDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.AdeptDataType dataElementType = adeptDataTypeArray[n2];
            dataElementTypeStrings[i] = dataElementType.toString();
            ++i;
            ++n2;
        }
        this.addDescriptor(desc, PROPERTY_ID, "ID", "Info");
        if (this.arePropertiesChangeable(PROPERTY_DESCRIPTION, PROPERTY_NAME)) {
            this.addTextDescriptor(desc, PROPERTY_DESCRIPTION, "Description", "Info");
            this.addTextDescriptor(desc, PROPERTY_NAME, "Name", "Info");
        } else {
            this.addDescriptor(desc, PROPERTY_DESCRIPTION, "Description", "Info");
            this.addDescriptor(desc, PROPERTY_NAME, "Name", "Info");
        }
        if (this.arePropertiesChangeable(PROPERTY_USER_ATTRIBUTES)) {
            this.addExtendedDescriptor(desc, PROPERTY_USER_ATTRIBUTES, "User Attributes", "Misc", UserAttributesCellEditor.class, new UserAttributesLabelProvider());
        } else {
            this.addExtendedDescriptor(desc, PROPERTY_USER_ATTRIBUTES, "User Attributes", "Misc", null, new UserAttributesLabelProvider());
        }
        if (this.arePropertiesChangeable(PROPERTY_TYPE, PROPERTY_USER_DEFINED_TYPE)) {
            this.addExtendedComboBoxDescriptor(desc, PROPERTY_TYPE, "Type", "Info", dataElementTypeStrings);
            this.addTextDescriptor(desc, PROPERTY_USER_DEFINED_TYPE, "User Defined Type", "Info");
        } else {
            this.addDescriptor(desc, PROPERTY_TYPE, "Type", "Info");
            this.addDescriptor(desc, PROPERTY_USER_DEFINED_TYPE, "User Defined Type", "Info");
        }
        if (this.arePropertiesChangeable(PROPERTY_PUBLIC)) {
            this.addExtendedComboBoxDescriptor(desc, PROPERTY_PUBLIC, "Public", "Info", new String[]{"true", "false"});
        } else {
            this.addDescriptor(desc, PROPERTY_PUBLIC, "Public", "Info");
        }
        if (this.arePropertiesChangeable(PROPERTY_IDENTIFIER)) {
            this.addExtendedDescriptor(desc, PROPERTY_IDENTIFIER, "Identifier", "Info", IdentifierCellEditor.class, new IdentifierLabelProvider());
        } else {
            this.addDescriptor(desc, PROPERTY_IDENTIFIER, "Identifier", "Info");
        }
        if (this.arePropertiesChangeable(PROPERTY_VIRTUAL)) {
            this.addExtendedComboBoxDescriptor(desc, PROPERTY_VIRTUAL, "Virtual", "Info", new String[]{"true", "false"});
        } else {
            this.addDescriptor(desc, PROPERTY_VIRTUAL, "Virtual", "Info");
        }
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_ID)) {
            return this.getCastedModel().getID();
        }
        if (id.equals(PROPERTY_NAME)) {
            return this.getCastedModel().getName();
        }
        if (id.equals(PROPERTY_DESCRIPTION)) {
            return this.getCastedModel().getDescription();
        }
        if (id.equals(PROPERTY_TYPE)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedComboBoxPropertyDescriptor) {
                    int i = 0;
                    ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
                    int n3 = adeptDataTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ProcessConstants.AdeptDataType dataElementType = adeptDataTypeArray[n4];
                        if (this.getCastedModel().getDataType().equals((Object)dataElementType)) {
                            return i;
                        }
                        ++i;
                        ++n4;
                    }
                }
                ++n2;
            }
            return this.getCastedModel().getDataType();
        }
        if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
            if (this.userAttributesPropertySource == null) {
                this.userAttributesPropertySource = this.instance != null ? new UserAttributesPropertySource(this.instance) : new UserAttributesPropertySource(this.getTemplate());
            }
            this.userAttributesPropertySource.setModel(this.model);
            return this.userAttributesPropertySource;
        }
        if (id.equals(PROPERTY_IDENTIFIER)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n5 = 0;
            while (n5 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n5];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedPropertyDescriptor) {
                    return this.getCastedModel().getIdentifierID();
                }
                ++n5;
            }
            return new IdentifierLabelProvider().getText(this.getCastedModel().getIdentifierID());
        }
        if (id.equals(PROPERTY_PUBLIC)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n6 = 0;
            while (n6 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n6];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedComboBoxPropertyDescriptor) {
                    return this.getCastedModel().isPublic() ? 0 : 1;
                }
                ++n6;
            }
            return this.getCastedModel().isPublic();
        }
        if (id.equals(PROPERTY_VIRTUAL)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n7 = 0;
            while (n7 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n7];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedComboBoxPropertyDescriptor) {
                    return this.getCastedModel().isVirtual() ? 0 : 1;
                }
                ++n7;
            }
            return this.getCastedModel().isVirtual();
        }
        if (id.equals(PROPERTY_USER_DEFINED_TYPE)) {
            String userdefinedType = this.getCastedModel().getUDTName();
            return userdefinedType == null ? "" : userdefinedType;
        }
        return null;
    }

    protected DataElement getCastedModel() {
        return (DataElement)this.model;
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        if (this.instance != null && this.getCastedModel() != this.instance.getTemplate().getDataElement(this.getCastedModel().getID())) {
            this.refreshModel(this.instance.getTemplate());
        }
        if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
            this.userAttributesPropertySource = null;
            return;
        }
        ChangeableTemplate changeTemplate = this.getChangeableTemplate();
        ChangeableInstance changeableInstance = null;
        boolean isInstance = false;
        if (this.instance != null) {
            changeableInstance = (ChangeableInstance)this.instance;
            isInstance = true;
        }
        this.startChangeTransaction();
        SessionToken session = Activator.getService().getSessionToken();
        DataElement m = (DataElement)this.model;
        if (id.equals(PROPERTY_DESCRIPTION)) {
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), null, null, (String)value, null, null, CommonConstants.UUID_NOT_EXISTING, false, false, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.DESCRIPTION});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.DESCRIPTION});
            }
        } else if (id.equals(PROPERTY_NAME)) {
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), (String)value, null, null, null, null, CommonConstants.UUID_NOT_EXISTING, false, false, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.NAME});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.NAME});
            }
        } else if (id.equals(PROPERTY_IDENTIFIER)) {
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), null, null, null, null, null, (UUID)value, false, false, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.IDENTIFIER});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.IDENTIFIER});
            }
        } else if (id.equals(PROPERTY_PUBLIC)) {
            boolean v = (Integer)value == 0;
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), null, null, null, null, null, CommonConstants.UUID_NOT_EXISTING, v, false, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.PUBLIC});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.PUBLIC});
            }
        } else if (id.equals(PROPERTY_VIRTUAL)) {
            boolean v = (Integer)value == 0;
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), null, null, null, null, null, CommonConstants.UUID_NOT_EXISTING, false, v, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.VIRTUAL});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.VIRTUAL});
            }
        } else if (id.equals(PROPERTY_TYPE)) {
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), null, ProcessConstants.AdeptDataType.values()[(Integer)value], null, null, null, CommonConstants.UUID_NOT_EXISTING, false, false, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.TYPE});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.TYPE});
            }
        } else if (id.equals(PROPERTY_USER_DEFINED_TYPE)) {
            DataElement dataElement = Activator.getService().getProcessModelFactory().createDataElement(m.getID(), null, null, null, (String)value, null, CommonConstants.UUID_NOT_EXISTING, false, false, null, null, null);
            if (isInstance) {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.USER_DEFINED_TYPE});
            } else {
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)changeTemplate, (DataElement)dataElement, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.USER_DEFINED_TYPE});
            }
        }
        String transactionLabel = "Data element change";
        this.endChangeTransaction(transactionLabel);
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        DataElement m = (DataElement)this.model;
        if (id.equals(PROPERTY_DESCRIPTION)) {
            if (m.getDescription().equals(value)) {
                return false;
            }
        } else if (id.equals(PROPERTY_NAME)) {
            if (m.getName().equals(value)) {
                return false;
            }
        } else if (id.equals(PROPERTY_IDENTIFIER)) {
            if (m.getIdentifierID().equals(value)) {
                return false;
            }
        } else if (id.equals(PROPERTY_VIRTUAL)) {
            boolean v;
            boolean bl = v = (Integer)value == 0;
            if (m.isVirtual() == v) {
                return false;
            }
        } else if (id.equals(PROPERTY_TYPE)) {
            if (m.getDataType() == ProcessConstants.AdeptDataType.values()[(Integer)value]) {
                return false;
            }
        } else if (id.equals(PROPERTY_USER_DEFINED_TYPE)) {
            if (m.getUDTName() != null && m.getUDTName().equals(value)) {
                return false;
            }
        } else if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
            return true;
        }
        return true;
    }

    @Override
    public boolean arePropertiesChangeable(Object ... ids) {
        boolean changeable = false;
        HashSet<ProcessConstants.DataElementProperty> properties = new HashSet<ProcessConstants.DataElementProperty>();
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            if (id.equals(PROPERTY_DESCRIPTION)) {
                properties.add(ProcessConstants.DataElementProperty.DESCRIPTION);
            } else if (id.equals(PROPERTY_NAME)) {
                properties.add(ProcessConstants.DataElementProperty.NAME);
            } else if (id.equals(PROPERTY_TYPE)) {
                properties.add(ProcessConstants.DataElementProperty.TYPE);
            } else if (id.equals(PROPERTY_USER_DEFINED_TYPE)) {
                properties.add(ProcessConstants.DataElementProperty.USER_DEFINED_TYPE);
            } else if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
                properties.add(ProcessConstants.DataElementProperty.USER_ATTRIBUTE);
            } else if (id.equals(PROPERTY_PUBLIC)) {
                properties.add(ProcessConstants.DataElementProperty.PUBLIC);
            } else if (id.equals(PROPERTY_IDENTIFIER)) {
                properties.add(ProcessConstants.DataElementProperty.IDENTIFIER);
            } else {
                if (id.equals(PROPERTY_VIRTUAL) || id.equals(PROPERTY_ID)) {
                    return false;
                }
                return false;
            }
            ++n2;
        }
        if (this.instance != null) {
            if (!(this.instance instanceof ChangeableInstance)) {
                return false;
            }
            changeable = UpdateDataElement.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (DataElement)this.getCastedModel(), (ProcessConstants.DataElementProperty[])properties.toArray(new ProcessConstants.DataElementProperty[0]));
        } else {
            if (!this.isChangeableTemplate()) {
                return false;
            }
            changeable = UpdateDataElement.isPossible((Template)this.template, (DataElement)this.getCastedModel(), (ProcessConstants.DataElementProperty[])properties.toArray(new ProcessConstants.DataElementProperty[0]));
        }
        return changeable;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        DataElement newModel = newTemplate.getDataElement(this.getCastedModel().getID());
        this.setModel(newModel);
    }
}

