/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class EdgePropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.EdgePropertySource";
    public static final String EDGE_CODE = String.valueOf(ID) + "/EdgeCode";
    public static final String SOURCE_NODE = String.valueOf(ID) + "/SourceNode";
    public static final String DESTINATION_NODE = String.valueOf(ID) + "/DestinationNode";
    public static final String EDGE_TYPE = String.valueOf(ID) + "/EdgeType";
    public static final String EDGE_ID = String.valueOf(ID) + "/ID";
    private int startNodeID;
    private int endNodeID;
    private ProcessConstants.EdgeType type;

    public EdgePropertySource(Template template, int startNodeID, int endNodeID, ProcessConstants.EdgeType type) {
        super(template);
        this.startNodeID = startNodeID;
        this.endNodeID = endNodeID;
        this.type = type;
    }

    public EdgePropertySource(Instance instance, int startNodeID, int endNodeID, ProcessConstants.EdgeType type) {
        super(instance);
        this.startNodeID = startNodeID;
        this.endNodeID = endNodeID;
        this.type = type;
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(8);
        this.addDescriptor(desc, EDGE_TYPE, "Edge Type", "Info");
        this.addDescriptor(desc, EDGE_CODE, "Edge Code", "Info");
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (EDGE_CODE.equals(id)) {
            return this.getCastedModel().getEdgeCode();
        }
        if (EDGE_TYPE.equals(id)) {
            return this.getCastedModel().getType();
        }
        return null;
    }

    private Edge getCastedModel() {
        return (Edge)this.model;
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        return false;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        Edge newModel = newTemplate.getEdge(this.startNodeID, this.endNodeID, this.type);
        this.setModel(newModel);
    }
}

