/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExtendedPropertyDescriptor
extends PropertyDescriptor {
    Class<?> cellEditor;
    private Template template;
    private Instance instance;
    protected final Logger logger;

    public ExtendedPropertyDescriptor(Object id, String displayName, Class<?> cellEditor, Instance instance, Template template) {
        super(id, displayName);
        this.instance = instance;
        this.template = template;
        this.cellEditor = cellEditor;
        this.logger = LoggerTools.getLogger((Object)((Object)this));
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (this.cellEditor == null) {
            return null;
        }
        try {
            CellEditor editor = null;
            if (this.instance != null) {
                Constructor<?> con = this.cellEditor.getConstructor(Composite.class, Instance.class);
                editor = (CellEditor)con.newInstance(parent, this.instance);
            } else {
                Constructor<?> con = this.cellEditor.getConstructor(Composite.class, Template.class);
                editor = (CellEditor)con.newInstance(parent, this.template);
            }
            return editor;
        }
        catch (NoSuchMethodException nsme) {
            this.logger.log(Level.SEVERE, "This PropertyDescriptor does not know how to handle " + this.cellEditor + " Cell Editors", nsme);
        }
        catch (IllegalAccessException iae) {
            this.logger.log(Level.SEVERE, "Constructor of " + this.cellEditor + " Cell Editor is inaccessible", iae);
        }
        catch (InstantiationException ie) {
            this.logger.log(Level.SEVERE, "The " + this.cellEditor + " Cell Editor is an abstract class", ie);
        }
        catch (InvocationTargetException ite) {
            this.logger.log(Level.SEVERE, "The " + this.cellEditor + " Cell Editor constructor throwed an exception", ite);
        }
        return null;
    }
}

