/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.dialogues.SelectIdentifierDialogue;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.IdentifierLabelProvider;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class IdentifierCellEditor
extends DialogCellEditor {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private Template template;
    private Instance instance;

    public IdentifierCellEditor(Composite parent, Template template) {
        super(parent);
        this.template = template;
    }

    public IdentifierCellEditor(Composite parent, Instance instance) {
        super(parent);
        this.instance = instance;
        this.template = instance.getTemplate();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        UUID identifier = (UUID)this.getValue();
        if (!(this.template instanceof ChangeableTemplate)) {
            this.logger.severe("The data element identifier dialogue was called for a non-changeable template. Ignoring request!");
            return identifier;
        }
        ADEPT2ClientService cs = Activator.getService();
        SessionToken session = cs.getSessionToken();
        Collection identifiers = cs.getActivityRepository().getIdentifierManager().getLatestIdentifiers(cs.getSessionToken(), true);
        SelectIdentifierDialogue dia = new SelectIdentifierDialogue(session, cellEditorWindow.getShell(), Activator.getPluginID(), identifiers, cs.getFilterFactory(), identifier, false, null);
        if (dia.open() == 0) {
            identifier = dia.getIdentifier().getID();
            this.deactivate();
        }
        return identifier;
    }

    protected void updateContents(Object value) {
        String text = "";
        if (value instanceof UUID) {
            text = new IdentifierLabelProvider().getText(value);
        }
        super.updateContents((Object)text);
    }
}

