/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.core.changeoperations.UpdateExecutableBusinessProcess;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MetaDataPropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.MetaDataPropertySource";
    public static final String PROPERTY_NAME = String.valueOf(ID) + "/Name";
    public static final String PROPERTY_VALUE = String.valueOf(ID) + "/Value";
    private static final String ACTIVITY_TYPE_CONFIGURATION = String.valueOf(ID) + "/ActivityTypeConfiguration";
    protected Node node;

    public MetaDataPropertySource(Template template, Node node) {
        super(template);
        this.node = node;
    }

    public MetaDataPropertySource(Instance instance, Node node) {
        super(instance);
        this.node = node;
    }

    @Override
    public Object getEditableValue() {
        return this.model;
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(8);
        boolean changeable = false;
        if (this.arePropertiesChangeable(ACTIVITY_TYPE_CONFIGURATION)) {
            changeable = true;
        }
        if (changeable) {
            for (String entry : this.getActivity().getConfiguration().getAllEntries()) {
                this.addTextDescriptor(desc, entry, entry, "Activity Configuration");
            }
        } else {
            for (String entry : this.getActivity().getConfiguration().getAllEntries()) {
                this.addDescriptor(desc, entry, entry, "Activity Configuration");
            }
        }
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        return this.getActivity().getConfiguration().getString((String)id);
    }

    private Node getCastedModel() {
        return (Node)this.model;
    }

    private Activity getActivity() {
        return (Activity)this.getCastedModel().getExecutableBusinessProcess();
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        if (this.getActivity().getConfiguration().getAllEntries().contains(id)) {
            ChangeableActivityConfiguration newConfiguration = Activator.getService().getProcessModelFactory().createConfiguration(this.getActivity().getConfiguration());
            newConfiguration.setString((String)id, (String)value);
            Activity ebp = Activator.getService().getProcessModelFactory().createActivity(this.getActivity().getID(), this.getActivity().getExecutableComponentName(), this.getActivity().getOperationName(), this.getActivity().getConfigurationName(), this.getActivity().getActivityName(), this.getActivity().getDescription(), this.getActivity().getImplementationClass(), this.getActivity().getSeparatedClassPaths(), this.getActivity().isSingleton(), this.getActivity().getSystemComponent(), this.getActivity().getGUIContextID(), this.getActivity().getExecutionControlProperties(), this.getActivity().supportsViewOnly(), this.getActivity().supportsTestExecution(), this.getActivity().getIconID(), this.getActivity().getAttributeOrigins(), (ActivityConfiguration)newConfiguration, this.getActivity().getTestConfiguration(), this.getActivity().getParameterChangePolicy(), this.getActivity().getParameters(ActivityConstants.AccessType.READ), this.getActivity().getParameters(ActivityConstants.AccessType.WRITE), (PluginDataContainer)this.getActivity(), this.getActivity().getUserAttributes());
            this.startChangeTransaction();
            if (this.instance != null) {
                UpdateExecutableBusinessProcess.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (int)this.node.getID(), (ExecutableBusinessProcess)ebp, (ProcessConstants.ExecutableBusinessProcessProperty[])new ProcessConstants.ExecutableBusinessProcessProperty[]{ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION});
            } else {
                UpdateExecutableBusinessProcess.performOperation((ChangeableTemplate)((ChangeableTemplate)this.getTemplate()), (int)this.node.getID(), (ExecutableBusinessProcess)ebp, (ProcessConstants.ExecutableBusinessProcessProperty[])new ProcessConstants.ExecutableBusinessProcessProperty[]{ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION});
            }
            String transactionLabel = "Activity Change at node " + this.node.getName();
            this.endChangeTransaction(transactionLabel);
        }
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        return !this.getActivity().getConfiguration().getAllEntries().contains(id) || !this.getActivity().getConfiguration().getString((String)id).equals(value);
    }

    @Override
    public boolean arePropertiesChangeable(Object ... ids) {
        boolean changeable = false;
        HashSet<ProcessConstants.ExecutableBusinessProcessProperty> properties = new HashSet<ProcessConstants.ExecutableBusinessProcessProperty>();
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            if (id.equals(ACTIVITY_TYPE_CONFIGURATION)) {
                properties.add(ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION);
            } else if (id.equals(PROPERTY_NAME) || id.equals(PROPERTY_VALUE)) {
                properties.add(ProcessConstants.ExecutableBusinessProcessProperty.CONFIGURATION);
            } else {
                return false;
            }
            ++n2;
        }
        if (this.instance != null) {
            if (!(this.instance instanceof ChangeableInstance)) {
                return false;
            }
            if (UpdateExecutableBusinessProcess.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (int)this.getCastedModel().getID(), (ExecutableBusinessProcess)this.getActivity(), (ProcessConstants.ExecutableBusinessProcessProperty[])properties.toArray(new ProcessConstants.ExecutableBusinessProcessProperty[0]))) {
                changeable = true;
            }
        } else {
            if (!this.isChangeableTemplate()) {
                return false;
            }
            if (UpdateExecutableBusinessProcess.isPossible((Template)this.template, (int)this.getCastedModel().getID(), (ExecutableBusinessProcess)this.getActivity(), (ProcessConstants.ExecutableBusinessProcessProperty[])properties.toArray(new ProcessConstants.ExecutableBusinessProcessProperty[0]))) {
                changeable = true;
            }
        }
        return changeable;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        Node newModel = newTemplate.getNode(this.getCastedModel().getID());
        this.setModel(newModel);
    }
}

