/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.changeoperations.UpdateNodeSystemDependency;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.plugindata.EnquiryData;
import de.aristaflow.adept2.model.common.plugindata.SchedulerData;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ActivityPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.CollectionLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExecutableBusinessProcessLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExecutableBusinessProcessPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedComboBoxPropertyDescriptor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedPropertyDescriptor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.InputParametersPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.LightWeightProcessPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.OutputParametersPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.StaffAssignmentRuleCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.StaffAssignmentRuleLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.SystemDataConsumerDialogue;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.UserAttributesCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.UserAttributesLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.UserAttributesPropertySource;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class NodePropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.NodePropertySource";
    public static final String PROPERTY_NAME = String.valueOf(ID) + "/Text";
    public static final String PROPERTY_ID = String.valueOf(ID) + "/ID";
    public static final String PROPERTY_DESCRIPTION = String.valueOf(ID) + "/description";
    public static final String PROPERTY_STAFF_ASSIGNMENT_RULE = String.valueOf(ID) + "/StaffAssignmentRule";
    public static final String PROPERTY_AUTO_START = String.valueOf(ID) + "/AutoStart";
    public static final String PROPERTY_BRANCH_ID = String.valueOf(ID) + "/BrachID";
    public static final String PROPERTY_BUSINESS_PROCESS = String.valueOf(ID) + "/BusinessProcess";
    public static final String PROPERTY_OUTPUTPARAMETERS = String.valueOf(ID) + "/OutputParameter";
    public static final String PROPERTY_INPUTPARAMETERS = String.valueOf(ID) + "/InputParameter";
    public static final String PROPERTY_SUPPORTED_PLUGINS = String.valueOf(ID) + "/SupportedPlugins";
    public static final String PROPERTY_DELEGATION_RECIPIENTS = String.valueOf(ID) + "/DelegationRecipients";
    public static final String PROPERTY_ENQUIRY_RECIPIENTS = String.valueOf(ID) + "/EnquiryRecipients";
    public static final String PROPERTY_USER_ATTRIBUTES = String.valueOf(ID) + "/UserAttributes";
    private UserAttributesPropertySource userAttributesPropertySource;
    private ExecutableBusinessProcessPropertySource executableBusinessProcessPropertySource;
    private InputParametersPropertySource inputParametersPropertySource;
    private OutputParametersPropertySource outputParametersPropertySource;

    public NodePropertySource(Template template) {
        super(template);
    }

    public NodePropertySource(Instance instance) {
        super(instance);
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(8);
        if (this.arePropertiesChangeable(PROPERTY_NAME, PROPERTY_DESCRIPTION, PROPERTY_USER_ATTRIBUTES)) {
            this.addTextDescriptor(desc, PROPERTY_NAME, "Name", "Info");
            this.addTextDescriptor(desc, PROPERTY_DESCRIPTION, "Description", "Info");
            this.addExtendedDescriptor(desc, PROPERTY_USER_ATTRIBUTES, "User Attributes", "Misc", UserAttributesCellEditor.class, new UserAttributesLabelProvider());
        } else {
            this.addDescriptor(desc, PROPERTY_NAME, "Name", "Info");
            this.addDescriptor(desc, PROPERTY_DESCRIPTION, "Description", "Info");
            this.addExtendedDescriptor(desc, PROPERTY_USER_ATTRIBUTES, "User Attributes", "Misc", null, new UserAttributesLabelProvider());
        }
        if (this.arePropertiesChangeable(PROPERTY_STAFF_ASSIGNMENT_RULE)) {
            this.addExtendedDescriptor(desc, PROPERTY_STAFF_ASSIGNMENT_RULE, "Staff Assignment Rule", "Info", StaffAssignmentRuleCellEditor.class, new StaffAssignmentRuleLabelProvider());
        } else {
            this.addDescriptor(desc, PROPERTY_STAFF_ASSIGNMENT_RULE, "Staff Assignment Rule", "Info");
        }
        if (this.arePropertiesChangeable(PROPERTY_AUTO_START)) {
            this.addExtendedComboBoxDescriptor(desc, PROPERTY_AUTO_START, "Auto Start", "Info", new String[]{"true", "false"});
        } else {
            this.addDescriptor(desc, PROPERTY_AUTO_START, "Auto Start", "Info");
        }
        this.addExtendedDescriptor(desc, PROPERTY_BUSINESS_PROCESS, "Executable Business Process", "Misc", null, new ExecutableBusinessProcessLabelProvider());
        this.addExtendedDescriptor(desc, PROPERTY_INPUTPARAMETERS, "Input Parameters", "Misc", null, new CollectionLabelProvider());
        this.addExtendedDescriptor(desc, PROPERTY_OUTPUTPARAMETERS, "Output Parameters", "Misc", null, new CollectionLabelProvider());
        this.addDescriptor(desc, PROPERTY_ID, "ID", "Info");
        this.addDescriptor(desc, PROPERTY_BRANCH_ID, "Branch ID", "Misc");
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_NAME)) {
            return this.getCastedModel().getName();
        }
        if (id.equals(PROPERTY_DESCRIPTION)) {
            return this.getCastedModel().getDescription();
        }
        if (id.equals(PROPERTY_INPUTPARAMETERS)) {
            if (this.inputParametersPropertySource == null) {
                this.inputParametersPropertySource = this.instance != null ? new InputParametersPropertySource(this.instance) : new InputParametersPropertySource(this.getTemplate());
            }
            this.inputParametersPropertySource.setModel(this.getCastedModel().getSystemParameters(ActivityConstants.AccessType.SYSTEM_READ));
            return this.inputParametersPropertySource;
        }
        if (id.equals(PROPERTY_OUTPUTPARAMETERS)) {
            if (this.outputParametersPropertySource == null) {
                this.outputParametersPropertySource = this.instance != null ? new OutputParametersPropertySource(this.instance) : new OutputParametersPropertySource(this.getTemplate());
            }
            this.outputParametersPropertySource.setModel(this.getCastedModel().getSystemParameters(ActivityConstants.AccessType.SYSTEM_WRITE));
            return this.outputParametersPropertySource;
        }
        if (id.equals(PROPERTY_STAFF_ASSIGNMENT_RULE)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedPropertyDescriptor) {
                    return this.model;
                }
                ++n2;
            }
            return this.getCastedModel().getStaffAssignmentRule();
        }
        if (id.equals(PROPERTY_AUTO_START)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n3 = 0;
            while (n3 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n3];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedComboBoxPropertyDescriptor) {
                    return this.getCastedModel().isAutoStartEnabled() ? 0 : 1;
                }
                ++n3;
            }
            return this.getCastedModel().isAutoStartEnabled();
        }
        if (id.equals(PROPERTY_ID)) {
            return this.getCastedModel().getID();
        }
        if (id.equals(PROPERTY_BUSINESS_PROCESS)) {
            if (this.getCastedModel().getExecutableBusinessProcess() != null) {
                if (this.executableBusinessProcessPropertySource == null) {
                    this.executableBusinessProcessPropertySource = this.getCastedModel().getExecutableBusinessProcess() instanceof Activity ? (this.instance != null ? new ActivityPropertySource(this.instance, this.getCastedModel()) : new ActivityPropertySource(this.template, this.getCastedModel())) : (this.getCastedModel().getExecutableBusinessProcess() instanceof LightWeightProcess ? (this.instance != null ? new LightWeightProcessPropertySource(this.instance, this.getCastedModel()) : new LightWeightProcessPropertySource(this.getTemplate(), this.getCastedModel())) : (this.instance != null ? new ExecutableBusinessProcessPropertySource(this.instance, this.getCastedModel()) : new ExecutableBusinessProcessPropertySource(this.getTemplate(), this.getCastedModel())));
                }
                this.executableBusinessProcessPropertySource.setModel(this.getCastedModel());
                return this.executableBusinessProcessPropertySource;
            }
            return null;
        }
        if (id.equals(PROPERTY_BRANCH_ID)) {
            return this.getTemplate().getNodeBranchID(this.getCastedModel().getID());
        }
        if (id.equals(PROPERTY_DELEGATION_RECIPIENTS)) {
            PluginData pluginData = this.getCastedModel().getPluginData("SchedulerData");
            if (pluginData != null) {
                SchedulerData data = (SchedulerData)ModelViewer.createView((Map)pluginData.getPluginData(), SchedulerData.class);
                return data.getDelegationRule();
            }
            return "";
        }
        if (id.equals(PROPERTY_ENQUIRY_RECIPIENTS)) {
            PluginData pluginData = this.getCastedModel().getPluginData("Enquiry");
            if (pluginData != null) {
                EnquiryData data = (EnquiryData)ModelViewer.createView((Map)pluginData.getPluginData(), EnquiryData.class);
                switch (data.getEnquiryRecipientMode()) {
                    case RecipientsFromSar: {
                        return data.getEnquiryRecipientsRule();
                    }
                }
                throw new RuntimeException("This feature is not yet implemented!");
            }
            return "";
        }
        if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
            if (this.userAttributesPropertySource == null) {
                this.userAttributesPropertySource = this.instance != null ? new UserAttributesPropertySource(this.instance) : new UserAttributesPropertySource(this.getTemplate());
            }
            this.userAttributesPropertySource.setModel(this.model);
            return this.userAttributesPropertySource;
        }
        this.logger.info("Property not handled correctly: " + id);
        return null;
    }

    private Node getCastedModel() {
        return (Node)this.model;
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        if (this.instance != null && this.getCastedModel() != this.instance.getTemplate().getNode(this.getCastedModel().getID())) {
            this.refreshModel(this.instance.getTemplate());
        }
        if (id.equals(PROPERTY_BUSINESS_PROCESS)) {
            this.executableBusinessProcessPropertySource = null;
            return;
        }
        if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
            this.userAttributesPropertySource = null;
            return;
        }
        if (id.equals(PROPERTY_INPUTPARAMETERS)) {
            this.inputParametersPropertySource = null;
        } else if (id.equals(PROPERTY_OUTPUTPARAMETERS)) {
            this.outputParametersPropertySource = null;
        }
        Node m = this.getCastedModel();
        ChangeableTemplate changeTemplate = this.getChangeableTemplate();
        ChangeableInstance changeableInstance = null;
        boolean isInstance = false;
        if (this.instance != null) {
            changeableInstance = (ChangeableInstance)this.instance;
            isInstance = true;
        }
        this.startChangeTransaction();
        if (id.equals(PROPERTY_NAME)) {
            if (value instanceof SystemDataConsumerDialogue) {
                SystemDataConsumerDialogue dialogue = (SystemDataConsumerDialogue)value;
                String name = dialogue.getConsumerString();
                SessionToken session = Activator.getService().getSessionToken();
                Node node = this.getCastedModel();
                Node tempNode = Activator.getService().getProcessModelFactory().createNode(node.getID(), name, node.getDescription(), node.getStaffAssignmentRule(), null, false, node.getIconID(), null, null, null, null, null);
                if (changeableInstance != null && UpdateNodeSystemDependency.isPossible((ChangeableInstance)changeableInstance, (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.NAME)) {
                    UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.NAME, (UpdateManager)Activator.getService().getUpdateManager());
                } else if (UpdateNodeSystemDependency.isPossible((Template)this.getTemplate(), (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.NAME)) {
                    UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableTemplate)this.getChangeableTemplate(), (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.NAME, (UpdateManager)Activator.getService().getUpdateManager());
                } else {
                    this.logger.severe("Updating the name of the Node was reported as not possible!");
                }
            } else {
                Node node = Activator.getService().getProcessModelFactory().createNode(m.getID(), (String)value, "", "", null, false, null, null, null, null, null, null);
                if (isInstance) {
                    UpdateNode.performOperation((ChangeableInstance)changeableInstance, (Node)node, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.NAME});
                } else {
                    UpdateNode.performOperation((ChangeableTemplate)changeTemplate, (Node)node, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.NAME});
                }
            }
        } else if (id.equals(PROPERTY_DESCRIPTION)) {
            if (value instanceof SystemDataConsumerDialogue) {
                SystemDataConsumerDialogue dialogue = (SystemDataConsumerDialogue)value;
                String description = dialogue.getConsumerString();
                SessionToken session = Activator.getService().getSessionToken();
                Node node = this.getCastedModel();
                Node tempNode = Activator.getService().getProcessModelFactory().createNode(node.getID(), node.getName(), description, node.getStaffAssignmentRule(), null, false, node.getIconID(), null, null, null, null, null);
                if (changeableInstance != null && UpdateNodeSystemDependency.isPossible((ChangeableInstance)changeableInstance, (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.DESCRIPTION)) {
                    UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.DESCRIPTION, (UpdateManager)Activator.getService().getUpdateManager());
                } else if (UpdateNodeSystemDependency.isPossible((Template)this.getTemplate(), (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.DESCRIPTION)) {
                    UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableTemplate)this.getChangeableTemplate(), (Node)tempNode, dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.DESCRIPTION, (UpdateManager)Activator.getService().getUpdateManager());
                } else {
                    this.logger.severe("Updating the description of the Node was reported as not possible!");
                }
            } else {
                Node node = Activator.getService().getProcessModelFactory().createNode(m.getID(), "", (String)value, "", null, false, null, null, null, null, null, null);
                if (isInstance) {
                    UpdateNode.performOperation((ChangeableInstance)changeableInstance, (Node)node, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.DESCRIPTION});
                } else {
                    UpdateNode.performOperation((ChangeableTemplate)changeTemplate, (Node)node, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.DESCRIPTION});
                }
            }
        } else if (id.equals(PROPERTY_STAFF_ASSIGNMENT_RULE)) {
            if (value instanceof StaffAssignmentRuleDialogue) {
                StaffAssignmentRuleDialogue dialogue = (StaffAssignmentRuleDialogue)value;
                String policy = dialogue.getStaffAssignmentRule();
                SessionToken session = Activator.getService().getSessionToken();
                Node node = this.getCastedModel();
                Node tempNode = Activator.getService().getProcessModelFactory().createNode(node.getID(), node.getName(), node.getDescription(), policy, null, false, node.getIconID(), null, null, null, null, null);
                if (changeableInstance != null && UpdateNodeSystemDependency.isPossible((ChangeableInstance)changeableInstance, (Node)tempNode, (Map)dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE)) {
                    UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableInstance)changeableInstance, (Node)tempNode, (Map)dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE, (UpdateManager)Activator.getService().getUpdateManager());
                } else if (UpdateNodeSystemDependency.isPossible((Template)this.getTemplate(), (Node)tempNode, (Map)dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE)) {
                    UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableTemplate)this.getChangeableTemplate(), (Node)tempNode, (Map)dialogue.getParameterBindings(), (ProcessConstants.NodeProperty)ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE, (UpdateManager)Activator.getService().getUpdateManager());
                } else {
                    this.logger.severe("Updating the staff assignment rule of the Node was reported as not possible!");
                }
            }
        } else if (id.equals(PROPERTY_AUTO_START)) {
            boolean autoStart = (Integer)value == 0;
            Node node = Activator.getService().getProcessModelFactory().createNode(m.getID(), "", "", "", null, autoStart, null, null, null, null, null, null);
            if (isInstance) {
                UpdateNode.performOperation((ChangeableInstance)changeableInstance, (Node)node, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.AUTO_START});
            } else {
                UpdateNode.performOperation((ChangeableTemplate)changeTemplate, (Node)node, (UpdateManager)Activator.getService().getUpdateManager(), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.AUTO_START});
            }
        } else if (id.equals(PROPERTY_DELEGATION_RECIPIENTS)) {
            String rule = (String)value;
            PluginData pluginData = this.getCastedModel().getPluginData("SchedulerData");
            HashMap delegationAttributes = pluginData != null ? new HashMap(pluginData.getPluginData()) : new HashMap();
            ((SchedulerData)ModelViewer.createView(delegationAttributes, SchedulerData.class)).setDelegationRule(rule);
            DefaultPluginData newPluginData = new DefaultPluginData("SchedulerData", delegationAttributes);
            if (this.instance != null) {
                UpdatePluginDataContainer.performOperation((ChangeableInstance)changeableInstance, (PluginDataContainer)this.getCastedModel(), (String)"SchedulerData", (String)"SchedulerData", (PluginData)newPluginData);
            } else {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)changeTemplate, (PluginDataContainer)this.getCastedModel(), (String)"SchedulerData", (String)"SchedulerData", (PluginData)newPluginData);
            }
        } else if (id.equals(PROPERTY_ENQUIRY_RECIPIENTS)) {
            String rule = (String)value;
            PluginData pluginData = this.getCastedModel().getPluginData("Enquiry");
            HashMap enquiryAttributes = pluginData != null ? new HashMap(pluginData.getPluginData()) : new HashMap();
            ((EnquiryData)ModelViewer.createView(enquiryAttributes, EnquiryData.class)).setEnquiryRecipientsRule(rule);
            DefaultPluginData newPluginData = new DefaultPluginData("Enquiry", enquiryAttributes);
            if (this.instance != null) {
                UpdatePluginDataContainer.performOperation((ChangeableInstance)changeableInstance, (PluginDataContainer)this.getCastedModel(), (String)"Enquiry", (String)"Enquiry", (PluginData)newPluginData);
            } else {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)changeTemplate, (PluginDataContainer)this.getCastedModel(), (String)"Enquiry", (String)"Enquiry", (PluginData)newPluginData);
            }
        }
        String transactionLabel = "Changing node " + m.getName();
        this.endChangeTransaction(transactionLabel);
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        Node m = this.getCastedModel();
        if (id.equals(PROPERTY_NAME)) {
            if (m.getName().equals(value)) {
                return false;
            }
        } else if (id.equals(PROPERTY_DESCRIPTION)) {
            if (m.getDescription().equals(value)) {
                return false;
            }
        } else {
            if (id.equals(PROPERTY_STAFF_ASSIGNMENT_RULE)) {
                if (value instanceof StaffAssignmentRuleDialogue) {
                    return ((StaffAssignmentRuleDialogue)value).wasStaffAssignmentRuleChanged();
                }
                return true;
            }
            if (id.equals(PROPERTY_AUTO_START)) {
                boolean autoStart;
                boolean bl = autoStart = (Integer)value == 0;
                if (this.getCastedModel().isAutoStartEnabled() == autoStart) {
                    return false;
                }
            } else {
                if (id.equals(PROPERTY_BUSINESS_PROCESS)) {
                    return true;
                }
                if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
                    return true;
                }
                if (id.equals(PROPERTY_SUPPORTED_PLUGINS)) {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean arePropertiesChangeable(Object ... ids) {
        boolean changeable = false;
        HashSet<ProcessConstants.NodeProperty> properties = new HashSet<ProcessConstants.NodeProperty>();
        if (this.instance != null ? !(this.instance instanceof ChangeableInstance) : !this.isChangeableTemplate()) {
            return false;
        }
        ProcessConstants.NodeType nodeType = this.getTemplate().getNodeType(this.getCastedModel().getID());
        if (nodeType == ProcessConstants.NodeType.NT_STARTFLOW || nodeType == ProcessConstants.NodeType.NT_ENDFLOW) {
            return false;
        }
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            if (id.equals(PROPERTY_ID) || id.equals(PROPERTY_BRANCH_ID) || id.equals(PROPERTY_BUSINESS_PROCESS)) {
                return false;
            }
            if (id.equals(PROPERTY_NAME)) {
                if (SystemDataTools.findParameterReferences((String)this.getCastedModel().getName()).length == 0) {
                    properties.add(ProcessConstants.NodeProperty.NAME);
                }
            } else if (id.equals(PROPERTY_DESCRIPTION)) {
                if (SystemDataTools.findParameterReferences((String)this.getCastedModel().getDescription()).length == 0) {
                    properties.add(ProcessConstants.NodeProperty.DESCRIPTION);
                }
            } else if (id.equals(PROPERTY_STAFF_ASSIGNMENT_RULE)) {
                if (SystemDataTools.findParameterReferences((String)this.getCastedModel().getStaffAssignmentRule()).length == 0) {
                    properties.add(ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE);
                }
            } else {
                if (id.equals(PROPERTY_AUTO_START)) {
                    return false;
                }
                if (id.equals(PROPERTY_DELEGATION_RECIPIENTS)) {
                    if (this.instance != null) {
                        if (UpdatePluginDataContainer.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)this.getCastedModel(), (String)"SchedulerData", (String)"SchedulerData", (PluginData)new DefaultPluginData("SchedulerData"))) {
                            changeable = true;
                        }
                    } else if (UpdatePluginDataContainer.isPossible((Template)this.template, (PluginDataContainer)this.getCastedModel(), (String)"SchedulerData", (String)"SchedulerData", (PluginData)new DefaultPluginData("SchedulerData"))) {
                        changeable = true;
                    }
                    return changeable;
                }
                if (id.equals(PROPERTY_ENQUIRY_RECIPIENTS)) {
                    if (this.instance != null) {
                        if (UpdatePluginDataContainer.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)this.getCastedModel(), (String)"Enquiry", (String)"Enquiry", (PluginData)new DefaultPluginData("Enquiry"))) {
                            changeable = true;
                        }
                    } else if (UpdatePluginDataContainer.isPossible((Template)this.template, (PluginDataContainer)this.getCastedModel(), (String)"Enquiry", (String)"Enquiry", (PluginData)new DefaultPluginData("Enquiry"))) {
                        changeable = true;
                    }
                    return changeable;
                }
                if (id.equals(PROPERTY_USER_ATTRIBUTES)) {
                    properties.add(ProcessConstants.NodeProperty.USER_ATTRIBUTE);
                } else {
                    return false;
                }
            }
            ++n2;
        }
        if (this.instance != null) {
            if (UpdateNode.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (Node)this.getCastedModel(), (ProcessConstants.NodeProperty[])properties.toArray(new ProcessConstants.NodeProperty[0]))) {
                changeable = true;
            }
        } else if (UpdateNode.isPossible((Template)this.template, (Node)this.getCastedModel(), (ProcessConstants.NodeProperty[])properties.toArray(new ProcessConstants.NodeProperty[0]))) {
            changeable = true;
        }
        return changeable;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        Node newModel = newTemplate.getNode(this.getCastedModel().getID());
        this.setTemplate(newTemplate);
        this.setModel(newModel);
    }
}

