/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.orgmodelmanager.ModelExplorer;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.dialogues.QualifiedAgentDialogue;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class QualifiedAgentCellEditor
extends DialogCellEditor {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private Template template;
    private Instance instance;

    public QualifiedAgentCellEditor(Composite parent, Template template) {
        super(parent);
        this.template = template;
    }

    public QualifiedAgentCellEditor(Composite parent, Instance instance) {
        super(parent);
        this.instance = instance;
        this.template = instance.getTemplate();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        QualifiedAgent agent = (QualifiedAgent)this.getValue();
        ADEPT2ClientService clientService = Activator.getService();
        ResourceBundle messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.processvisualisation.views.PVPBundle", clientService.getActiveAgent().getLocale());
        SessionToken session = clientService.getSessionToken();
        ModelExplorer orgModelExplorer = clientService.getOrgModelManager().getModelExplorer();
        HashSet<QualifiedAgent> agents = new HashSet<QualifiedAgent>();
        try {
            for (Entity entity : orgModelExplorer.getEntities(session, EntityType.AGENT, new String[0])) {
                agents.addAll(this.getQualifiedAgentsFor(entity.getInteger("id"), entity.getString("userName"), session, orgModelExplorer));
            }
        }
        catch (DataSourceException e) {
            String message = "Error in the data source. Data source not available";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            return agent;
        }
        agents.add(clientService.getActiveAgent().getQualifiedAgent());
        QualifiedAgentDialogue dialogue = new QualifiedAgentDialogue(cellEditorWindow.getShell(), agents, messages, "SupervisorQA", false, false, false, clientService.getActiveAgent().getQualifiedAgent());
        if (dialogue.open() != 0) {
            return agent;
        }
        return dialogue.getSelectedAgents().toArray()[0];
    }

    protected void updateContents(Object value) {
        String text = "";
        if (value != null) {
            text = ((QualifiedAgent)value).toString();
        }
        super.updateContents((Object)text);
    }

    private List<QualifiedAgent> getQualifiedAgentsFor(long agentID, String agentName, SessionToken session, ModelExplorer orgModelExplorer) throws DataSourceException {
        List orgPositionEntities = orgModelExplorer.getRelatedEntities(session, EntityType.AGENT, agentID, RelationType.ORG_POSITION_OCCUPATION, false, new String[0]);
        ArrayList<QualifiedAgent> ret = new ArrayList<QualifiedAgent>(orgPositionEntities.size());
        for (Entity orgPosition : orgPositionEntities) {
            ret.add(new QualifiedAgent(agentID, agentName, orgPosition.getInteger("id"), orgPosition.getString("name")));
        }
        return ret;
    }
}

