/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.core.changeoperations.NodeDependencyProvider;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StaffAssignmentRuleCellEditor
extends DialogCellEditor {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private Template template;
    private Instance instance;

    public StaffAssignmentRuleCellEditor(Composite parent, Template template) {
        super(parent);
        this.template = template;
    }

    public StaffAssignmentRuleCellEditor(Composite parent, Instance instance) {
        super(parent);
        this.instance = instance;
        this.template = instance.getTemplate();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Node node = (Node)this.getValue();
        if (!(this.template instanceof ChangeableTemplate)) {
            this.logger.severe("The staff assignment rule dialog was called for a non-changeable template. Ignoring request!");
            return node;
        }
        StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
        if (providers.length == 0) {
            throw new RuntimeException("There are no registered Staff Assignment Rule Dialogue providers!");
        }
        StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(cellEditorWindow.getShell(), Activator.getService().getOrgModelManager());
        dialogue.open(node.getStaffAssignmentRule(), (DependencyProvider)new NodeDependencyProvider(this.template, node.getID()));
        if (dialogue.wasStaffAssignmentRuleChanged()) {
            this.deactivate();
            return dialogue;
        }
        return node;
    }

    protected void updateContents(Object value) {
        String text = "";
        if (value != null) {
            text = value instanceof StaffAssignmentRuleDialogue ? ((StaffAssignmentRuleDialogue)value).getStaffAssignmentRule() : ((Node)value).getStaffAssignmentRule();
        }
        super.updateContents((Object)text);
    }
}

