/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroupDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import java.util.Map;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class StringMapDialogue
extends Dialog {
    public static final String NAME_PROPERTY = "Name";
    public static final String VALUE_PROPERTY = "Value";
    private static final String[] COLUMN_PROPERTIES = new String[]{"Name", "Value"};
    protected Template template;
    protected Instance instance;
    protected TableViewer tableViewer;
    private Object model;
    private Button closeButton;
    protected Shell shell;
    protected NewEntryDialog dialog;

    public Map<String, String> open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67616);
        this.shell.setText(this.getTitle());
        this.shell.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this.shell, 0);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        try {
            this.createContent(composite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringMapDialogue.this.onClose();
                StringMapDialogue.this.shell.dispose();
            }
        });
        this.shell.pack();
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getEntryMap();
    }

    private void createContent(Composite composite) {
        Table table = this.createTable(composite);
        this.createTableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        this.tableViewer.setInput(this.getEntryMap());
        this.createButtons(composite);
    }

    private Table createTable(Composite composite) {
        Table table = new Table(composite, 68356);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.minimumHeight = 300;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setWidth(200);
        column.setText(NAME_PROPERTY);
        column = new TableColumn(table, 16384, 1);
        column.setWidth(200);
        column.setText(VALUE_PROPERTY);
        return table;
    }

    private void createTableViewer(Table table) {
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(COLUMN_PROPERTIES);
        CellEditor[] editors = new CellEditor[table.getColumnCount()];
        if (this.isChangeable()) {
            editors[1] = new TextCellEditor((Composite)table);
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new EntryCellModifier());
    }

    protected boolean isChangeable() {
        return this.template instanceof ChangeableTemplate;
    }

    protected ChangeableTemplate getChangeableTemplate() {
        return this.isChangeable() ? (ChangeableTemplate)this.template : null;
    }

    private void createButtons(Composite composite) {
        Button add = new Button(composite, 0x1000008);
        add.setText("Add");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringMapDialogue.this.addEntry();
            }
        });
        add.setEnabled(this.isChangeable());
        final Button delete = new Button(composite, 0x1000008);
        delete.setText("Delete");
        gridData = new GridData(32);
        gridData.widthHint = 80;
        delete.setLayoutData((Object)gridData);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] entry = (String[])((IStructuredSelection)StringMapDialogue.this.tableViewer.getSelection()).getFirstElement();
                if (entry != null) {
                    StringMapDialogue.this.removeTableEntry(entry);
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (StringMapDialogue.this.isChangeable() && StringMapDialogue.this.tableViewer.getSelection() != null && !StringMapDialogue.this.tableViewer.getSelection().isEmpty()) {
                    delete.setEnabled(true);
                } else {
                    delete.setEnabled(false);
                }
            }
        });
        delete.setEnabled(false);
        this.closeButton = new Button(composite, 0x1000008);
        this.closeButton.setText("Close");
        gridData = new GridData(128);
        gridData.widthHint = 80;
        this.closeButton.setLayoutData((Object)gridData);
    }

    public void setValue(Object model) {
        this.model = model;
    }

    public StringMapDialogue(Shell parent, Template template) {
        super(parent);
        this.template = template;
    }

    public StringMapDialogue(Shell parent, Instance instance) {
        super(parent);
        this.instance = instance;
        this.template = instance.getTemplate();
    }

    protected void addEntry() {
        if (this.isChangeable()) {
            if (this.dialog == null) {
                this.dialog = new NewEntryDialog(this.shell);
            }
            if (this.dialog.open()) {
                String name = this.dialog.getName();
                String value = this.dialog.getValue();
                String[] entry = new String[]{name, value};
                if (!this.getEntryMap().containsKey(name)) {
                    this.addTableEntry(entry);
                } else {
                    MessageBox mb = new MessageBox(new Shell(), 200);
                    mb.setMessage(this.warningMessageBoxString());
                    if (mb.open() == 64) {
                        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem item = tableItemArray[n2];
                            if (item.getText().equals(name)) {
                                entry = (String[])item.getData();
                                break;
                            }
                            ++n2;
                        }
                        this.updateTableEntry(entry, VALUE_PROPERTY, value);
                    }
                }
            }
        }
    }

    protected void addTableEntry(String[] entry) {
        if (this.addEntry(entry)) {
            String[][] elements = new String[][]{entry};
            this.tableViewer.add((Object[])elements);
        }
    }

    protected void removeTableEntry(String[] entry) {
        if (this.removeEntry(entry)) {
            String[][] elements = new String[][]{entry};
            this.tableViewer.remove((Object[])elements);
        }
    }

    protected void updateTableEntry(String[] entry, String property, String newValue) {
        if (this.updateEntry(entry, property, newValue)) {
            entry[1] = newValue;
            String[][] elements = new String[][]{entry};
            this.tableViewer.update((Object[])elements, new String[]{VALUE_PROPERTY});
        }
    }

    protected abstract boolean addEntry(String[] var1);

    protected abstract boolean removeEntry(String[] var1);

    protected abstract boolean updateEntry(String[] var1, String var2, String var3);

    protected abstract String getTitle();

    protected abstract Map<String, String> getEntryMap();

    protected Object getModel() {
        return this.model;
    }

    protected abstract String warningMessageBoxString();

    protected void onClose() {
    }

    protected void startChangeTransaction() {
        if (this.instance != null) {
            ChangeableInstance changeInstance = (ChangeableInstance)this.instance;
            Template oldTemplate = this.instance.getTemplate();
            StartTransaction.performOperation((ChangeableInstance)changeInstance, (UpdateManager)Activator.getService().getUpdateManager());
            Template newTemplate = this.instance.getTemplate();
            if (oldTemplate != newTemplate) {
                this.getViewer().setContents((Object)newTemplate);
                this.updateSelectionManager(newTemplate);
                this.refreshModel(newTemplate);
            }
        } else {
            StartTransaction.performOperation((ChangeableTemplate)this.getChangeableTemplate(), (UpdateManager)Activator.getService().getUpdateManager());
        }
    }

    private void updateSelectionManager(Template newTemplate) {
        IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager manager = null;
        if (ed instanceof ProcessVisualiser) {
            manager = ((ProcessVisualiser)ed).getSelectionManager();
            SelectionGroupDefinition definition = manager.getActiveGroup().getDefinition();
            manager.updateSelectionReferencesForGroup(newTemplate, definition);
        }
    }

    protected abstract void refreshModel(Template var1);

    protected void endChangeTransaction() {
        String transactionLabel = "User attribute / activity change";
        if (this.instance != null) {
            EndTransaction.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (UpdateManager)Activator.getService().getUpdateManager(), (String)transactionLabel);
        } else {
            EndTransaction.performOperation((ChangeableTemplate)this.getChangeableTemplate(), (UpdateManager)Activator.getService().getUpdateManager(), (String)transactionLabel);
        }
    }

    protected GraphicalViewer getViewer() {
        GraphicalViewer viewer = null;
        IEditorPart pv = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (pv instanceof ProcessVisualiser) {
            viewer = ((ProcessVisualiser)pv).getGraphicalViewer();
        }
        return viewer;
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Map model = (Map)inputElement;
            String[][] elements = new String[model.size()][2];
            int i = 0;
            for (Map.Entry attrib : model.entrySet()) {
                elements[i][0] = (String)attrib.getKey();
                elements[i][1] = (String)attrib.getValue();
                ++i;
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class EntryCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            if (property.endsWith(StringMapDialogue.NAME_PROPERTY)) {
                return false;
            }
            return StringMapDialogue.this.isChangeable();
        }

        public Object getValue(Object element, String property) {
            String[] entry = (String[])element;
            if (property.equals(StringMapDialogue.NAME_PROPERTY)) {
                return entry[0];
            }
            if (property.equals(StringMapDialogue.VALUE_PROPERTY)) {
                return entry[1];
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            try {
                String[] entry = element instanceof TableItem ? (String[])((TableItem)element).getData() : (String[])element;
                String newValue = (String)value;
                StringMapDialogue.this.updateTableEntry(entry, property, newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class EntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String[] entry = (String[])element;
            switch (columnIndex) {
                case 0: {
                    return entry[0];
                }
                case 1: {
                    return entry[1];
                }
            }
            return null;
        }
    }

    static class NewEntryDialog
    extends Dialog {
        protected String name;
        protected String value;
        protected boolean result;

        public NewEntryDialog(Shell parent) {
            super(parent);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean open() {
            this.name = null;
            this.value = null;
            this.result = false;
            Shell parent = this.getParent();
            Shell shell = new Shell(parent, 67616);
            shell.setText("New Entry");
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.horizontalSpacing = 10;
            layout.verticalSpacing = 10;
            shell.setLayout((Layout)layout);
            this.createContent(shell);
            shell.pack();
            shell.open();
            Display display = parent.getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.result;
        }

        private void createContent(final Shell shell) {
            Label label = new Label((Composite)shell, 0);
            label.setText("Name:");
            final Text nameText = new Text((Composite)shell, 2052);
            GridData gridData = new GridData();
            gridData.widthHint = 160;
            nameText.setLayoutData((Object)gridData);
            label = new Label((Composite)shell, 0);
            label.setText("Value:");
            final Text valueText = new Text((Composite)shell, 2052);
            gridData = new GridData();
            gridData.widthHint = 160;
            valueText.setLayoutData((Object)gridData);
            final Button buttonOK = new Button((Composite)shell, 8);
            buttonOK.setText("Ok");
            gridData = new GridData(32);
            gridData.widthHint = 80;
            buttonOK.setLayoutData((Object)gridData);
            Button buttonCancel = new Button((Composite)shell, 8);
            buttonCancel.setText("Cancel");
            gridData = new GridData(128);
            gridData.widthHint = 80;
            buttonCancel.setLayoutData((Object)gridData);
            nameText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    if (nameText.getText().trim().length() > 0) {
                        buttonOK.setEnabled(true);
                    } else {
                        buttonOK.setEnabled(false);
                    }
                }
            });
            buttonOK.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    NewEntryDialog.this.result = true;
                    NewEntryDialog.this.name = nameText.getText();
                    NewEntryDialog.this.value = valueText.getText();
                    shell.dispose();
                }
            });
            buttonCancel.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    NewEntryDialog.this.result = false;
                    shell.dispose();
                }
            });
            shell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 2) {
                        event.doit = false;
                    }
                }
            });
            nameText.setText("");
            valueText.setText("");
        }
    }
}

