/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.ui.systemdata.MessageChangeListener;
import de.aristaflow.adept2.ui.systemdata.ParameterBindingsUIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemDataConsumerDialogue {
    String windowTitle;
    String title;
    String message;
    String consumerString;
    boolean multiline;
    boolean wasConsumerStringChanged;
    DependencyProvider dependencyProvider;
    private SystemDataConsumerDialogueImpl dialogueWindow;

    public SystemDataConsumerDialogue(Shell parentShell) {
        this.dialogueWindow = new SystemDataConsumerDialogueImpl(parentShell);
    }

    public boolean open(String consumerString, DependencyProvider dependencyProvider) {
        return this.open(consumerString, false, dependencyProvider);
    }

    public boolean open(String consumerString, boolean multiline, DependencyProvider dependencyProvider) {
        ArgChecks.checkForNull((Object)consumerString, (String)"consumerString");
        ArgChecks.checkForNull((Object)dependencyProvider, (String)"dependencyProvider");
        this.consumerString = consumerString;
        this.multiline = multiline;
        this.dependencyProvider = dependencyProvider;
        return this.dialogueWindow.open() == 0;
    }

    public void setTitleAndMessage(String windowTitle, String title, String message) {
        this.windowTitle = windowTitle;
        this.title = title;
        this.message = message;
    }

    public boolean wasConsumerStringOrBindingsChanged() {
        return this.wasConsumerStringChanged;
    }

    public String getConsumerString() {
        return this.consumerString;
    }

    public Map<String, Dependency> getParameterBindings() {
        return this.dialogueWindow.bindingsUI.getParameterBindings();
    }

    <T> T getFirstElement(Collection<T> collection) {
        Iterator<T> it = collection.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    static Font deriveFontStyle(Font originalFont, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = originalFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setStyle(style);
            ++n2;
        }
        Font derivedFont = new Font(originalFont.getDevice(), fontData);
        return derivedFont;
    }

    static Map<String, ParameterRef> toMap(ParameterRef[] refs) {
        LinkedHashMap<String, ParameterRef> map = new LinkedHashMap<String, ParameterRef>();
        ParameterRef[] parameterRefArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            map.put(ref.getName(), ref);
            ++n2;
        }
        return map;
    }

    private class SystemDataConsumerDialogueImpl
    extends TitleAreaDialog {
        private Text area_stringInput_text;
        ParameterBindingsUIComponent bindingsUI;

        public SystemDataConsumerDialogueImpl(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() + 16);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (SystemDataConsumerDialogue.this.windowTitle != null) {
                shell.setText(SystemDataConsumerDialogue.this.windowTitle);
            } else {
                shell.setText("System Data Consumer Dialogue");
            }
        }

        public void setErrorMessage(String newErrorMessage) {
            super.setErrorMessage(newErrorMessage);
            if (newErrorMessage == null) {
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        }

        protected void okPressed() {
            SystemDataConsumerDialogue.this.consumerString = this.area_stringInput_text.getText();
            super.okPressed();
        }

        public boolean close() {
            return super.close();
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.initWidgetContent();
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite area_dialogue = new Composite((Composite)super.createDialogArea(parent), 0);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(450);
            area_dialogue.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout(1, false);
            area_dialogue.setLayout((Layout)layout);
            Composite area_textBox = this.createArea_stringInput(area_dialogue);
            layoutData = SystemDataConsumerDialogue.this.multiline ? new GridData(4, 4, true, true) : new GridData(4, 4, true, false);
            area_textBox.setLayoutData((Object)layoutData);
            this.bindingsUI = new ParameterBindingsUIComponent(area_dialogue, SystemDataConsumerDialogue.this.dependencyProvider);
            layoutData = new GridData(4, 4, true, true);
            this.bindingsUI.getControl().setLayoutData((Object)layoutData);
            this.bindingsUI.addMessageChangeListener(new MessageChangeListener(){

                public void messageChanged(int messageType, String message) {
                    if (messageType == 3) {
                        SystemDataConsumerDialogueImpl.this.setErrorMessage(message);
                    } else {
                        SystemDataConsumerDialogueImpl.this.setErrorMessage(null);
                        SystemDataConsumerDialogueImpl.this.setMessage(message, messageType);
                    }
                }
            });
            this.initWidgetWiring();
            return area_dialogue;
        }

        private Composite createArea_stringInput(Composite parent) {
            GridData layoutData;
            Composite area = new Composite(parent, 0);
            area.setLayout((Layout)new GridLayout(1, false));
            if (SystemDataConsumerDialogue.this.multiline) {
                this.area_stringInput_text = new Text(area, 2050);
                layoutData = new GridData(4, 4, true, true);
                layoutData.heightHint = this.area_stringInput_text.getLineHeight() * 5;
            } else {
                this.area_stringInput_text = new Text(area, 2052);
                layoutData = new GridData(4, 4, true, false);
            }
            this.area_stringInput_text.setLayoutData((Object)layoutData);
            return area;
        }

        private void initWidgetWiring() {
            this.area_stringInput_text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemDataConsumerDialogueImpl.this.consumerStringChanged();
                }
            });
        }

        private void initWidgetContent() {
            this.area_stringInput_text.setText(SystemDataConsumerDialogue.this.consumerString);
            this.area_stringInput_text.setSelection(SystemDataConsumerDialogue.this.consumerString.length());
            SystemDataConsumerDialogue.this.wasConsumerStringChanged = false;
            if (SystemDataConsumerDialogue.this.title != null) {
                this.setTitle(SystemDataConsumerDialogue.this.title);
            } else {
                this.setTitle("System Data Consumer String");
            }
            if (SystemDataConsumerDialogue.this.message != null) {
                this.setMessage(SystemDataConsumerDialogue.this.message);
            } else {
                this.setMessage("Enter the new string and assign dependencies to the contained parameter references.");
            }
        }

        void consumerStringChanged() {
            SystemDataConsumerDialogue.this.wasConsumerStringChanged = true;
            this.updateParameters();
        }

        void updateParameters() {
            String consumerString = this.area_stringInput_text.getText();
            ParameterRef[] referencedParameters = SystemDataTools.findParameterReferences((String)consumerString);
            this.bindingsUI.setParameterReferences(referencedParameters);
        }
    }
}

