/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.CollectionLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.ExtendedPropertyDescriptor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.InputParametersPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.OutputParametersPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.QualifiedAgentCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.QualifiedAgentLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TemplatePropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.TemplatePropertySource";
    public static final String PROPERTY_NAME = String.valueOf(ID) + "/Name";
    public static final String PROPERTY_DESCRIPTION = String.valueOf(ID) + "/Description";
    public static final String PROPERTY_INSTANCE_NAME_TEMPLATE = String.valueOf(ID) + "/InstanceNameTemplate";
    private static final String PROPERTY_INPUT_PARAMETERS = String.valueOf(ID) + "/InputParameters";
    private static final String PROPERTY_OUTPUT_PARAMETERS = String.valueOf(ID) + "/OutputParameters";
    public static final String PROPERTY_SUPERVISOR_AGENT = String.valueOf(ID) + "/SupervisorAgent";
    private static final String PROPERTY_TYPE = String.valueOf(ID) + "/type";
    private static final String PROPERTY_TEMPLATEID = String.valueOf(ID) + "/TemplateID";
    InputParametersPropertySource inputParametersPropertySource;
    OutputParametersPropertySource outputParametersPropertySource;

    public TemplatePropertySource(Template template) {
        super(template);
    }

    public TemplatePropertySource(Instance instance) {
        super(instance);
    }

    @Override
    protected boolean isChangeableTemplate() {
        return this.getCastedModel() instanceof ChangeableTemplate;
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(8);
        if (this.isChangeableTemplate()) {
            this.addTextDescriptor(desc, PROPERTY_NAME, "Name", "Info");
            this.addTextDescriptor(desc, PROPERTY_DESCRIPTION, "Description", "Info");
            this.addTextDescriptor(desc, PROPERTY_INSTANCE_NAME_TEMPLATE, "InstanceNameTemplate", "Info");
            this.addExtendedDescriptor(desc, PROPERTY_SUPERVISOR_AGENT, "SupervisorAgent", "Info", QualifiedAgentCellEditor.class, new QualifiedAgentLabelProvider());
        } else {
            this.addDescriptor(desc, PROPERTY_NAME, "Name", "Info");
            this.addDescriptor(desc, PROPERTY_DESCRIPTION, "Description", "Info");
            this.addDescriptor(desc, PROPERTY_INSTANCE_NAME_TEMPLATE, "InstanceNameTemplate", "Info");
            this.addDescriptor(desc, PROPERTY_SUPERVISOR_AGENT, "SupervisorAgent", "Info");
        }
        this.addExtendedDescriptor(desc, PROPERTY_INPUT_PARAMETERS, "Input Parameters", "Parameters", null, new CollectionLabelProvider());
        this.addExtendedDescriptor(desc, PROPERTY_OUTPUT_PARAMETERS, "Output Parameters", "Parameters", null, new CollectionLabelProvider());
        this.addDescriptor(desc, PROPERTY_TYPE, "Type", "Template");
        this.addDescriptor(desc, PROPERTY_TEMPLATEID, "Template ID", "Template");
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_NAME)) {
            return this.getCastedModel().getName();
        }
        if (id.equals(PROPERTY_DESCRIPTION)) {
            return this.getCastedModel().getDescription();
        }
        if (id.equals(PROPERTY_INSTANCE_NAME_TEMPLATE)) {
            return this.getCastedModel().getInstanceNameTemplate();
        }
        if (id.equals(PROPERTY_INPUT_PARAMETERS)) {
            if (this.inputParametersPropertySource == null) {
                this.inputParametersPropertySource = new InputParametersPropertySource(this.getTemplate());
            }
            this.inputParametersPropertySource.setModel(this.getCastedModel().getParameters(ActivityConstants.AccessType.READ));
            return this.inputParametersPropertySource;
        }
        if (id.equals(PROPERTY_OUTPUT_PARAMETERS)) {
            if (this.outputParametersPropertySource == null) {
                this.outputParametersPropertySource = new OutputParametersPropertySource(this.getTemplate());
            }
            this.outputParametersPropertySource.setModel(this.getCastedModel().getParameters(ActivityConstants.AccessType.WRITE));
            return this.outputParametersPropertySource;
        }
        if (id.equals(PROPERTY_SUPERVISOR_AGENT)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                if (descriptor.getId().equals(id) && descriptor instanceof ExtendedPropertyDescriptor) {
                    return this.getCastedModel().getSupervisorAgent();
                }
                ++n2;
            }
            return this.getCastedModel().getSupervisorAgent().toString();
        }
        if (id.equals(PROPERTY_TYPE)) {
            return ((Template)this.model).getProcessType();
        }
        if (id.equals(PROPERTY_TEMPLATEID)) {
            return ((Template)this.model).getID();
        }
        return null;
    }

    private Template getCastedModel() {
        return (Template)this.model;
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        this.startChangeTransaction();
        if (id.equals(PROPERTY_NAME)) {
            ((ChangeableTemplate)this.getCastedModel()).setName((String)value);
            Activator.getService().getUpdateManager().firePropertyChange(this.model, (Object)UpdateManager.ProcessProperties.PROCESS_NAME);
        } else if (id.equals(PROPERTY_DESCRIPTION)) {
            ((ChangeableTemplate)this.getCastedModel()).setDescription((String)value);
            Activator.getService().getUpdateManager().firePropertyChange(this.model, (Object)UpdateManager.ProcessProperties.PROCESS_DESCRIPTION);
        } else if (id.equals(PROPERTY_INSTANCE_NAME_TEMPLATE)) {
            ((ChangeableTemplate)this.getCastedModel()).setInstanceNameTemplate((String)value);
            Activator.getService().getUpdateManager().firePropertyChange(this.model, (Object)UpdateManager.ProcessProperties.PROCESS_INSTANCE_NAME_TEMPLATE);
        } else if (id.equals(PROPERTY_SUPERVISOR_AGENT)) {
            ((ChangeableTemplate)this.getCastedModel()).setSupervisorAgent((QualifiedAgent)value);
            Activator.getService().getUpdateManager().firePropertyChange(this.model, (Object)UpdateManager.ProcessProperties.PROCESS_SUPERVISOR_AGENT);
        } else {
            if (id.equals(PROPERTY_INPUT_PARAMETERS)) {
                this.inputParametersPropertySource = null;
                return;
            }
            if (id.equals(PROPERTY_OUTPUT_PARAMETERS)) {
                this.outputParametersPropertySource = null;
                return;
            }
        }
        String transactionLabel = "Changing template property";
        this.endChangeTransaction(transactionLabel);
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        Template template = this.getCastedModel();
        if (id.equals(PROPERTY_NAME)) {
            return !template.getName().equals(value);
        }
        if (id.equals(PROPERTY_DESCRIPTION)) {
            return !template.getDescription().equals(value);
        }
        if (id.equals(PROPERTY_INSTANCE_NAME_TEMPLATE)) {
            if (template.getInstanceNameTemplate() == null) {
                return value != null;
            }
            return !template.getInstanceNameTemplate().equals(value);
        }
        if (id.equals(PROPERTY_SUPERVISOR_AGENT)) {
            return !template.getSupervisorAgent().equals(value);
        }
        if (id.equals(PROPERTY_INPUT_PARAMETERS)) {
            return true;
        }
        if (id.equals(PROPERTY_OUTPUT_PARAMETERS)) {
            return true;
        }
        return true;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        Template newModel = newTemplate;
        this.setModel(newModel);
    }
}

