/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources;

import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.changeoperations.UpdateUserAttribute;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class UserAttributesPropertySource
extends AbstractPropertySource {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".propertysources.UserAttributesPropertySource";
    public static final String PROPERTY_NAME = String.valueOf(ID) + "/Name";
    public static final String PROPERTY_VALUE = String.valueOf(ID) + "/Value";

    public UserAttributesPropertySource(Template template) {
        super(template);
    }

    public UserAttributesPropertySource(Instance instance) {
        super(instance);
    }

    @Override
    public Object getEditableValue() {
        return this.model;
    }

    @Override
    protected List<IPropertyDescriptor> createDescriptor() {
        ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>(8);
        for (String entry : this.getCastedModel().getUserAttributes().keySet()) {
            if (this.arePropertiesChangeable(entry)) {
                this.addTextDescriptor(desc, entry, entry, "User Attributes");
                continue;
            }
            this.addDescriptor(desc, entry, entry, "User Attributes");
        }
        return desc;
    }

    @Override
    public Object getPropertyValue(Object id) {
        return this.getCastedModel().getUserAttributes().get(id);
    }

    private UserAttributeContainer getCastedModel() {
        return (UserAttributeContainer)this.model;
    }

    @Override
    protected void changePropertyValue(Object id, Object value) {
        this.startChangeTransaction();
        if (this.instance != null) {
            UpdateUserAttribute.performOperation((ChangeableInstance)this.getChangeableInstance(), (UserAttributeContainer)this.getCastedModel(), (String)id.toString(), (String)value.toString(), (UpdateManager)Activator.getService().getUpdateManager());
        } else {
            UpdateUserAttribute.performOperation((ChangeableTemplate)this.getChangeableTemplate(), (UserAttributeContainer)this.getCastedModel(), (String)id.toString(), (String)value.toString(), (UpdateManager)Activator.getService().getUpdateManager());
        }
        String transactionLabel = "User attribute change";
        this.endChangeTransaction(transactionLabel);
    }

    @Override
    protected boolean hasValueChanged(Object id, Object value) {
        return !this.getCastedModel().getUserAttributes().containsKey(id) || !((String)this.getCastedModel().getUserAttributes().get(id)).equals(value);
    }

    @Override
    public boolean arePropertiesChangeable(Object ... ids) {
        boolean changeable = false;
        boolean isInstance = false;
        if (this.instance != null) {
            if (!(this.instance instanceof ChangeableInstance)) {
                return false;
            }
            isInstance = true;
        } else if (!this.isChangeableTemplate()) {
            return false;
        }
        if (this.getCastedModel() instanceof Node) {
            changeable = isInstance ? UpdateNode.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (Node)((Node)this.getCastedModel()), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.USER_ATTRIBUTE}) : UpdateNode.isPossible((Template)this.template, (Node)((Node)this.getCastedModel()), (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.USER_ATTRIBUTE});
        } else if (this.getCastedModel() instanceof DataElement) {
            changeable = isInstance ? UpdateDataElement.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (DataElement)((DataElement)this.getCastedModel()), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.USER_ATTRIBUTE}) : UpdateDataElement.isPossible((Template)this.template, (DataElement)((DataElement)this.getCastedModel()), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{ProcessConstants.DataElementProperty.USER_ATTRIBUTE});
        } else {
            return true;
        }
        return changeable;
    }

    @Override
    protected void refreshModel(Template newTemplate) {
        IProcessEditPart activePart;
        IEditorPart pv = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager manager = null;
        if (pv instanceof ProcessVisualiser && (activePart = (manager = ((ProcessVisualiser)pv).getSelectionManager()).getActiveEditPart()).getModel() instanceof UserAttributeContainer) {
            UserAttributeContainer newModel = null;
            if (activePart.getModel().getClass().equals(this.model.getClass())) {
                newModel = (UserAttributeContainer)activePart.getModel();
            } else if (this.model instanceof ExecutableBusinessProcess && activePart.getModel() instanceof Node) {
                newModel = ((Node)activePart.getModel()).getExecutableBusinessProcess();
            } else {
                String message = "The type of the user attribute container is unknown";
                this.logger.severe(message);
                throw new IllegalArgumentException(message);
            }
            this.template = newTemplate;
            this.setModel(newModel);
        }
    }
}

