/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.scheduling.DataElementSelectionMessageDialogue;
import de.aristaflow.adept2.ui.util.CalendarToolTip;
import de.aristaflow.adept2.util.time.CalendarTools;
import java.util.Calendar;
import java.util.LinkedList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AbsoluteTimeWidget
extends Composite {
    static final String[] ABSOLUTE_TIME_OPTION_ITEMS = new String[]{"Static", "Value from Data Element..."};
    private static final String ABSOLUTE_TIME_COMBO_DATA_ELEMENT = "AbsoluteTimeDataElement";
    protected Combo typeCombo;
    protected DateTime timeWidget;
    protected DateTime dateWidget;
    protected Label calendarImgLbl;
    private CalendarToolTip calendarToolTip;
    Template template;

    public AbsoluteTimeWidget(Composite parent, int style, FormToolkit toolkit, final SelectionListener defaultSelectionListener, Template template) {
        super(parent, style);
        this.template = template;
        this.setLayout((Layout)new GridLayout(7, false));
        this.typeCombo = new Combo((Composite)this, 8);
        this.typeCombo.setItems(ABSOLUTE_TIME_OPTION_ITEMS);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = AbsoluteTimeWidget.this.typeCombo.getSelectionIndex();
                if (selectionIndex == 1) {
                    LinkedList<DataElement> dataElements = new LinkedList<DataElement>();
                    for (DataElement dataElement : AbsoluteTimeWidget.this.template.getDataElements()) {
                        if (dataElement.getDataType() != ProcessConstants.AdeptDataType.DATE) continue;
                        dataElements.add(dataElement);
                    }
                    int selectedIndex = 0;
                    DataElementSelectionMessageDialogue dialogue = new DataElementSelectionMessageDialogue(AbsoluteTimeWidget.this.typeCombo.getShell(), dataElements, selectedIndex);
                    int res = dialogue.open();
                    if (res == 0) {
                        DataElement dataElement = (DataElement)dataElements.get(dialogue.getSelectedIndex());
                        AbsoluteTimeWidget.this.typeCombo.setData(AbsoluteTimeWidget.ABSOLUTE_TIME_COMBO_DATA_ELEMENT, (Object)dataElement);
                        AbsoluteTimeWidget.this.typeCombo.setItem(selectionIndex, "Value from Data Element: " + dataElement.getName());
                        AbsoluteTimeWidget.this.typeCombo.select(selectionIndex);
                    } else if (AbsoluteTimeWidget.this.typeCombo.getData(AbsoluteTimeWidget.ABSOLUTE_TIME_COMBO_DATA_ELEMENT) == null) {
                        AbsoluteTimeWidget.this.typeCombo.setItem(selectionIndex, "Value from Data Element...");
                        AbsoluteTimeWidget.this.typeCombo.select(0);
                    }
                    AbsoluteTimeWidget.this.enableAbsoluteStaticDateWidgets(false);
                } else if (selectionIndex == 0) {
                    AbsoluteTimeWidget.this.enableAbsoluteStaticDateWidgets(true);
                }
            }
        });
        this.typeCombo.addSelectionListener(defaultSelectionListener);
        this.timeWidget = new DateTime((Composite)this, 32896);
        toolkit.adapt((Composite)this.timeWidget);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.horizontalSpan = 2;
        this.timeWidget.setLayoutData((Object)layoutData);
        this.timeWidget.addSelectionListener(defaultSelectionListener);
        this.dateWidget = new DateTime((Composite)this, 32);
        toolkit.adapt((Composite)this.dateWidget);
        layoutData = new GridData(4, 4, false, false);
        layoutData.horizontalSpan = 2;
        this.dateWidget.setLayoutData((Object)layoutData);
        this.dateWidget.addSelectionListener(defaultSelectionListener);
        this.calendarImgLbl = toolkit.createLabel((Composite)this, "", 0);
        Image image = MiscImages.getImage((String)"calendar.png");
        this.calendarImgLbl.setImage(image);
        this.calendarToolTip = new CalendarToolTip((Control)this.calendarImgLbl, this.dateWidget);
        this.calendarToolTip.setShift(new Point(-5, -5));
        this.calendarToolTip.setHideOnMouseDown(false);
        this.calendarToolTip.addToolTipListener(new CalendarToolTip.ToolTipListener(){

            public void toolTipCreated() {
            }

            public void toolTipHidden(boolean changed) {
                if (changed) {
                    defaultSelectionListener.widgetSelected(null);
                }
            }
        });
        this.enableControls(false);
    }

    public void reset(Template template) {
        this.template = template;
        this.typeCombo.deselectAll();
        this.typeCombo.setData(ABSOLUTE_TIME_COMBO_DATA_ELEMENT, null);
    }

    public void setTypeSelection(int index) {
        if (index < 0 || index >= ABSOLUTE_TIME_OPTION_ITEMS.length) {
            throw new IllegalArgumentException("Index not within time options.");
        }
        this.typeCombo.select(index);
    }

    public void setReferencedDataElement(DataElement dataElement) {
        int selectedIndex = this.typeCombo.getSelectionIndex();
        this.typeCombo.setData(ABSOLUTE_TIME_COMBO_DATA_ELEMENT, (Object)dataElement);
        this.typeCombo.setItem(1, "Value from Data Element: " + dataElement.getName());
        this.typeCombo.select(selectedIndex);
    }

    public void setAbsoluteTime(long dueDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dueDate);
        this.timeWidget.setHours(calendar.get(11));
        this.timeWidget.setMinutes(calendar.get(12));
        this.dateWidget.setYear(calendar.get(1));
        this.dateWidget.setMonth(calendar.get(2));
        this.dateWidget.setDay(calendar.get(5));
    }

    public void enableControls(boolean enable) {
        this.typeCombo.setEnabled(enable);
        if (!enable || this.typeCombo.getSelectionIndex() == 0) {
            this.enableAbsoluteStaticDateWidgets(enable);
        }
    }

    public void enableAbsoluteStaticDateWidgets(boolean enabled) {
        this.dateWidget.setEnabled(enabled);
        this.timeWidget.setEnabled(enabled);
        this.calendarImgLbl.setEnabled(enabled);
        if (enabled) {
            this.calendarToolTip.activate();
        } else {
            this.calendarToolTip.deactivate();
        }
    }

    public long getAbsoluteTime() {
        long dueDate = CalendarTools.setDateInMillis((long)0L, (int)this.dateWidget.getYear(), (int)this.dateWidget.getMonth(), (int)this.dateWidget.getDay());
        dueDate = CalendarTools.setTimeInMillis((long)dueDate, (int)this.timeWidget.getHours(), (int)this.timeWidget.getMinutes(), (int)0);
        return dueDate;
    }

    public int getTypeSelection() {
        return this.typeCombo.getSelectionIndex();
    }

    public DataElement getReferencedDataElement() {
        return (DataElement)this.typeCombo.getData(ABSOLUTE_TIME_COMBO_DATA_ELEMENT);
    }
}

