/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.DataEdgePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.EdgePropertySource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EdgeBasicsSection
extends AbstractPropertySection {
    private static final int BASIC_LABEL_WIDTH = 105;
    private CLabel edgeTypeLabel;
    private Text edgeTypeText;
    private CLabel edgeCodeLabel;
    private Text edgeCodeText;
    private CLabel accessTypeLabel;
    private Text accessTypeText;
    private CLabel optionalLabel;
    CCombo optionalCombo;
    Text optionalText;
    private Form form;
    EdgeEditPart part;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Basics");
        this.getWidgetFactory().decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new FillLayout());
        Composite composite = this.getWidgetFactory().createFlatFormComposite(this.form.getBody());
        this.createEdgeControls(composite);
        this.createDataEdgeControls(composite);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof EdgeEditPart));
        this.part = (EdgeEditPart)input;
    }

    public void refresh() {
        String title = this.part instanceof DataEdgeEditPart ? "Data Edge Basics" : "Edge Basics";
        this.form.setText(title);
        AbstractPropertySource properties = (AbstractPropertySource)this.part.getAdapter(IPropertySource.class);
        if (this.part instanceof DataEdgeEditPart) {
            this.makeEdgeVisible(false);
            this.makeDataEdgeVisible(true);
            this.accessTypeText.setText(((ActivityConstants.AccessType)properties.getPropertyValue(DataEdgePropertySource.PROPERTY_ACCESS_TYPE)).toString());
            Object optionalValue = properties.getPropertyValue(DataEdgePropertySource.PROPERTY_OPTIONAL);
            if (optionalValue instanceof Integer) {
                this.optionalText.setVisible(false);
                this.optionalCombo.setVisible(true);
                this.optionalCombo.select(((Integer)properties.getPropertyValue(DataEdgePropertySource.PROPERTY_OPTIONAL)).intValue());
            } else {
                this.optionalCombo.setVisible(false);
                this.optionalText.setVisible(true);
                this.optionalText.setText(((Boolean)properties.getPropertyValue(DataEdgePropertySource.PROPERTY_OPTIONAL)).toString());
            }
        } else {
            this.makeDataEdgeVisible(false);
            this.makeEdgeVisible(true);
            this.edgeTypeText.setText(((ProcessConstants.EdgeType)properties.getPropertyValue(EdgePropertySource.EDGE_TYPE)).toString());
            Long edgeCode = (Long)properties.getPropertyValue(EdgePropertySource.EDGE_CODE);
            if (edgeCode == Integer.MIN_VALUE) {
                this.edgeCodeText.setText("<edge code not set / not needed here>");
            } else {
                this.edgeCodeText.setText(edgeCode.toString());
            }
        }
    }

    private void makeEdgeVisible(boolean visible) {
        this.edgeCodeLabel.setVisible(visible);
        this.edgeCodeText.setVisible(visible);
        this.edgeTypeLabel.setVisible(visible);
        this.edgeTypeText.setVisible(visible);
        this.edgeCodeText.getParent().redraw();
    }

    private void makeDataEdgeVisible(boolean visible) {
        this.accessTypeLabel.setVisible(visible);
        this.accessTypeText.setVisible(visible);
        this.optionalLabel.setVisible(visible);
        this.optionalCombo.setVisible(visible);
        this.optionalText.setVisible(false);
        this.optionalCombo.getParent().redraw();
    }

    private void createEdgeControls(Composite composite) {
        this.edgeCodeText = this.getWidgetFactory().createText(composite, "");
        this.edgeCodeText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 14);
        this.edgeCodeText.setLayoutData((Object)data);
        this.edgeCodeLabel = this.getWidgetFactory().createCLabel(composite, "Edge Code:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.edgeCodeText, -5);
        data.top = new FormAttachment((Control)this.edgeCodeText, 0, 0x1000000);
        this.edgeCodeLabel.setLayoutData((Object)data);
        this.edgeTypeText = this.getWidgetFactory().createText(composite, "");
        this.edgeTypeText.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.edgeCodeText, 4);
        this.edgeTypeText.setLayoutData((Object)data);
        this.edgeTypeLabel = this.getWidgetFactory().createCLabel(composite, "Edge Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.edgeTypeText, -5);
        data.top = new FormAttachment((Control)this.edgeTypeText, 0, 0x1000000);
        this.edgeTypeLabel.setLayoutData((Object)data);
    }

    private void createDataEdgeControls(Composite composite) {
        this.accessTypeText = this.getWidgetFactory().createText(composite, "");
        this.accessTypeText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 14);
        this.accessTypeText.setLayoutData((Object)data);
        this.accessTypeLabel = this.getWidgetFactory().createCLabel(composite, "Access Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.accessTypeText, -5);
        data.top = new FormAttachment((Control)this.accessTypeText, 0, 0x1000000);
        this.accessTypeLabel.setLayoutData((Object)data);
        this.optionalCombo = this.getWidgetFactory().createCCombo(composite, 8);
        this.optionalCombo.add("true");
        this.optionalCombo.add("false");
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.accessTypeText, 4);
        this.optionalCombo.setLayoutData((Object)data);
        this.optionalCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DataEdgePropertySource properties = (DataEdgePropertySource)EdgeBasicsSection.this.part.getAdapter(IPropertySource.class);
                properties.setPropertyValue(DataEdgePropertySource.PROPERTY_OPTIONAL, EdgeBasicsSection.this.optionalCombo.getSelectionIndex());
            }
        });
        this.optionalText = this.getWidgetFactory().createText(composite, "");
        this.optionalText.setEditable(false);
        this.optionalText.setLayoutData((Object)data);
        this.optionalLabel = this.getWidgetFactory().createCLabel(composite, "Optional:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.optionalCombo, -5);
        data.top = new FormAttachment((Control)this.optionalCombo, 0, 0x1000000);
        this.optionalLabel.setLayoutData((Object)data);
    }
}

