/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.checks.processmodel.other.ErrorHandlingFilters;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.plugindata.ErrorHandlingProcessData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.dialogues.SelectTemplateDialogue;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.NodeBasicsSection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ErrorHandlingSection
extends AbstractPropertySection {
    private static final String NOT_SET = "<not set>";
    Button btnSelectErrorHandlingProcess;
    Text txtErrorHandlingProcess;
    private Form form;
    PluginDataContainer handlingDataContainer = null;
    ErrorHandlingProcessData data = null;
    EditPart part;
    private Label label;
    Template template = null;
    Instance instance = null;
    private Map<String, String> pluginDataMap;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Error handling");
        this.getWidgetFactory().decorateFormHeading(this.form);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.bottomMargin += 10;
        layout.topMargin += 10;
        layout.leftMargin += 10;
        layout.rightMargin += 10;
        layout.verticalSpacing += 5;
        this.form.getBody().setLayout((Layout)layout);
        String description = "The error handling section allows you to define a process template which will be instantiated when the node fails. You can specify a default value for all nodes of this process in the template, and additional set a specific error handling template for each node.";
        final Label lblDescription = this.getWidgetFactory().createLabel(this.form.getBody(), description, 64);
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, 3);
        tableWrapData.maxWidth = 100;
        lblDescription.setLayoutData((Object)tableWrapData);
        this.label = this.getWidgetFactory().createLabel(this.form.getBody(), "Error handling process");
        tableWrapData = new TableWrapData(128, 32);
        this.label.setLayoutData((Object)tableWrapData);
        this.txtErrorHandlingProcess = this.getWidgetFactory().createText(this.form.getBody(), "", 2048);
        this.txtErrorHandlingProcess.setEditable(false);
        tableWrapData = new TableWrapData(256, 32);
        this.txtErrorHandlingProcess.setLayoutData((Object)tableWrapData);
        this.btnSelectErrorHandlingProcess = this.getWidgetFactory().createButton(this.form.getBody(), "Select", 8);
        tableWrapData = new TableWrapData(128, 32);
        this.btnSelectErrorHandlingProcess.setLayoutData((Object)tableWrapData);
        this.btnSelectErrorHandlingProcess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ADEPT2ClientService service = Activator.getService();
                SessionToken session = service.getSessionToken();
                Shell parentShell = ErrorHandlingSection.this.btnSelectErrorHandlingProcess.getShell();
                String pluginID = Activator.getPluginID();
                TemplateManager templateManager = service.getProcessManager().getTemplateManager();
                UUID templateID = ErrorHandlingSection.this.data.getTemplateID();
                String dialogueDescription = lblDescription.getText();
                SelectTemplateDialogue dialogue = new SelectTemplateDialogue(session, parentShell, pluginID, templateManager, null, dialogueDescription, templateID, true, ErrorHandlingFilters.getTemplateFilter((FilterFactory)service.getFilterFactory()), ErrorHandlingFilters.getTemplateStatusFilter((FilterFactory)service.getFilterFactory()));
                if (dialogue.open() == 0) {
                    if (dialogue.getTemplateReference() == null) {
                        ErrorHandlingSection.this.data.setTemplateID(null);
                        ErrorHandlingSection.this.txtErrorHandlingProcess.setText(ErrorHandlingSection.this.getTemplateString((UUID)null));
                    } else {
                        TemplateReference templateReference = dialogue.getTemplateReference();
                        ErrorHandlingSection.this.data.setTemplateID(templateReference.getID());
                        ErrorHandlingSection.this.txtErrorHandlingProcess.setText(ErrorHandlingSection.this.getTemplateString(templateReference));
                    }
                    DefaultPluginData pluginData = new DefaultPluginData("ErrorHandlingProcessData", ErrorHandlingSection.this.pluginDataMap);
                    UpdateManager updateManager = service.getUpdateManager();
                    if (ErrorHandlingSection.this.instance == null) {
                        if (UpdatePluginDataContainer.isPossible((Template)ErrorHandlingSection.this.template, (PluginDataContainer)ErrorHandlingSection.this.handlingDataContainer, (String)"ErrorHandlingProcessData", (String)"ErrorHandlingProcessData", (PluginData)pluginData)) {
                            StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)ErrorHandlingSection.this.template), (UpdateManager)updateManager);
                            UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)ErrorHandlingSection.this.template), (PluginDataContainer)ErrorHandlingSection.this.handlingDataContainer, (String)"ErrorHandlingProcessData", (String)"ErrorHandlingProcessData", (PluginData)pluginData, (UpdateManager)updateManager);
                            EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)ErrorHandlingSection.this.template), (UpdateManager)updateManager);
                        }
                    } else if (UpdatePluginDataContainer.isPossible((ChangeableInstance)((ChangeableInstance)ErrorHandlingSection.this.instance), (PluginDataContainer)ErrorHandlingSection.this.handlingDataContainer, (String)"ErrorHandlingProcessData", (String)"ErrorHandlingProcessData", (PluginData)pluginData)) {
                        StartTransaction.performOperation((ChangeableInstance)((ChangeableInstance)ErrorHandlingSection.this.instance), (UpdateManager)updateManager);
                        UpdatePluginDataContainer.performOperation((ChangeableInstance)((ChangeableInstance)ErrorHandlingSection.this.instance), (PluginDataContainer)ErrorHandlingSection.this.handlingDataContainer, (String)"ErrorHandlingProcessData", (String)"ErrorHandlingProcessData", (PluginData)pluginData, (UpdateManager)updateManager);
                        EndTransaction.performOperation((ChangeableInstance)((ChangeableInstance)ErrorHandlingSection.this.instance), (UpdateManager)updateManager);
                    }
                }
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof EditPart));
        if (input instanceof BranchEditPart) {
            Template template = ((AbstractPropertySource)((BranchEditPart)input).getAdapter(IPropertySource.class)).getTemplate();
            this.part = (TemplateEditPart)((BranchEditPart)input).getViewer().getEditPartRegistry().get(template);
        } else {
            this.part = (EditPart)input;
        }
        this.handlingDataContainer = (PluginDataContainer)this.part.getModel();
        this.pluginDataMap = this.handlingDataContainer.getPluginDatas().containsKey("ErrorHandlingProcessData") ? new HashMap<String, String>(this.handlingDataContainer.getPluginData("ErrorHandlingProcessData").getPluginData()) : new HashMap<String, String>();
        if (this.part instanceof TemplateEditPart) {
            this.template = ((TemplateEditPart)this.part).getTemplate();
            this.instance = ((TemplateEditPart)this.part).getModel() instanceof Instance ? (Instance)((TemplateEditPart)this.part).getModel() : null;
        } else if (this.part instanceof DefaultNodeEditPart) {
            this.template = ((DefaultNodeEditPart)this.part).getTemplate();
            this.instance = ((DefaultNodeEditPart)this.part).getInstance();
        } else {
            this.template = null;
            this.instance = null;
        }
        this.data = (ErrorHandlingProcessData)ModelViewer.createView(this.pluginDataMap, ErrorHandlingProcessData.class);
    }

    public void refresh() {
        if (this.part instanceof DefaultNodeEditPart && !NodeBasicsSection.elementStillExists((DefaultNodeEditPart)this.part)) {
            return;
        }
        if (!this.isValidEditPart(this.part)) {
            this.form.setText("Error handling not available for this element.");
            this.setVisible(false);
        } else {
            this.form.setText("Error handling");
            this.setVisible(true);
            if (this.data.getTemplateID() != null) {
                this.txtErrorHandlingProcess.setText(this.getTemplateString(this.data.getTemplateID()));
            } else {
                this.txtErrorHandlingProcess.setText(NOT_SET);
            }
        }
    }

    private void setVisible(boolean visible) {
        this.txtErrorHandlingProcess.setVisible(visible);
        this.btnSelectErrorHandlingProcess.setVisible(visible);
        this.label.setVisible(visible);
    }

    private boolean isValidEditPart(EditPart part) {
        DefaultNodeEditPart nodePart = null;
        if (part instanceof DefaultNodeEditPart) {
            nodePart = (DefaultNodeEditPart)part;
        }
        return part != null && !(part instanceof DataElementEditPart) && (part instanceof DefaultNodeEditPart && nodePart != null && nodePart.getTemplate().getStartNode().getID() != ((Node)nodePart.getModel()).getID() && nodePart.getTemplate().getEndNode().getID() != ((Node)nodePart.getModel()).getID() && !ProcessModelTools.isNullNode((ProcessConstants.NodeType)nodePart.getTemplate().getNodeType(((Node)nodePart.getModel()).getID())) || part instanceof TemplateEditPart);
    }

    String getTemplateString(UUID templateID) {
        if (templateID == null) {
            return NOT_SET;
        }
        ADEPT2ClientService service = Activator.getService();
        TemplateManager tm = service.getProcessManager().getTemplateManager();
        TemplateReference reference = tm.getTemplateReference(service.getSessionToken(), templateID);
        return this.getTemplateString(reference);
    }

    String getTemplateString(TemplateReference reference) {
        return reference.getName();
    }
}

