/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.plugindata.MultiLevelEscalationData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbsoluteTimeWidget;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.RelativeTimeWidget;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.EscalationTools;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EscalationLevelDialogue
extends Dialog {
    Map<String, String> invertedEscalationActions = new HashMap<String, String>();
    String[] comboBoxValues = new String[0];
    FormToolkit toolkit;
    Shell shell;
    MultiLevelEscalationData.LevelData newLevelData = null;
    Button relativeButton;
    RelativeTimeWidget relativeTimeWidget;
    Button absoluteButton;
    AbsoluteTimeWidget absoluteTimeWidget;
    private Combo actionCombo;
    private final Template template;
    Button okButton;
    private final Node node;
    DataElement referencedDataElement;
    String parameterReferenceName;

    public EscalationLevelDialogue(Shell parent, Map<String, String> escalationActions, FormToolkit toolkit, Template template, Node node) {
        super(parent);
        this.template = template;
        this.node = node;
        int i = 0;
        this.comboBoxValues = new String[escalationActions.keySet().size()];
        for (Map.Entry<String, String> entry : escalationActions.entrySet()) {
            String humanReadable = entry.getValue();
            this.invertedEscalationActions.put(humanReadable, entry.getKey());
            this.comboBoxValues[i] = humanReadable;
            ++i;
        }
        this.toolkit = toolkit;
    }

    public MultiLevelEscalationData.LevelData open() {
        this.createControls();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.newLevelData;
    }

    private void createControls() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Add a new Escalation Level.");
        this.shell.setLayout((Layout)new GridLayout());
        Composite composite = this.toolkit.createComposite((Composite)this.shell);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createThresholdGroupControls(composite);
        this.createEscalationActionGroupControls(composite);
        this.okButton = this.toolkit.createButton(composite, "OK", 8);
        layoutData = new GridData(131072, 128, true, false);
        layoutData.horizontalSpan = 2;
        this.okButton.setLayoutData((Object)layoutData);
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EscalationLevelDialogue.this.createLevelDataObject();
                EscalationLevelDialogue.this.shell.dispose();
            }
        });
        Button cancelButton = this.toolkit.createButton(composite, "Cancel", 8);
        layoutData = new GridData(16384, 128, false, false);
        cancelButton.setLayoutData((Object)layoutData);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EscalationLevelDialogue.this.shell.dispose();
            }
        });
        this.shell.pack();
    }

    protected void createLevelDataObject() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.newLevelData = (MultiLevelEscalationData.LevelData)ModelViewer.createView(attributes, MultiLevelEscalationData.LevelData.class);
        if (this.relativeButton.getSelection()) {
            int seconds = this.relativeTimeWidget.getSeconds();
            int minutes = this.relativeTimeWidget.getMinutes();
            int hours = this.relativeTimeWidget.getHours();
            int days = this.relativeTimeWidget.getDays();
            int weeks = this.relativeTimeWidget.getWeeks();
            long value = -((long)seconds * 1000L + (long)minutes * 1000L * 60L + (long)hours * 1000L * 60L * 60L + (long)days * 1000L * 60L * 60L * 24L + (long)weeks * 1000L * 60L * 60L * 24L * 7L);
            String referenceParamName = null;
            switch (this.relativeTimeWidget.getTypeSelection()) {
                case 0: {
                    break;
                }
                case 1: {
                    referenceParamName = SystemDataProducer.INSTANCE_CREATION_DATE.getParameterProperties().getName();
                    break;
                }
                case 2: {
                    int connector = this.template.getConnector(this.node.getID(), this.getReferencedDataElement().getID(), ActivityConstants.AccessType.SYSTEM_READ);
                    referenceParamName = connector == Integer.MIN_VALUE ? this.getReferencedDataElement().getName() : this.node.getParameterName(connector);
                }
            }
            if (referenceParamName != null) {
                attributes.put("ThresholdReference", "%d:" + referenceParamName + "%");
                this.parameterReferenceName = referenceParamName;
            }
            this.newLevelData.setThreshold(value);
        } else if (this.absoluteTimeWidget.getTypeSelection() == 0) {
            this.newLevelData.setThreshold(this.absoluteTimeWidget.getAbsoluteTime());
        } else {
            int connector = this.template.getConnector(this.node.getID(), this.getReferencedDataElement().getID(), ActivityConstants.AccessType.SYSTEM_READ);
            String referenceParamName = connector == Integer.MIN_VALUE ? this.getReferencedDataElement().getName() : this.node.getParameterName(connector);
            attributes.put("Threshold", "%d:" + referenceParamName + "%");
            this.parameterReferenceName = referenceParamName;
        }
        String humanString = this.comboBoxValues[this.actionCombo.getSelectionIndex()];
        String pluginID = this.invertedEscalationActions.get(humanString);
        PluginData plugin = EscalationTools.createSimpleEscalationPluginData(pluginID);
        this.newLevelData.setEscalationPluginData(plugin);
    }

    void enableRelativeControls(boolean enable) {
        this.relativeTimeWidget.enableControls(enable);
    }

    void enableAbsoluteControls(boolean enable) {
        this.absoluteTimeWidget.enableControls(enable);
    }

    private void createThresholdGroupControls(Composite parent) {
        Group dueGroup = new Group(parent, parent.getStyle());
        this.toolkit.adapt((Composite)dueGroup);
        dueGroup.setText("Escalation after Activation in/at ...");
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 3;
        dueGroup.setLayoutData((Object)layoutData);
        dueGroup.setLayout((Layout)new GridLayout(2, false));
        this.relativeButton = this.toolkit.createButton((Composite)dueGroup, "relative to", 16);
        SelectionAdapter defaultSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EscalationLevelDialogue.this.absoluteButton.getSelection()) {
                    EscalationLevelDialogue.this.referencedDataElement = EscalationLevelDialogue.this.absoluteTimeWidget.getReferencedDataElement();
                } else if (EscalationLevelDialogue.this.relativeButton.getSelection()) {
                    EscalationLevelDialogue.this.referencedDataElement = EscalationLevelDialogue.this.relativeTimeWidget.getReferencedDataElement();
                }
            }
        };
        this.relativeTimeWidget = new RelativeTimeWidget((Composite)dueGroup, 0, this.toolkit, (SelectionListener)defaultSelectionListener, this.template, true);
        this.toolkit.adapt((Composite)this.relativeTimeWidget);
        this.absoluteButton = this.toolkit.createButton((Composite)dueGroup, "absolute date ", 16);
        this.absoluteTimeWidget = new AbsoluteTimeWidget((Composite)dueGroup, 0, this.toolkit, (SelectionListener)defaultSelectionListener, this.template);
        this.toolkit.adapt((Composite)this.absoluteTimeWidget);
        this.relativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    EscalationLevelDialogue.this.enableRelativeControls(true);
                    EscalationLevelDialogue.this.referencedDataElement = EscalationLevelDialogue.this.relativeTimeWidget.getReferencedDataElement();
                    EscalationLevelDialogue.this.okButton.setEnabled(true);
                } else {
                    EscalationLevelDialogue.this.enableRelativeControls(false);
                }
            }
        });
        this.absoluteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    EscalationLevelDialogue.this.enableAbsoluteControls(true);
                    EscalationLevelDialogue.this.referencedDataElement = EscalationLevelDialogue.this.absoluteTimeWidget.getReferencedDataElement();
                    EscalationLevelDialogue.this.okButton.setEnabled(true);
                } else {
                    EscalationLevelDialogue.this.enableAbsoluteControls(false);
                }
            }
        });
    }

    private void createEscalationActionGroupControls(Composite parent) {
        Group actionGroup = new Group(parent, parent.getStyle());
        this.toolkit.adapt((Composite)actionGroup);
        actionGroup.setText("Escalation Action");
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 3;
        actionGroup.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        actionGroup.setLayout((Layout)gridLayout);
        this.actionCombo = new Combo((Composite)actionGroup, 0x800808);
        this.toolkit.adapt((Control)this.actionCombo, true, false);
        GridData gridData = new GridData(4, 128, true, false);
        this.actionCombo.setLayoutData((Object)gridData);
        this.actionCombo.setItems(this.comboBoxValues);
        if (this.comboBoxValues.length != 0) {
            this.actionCombo.select(0);
        }
    }

    private void setAbsoluteDate(long dueDate) {
        this.absoluteTimeWidget.setAbsoluteTime(dueDate);
    }

    public DataElement getReferencedDataElement() {
        return this.referencedDataElement;
    }

    public String getParameterReferenceName() {
        return this.parameterReferenceName;
    }
}

