/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.base.service.ADEPT2ServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.NodeDependencyProvider;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.dialogues.SelectIdentifierDialogue;
import de.aristaflow.adept2.ui.i18n.TranslateAction;
import de.aristaflow.adept2.ui.i18n.TranslateActionCallback;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.DataElementPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.IdentifierLabelProvider;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.NodePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.SystemDataConsumerDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import java.util.Collection;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class NodeBasicsSection
extends AbstractPropertySection {
    private static final int BASIC_LABEL_WIDTH = 125;
    Text name;
    Text description;
    Text staffAssignmentRule;
    private CLabel staffAssignmentLabel;
    private Button staffAssignmentButton;
    CCombo dataTypeCombo;
    private Text dataTypeText;
    private CLabel dataTypeLabel;
    private Text userdefinedText;
    private CLabel userdefinedLabel;
    Text identifierText;
    private CLabel identifierLabel;
    Button identifierButton;
    CCombo publicCombo;
    private Text publicText;
    private CLabel publicLabel;
    boolean modified = false;
    private Form form;
    DefaultNodeEditPart part;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            NodeBasicsSection.this.modified = true;
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 && NodeBasicsSection.this.modified) {
                Text textField = (Text)e.getSource();
                NodeBasicsSection.this.storeValueOfTextField(textField);
                NodeBasicsSection.this.modified = false;
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (NodeBasicsSection.this.modified) {
                Text textField = (Text)e.getSource();
                NodeBasicsSection.this.storeValueOfTextField(textField);
                NodeBasicsSection.this.modified = false;
            }
        }
    };
    private Button descriptionButton;
    private Button nameButton;
    private IAction translateAction;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Basics");
        this.getWidgetFactory().decorateFormHeading(this.form);
        this.translateAction = new TranslateAction(this.form.getShell(), (ModelViewerProvider)Activator.getService(), new TranslateActionCallback(){

            public ChangeableTemplate getTemplate() {
                return (ChangeableTemplate)NodeBasicsSection.this.part.getTemplate();
            }

            public Class<?> getLocalisedProcessModelClass() {
                return Node.class;
            }

            public PluginDataContainer getPluginDataContainer() {
                return (PluginDataContainer)NodeBasicsSection.this.part.getModel();
            }

            public Collection<PluginData> getPluginData() {
                return ((PluginDataContainer)NodeBasicsSection.this.part.getModel()).getPluginDatas().values();
            }
        }, Activator.getService().getUpdateManager());
        this.form.getToolBarManager().add(this.translateAction);
        this.form.getToolBarManager().update(false);
        this.form.getBody().setLayout((Layout)new FillLayout());
        Composite composite = this.getWidgetFactory().createFlatFormComposite(this.form.getBody());
        this.createNameControls(composite);
        this.createDescriptionControls(composite);
        this.createStaffAssignmentControls(composite);
        this.createDataTypeControls(composite);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof DefaultNodeEditPart));
        this.part = (DefaultNodeEditPart)input;
    }

    public static boolean elementStillExists(DefaultNodeEditPart part) {
        DataElement model;
        Instance instance = part.getInstance();
        Template template = instance != null ? instance.getTemplate() : part.getTemplate();
        return !(part instanceof DataElementEditPart ? template.getDataElement((model = (DataElement)((DataElementEditPart)part).getModel()).getID()) == null : template.getNode((model = (Node)part.getModel()).getID()) == null);
    }

    public void refresh() {
        String descID;
        String nameID;
        if (!NodeBasicsSection.elementStillExists(this.part)) {
            return;
        }
        String title = this.part instanceof DataElementEditPart ? "Data Element Basics" : "Node Basics";
        this.form.setText(title);
        this.name.removeModifyListener(this.listener);
        this.name.removeFocusListener(this.focusListener);
        this.name.removeKeyListener(this.keyListener);
        this.description.removeModifyListener(this.listener);
        this.description.removeFocusListener(this.focusListener);
        this.description.removeKeyListener(this.keyListener);
        AbstractPropertySource properties = (AbstractPropertySource)this.part.getAdapter(IPropertySource.class);
        this.translateAction.setEnabled(properties.arePropertiesChangeable(NodePropertySource.PROPERTY_USER_ATTRIBUTES));
        if (this.part instanceof DataElementEditPart) {
            nameID = DataElementPropertySource.PROPERTY_NAME;
            descID = DataElementPropertySource.PROPERTY_DESCRIPTION;
        } else {
            nameID = NodePropertySource.PROPERTY_NAME;
            descID = NodePropertySource.PROPERTY_DESCRIPTION;
        }
        this.name.setText((String)properties.getPropertyValue(nameID));
        this.name.setData((Object)nameID);
        this.name.addFocusListener(this.focusListener);
        this.name.addModifyListener(this.listener);
        this.name.addKeyListener(this.keyListener);
        this.name.setEditable(properties.arePropertiesChangeable(nameID));
        this.nameButton.setEnabled(properties.arePropertiesChangeable(nameID));
        this.description.setText((String)properties.getPropertyValue(descID));
        this.description.setData((Object)descID);
        this.description.addFocusListener(this.focusListener);
        this.description.addModifyListener(this.listener);
        this.description.setEditable(properties.arePropertiesChangeable(descID));
        this.descriptionButton.setEnabled(properties.arePropertiesChangeable(descID));
        if (this.part instanceof DataElementEditPart) {
            this.makeSARVisible(false);
            this.makeDataTypeVisible(true);
            String userdefinedID = DataElementPropertySource.PROPERTY_USER_DEFINED_TYPE;
            String userdefinedType = (String)properties.getPropertyValue(userdefinedID);
            this.userdefinedText.setText(userdefinedType == null ? "" : userdefinedType);
            this.userdefinedText.setData((Object)userdefinedID);
            this.userdefinedText.addFocusListener(this.focusListener);
            this.userdefinedText.addModifyListener(this.listener);
            this.userdefinedText.addKeyListener(this.keyListener);
            UUID identifierID = ((DataElement)this.part.getModel()).getIdentifierID();
            this.identifierText.setText(new IdentifierLabelProvider().getText(identifierID));
            this.identifierText.setData((Object)DataElementPropertySource.PROPERTY_IDENTIFIER);
            Object publicValue = properties.getPropertyValue(DataElementPropertySource.PROPERTY_PUBLIC);
            if (publicValue instanceof Integer) {
                this.publicText.setVisible(false);
                this.publicCombo.setVisible(true);
                this.publicCombo.select(((Integer)properties.getPropertyValue(DataElementPropertySource.PROPERTY_PUBLIC)).intValue());
            } else {
                this.publicCombo.setVisible(false);
                this.publicText.setVisible(true);
                this.publicText.setText(((Boolean)properties.getPropertyValue(DataElementPropertySource.PROPERTY_PUBLIC)).toString());
            }
            Object dataType = properties.getPropertyValue(DataElementPropertySource.PROPERTY_TYPE);
            if (dataType instanceof Integer) {
                this.dataTypeText.setVisible(false);
                this.dataTypeCombo.setVisible(true);
                this.dataTypeCombo.select(((Integer)dataType).intValue());
                this.userdefinedText.setEditable(((Integer)dataType).intValue() == ProcessConstants.AdeptDataType.USERDEFINED.ordinal());
                this.identifierButton.setEnabled(true);
            } else {
                this.dataTypeCombo.setVisible(false);
                this.dataTypeText.setVisible(true);
                this.dataTypeText.setText(((ProcessConstants.AdeptDataType)properties.getPropertyValue(DataElementPropertySource.PROPERTY_TYPE)).toString());
                this.dataTypeCombo.setData((Object)DataElementPropertySource.PROPERTY_TYPE);
                this.userdefinedText.setEditable(false);
                this.identifierButton.setEnabled(false);
            }
        } else {
            this.makeDataTypeVisible(false);
            this.makeSARVisible(true);
            Object staffAssignment = properties.getPropertyValue(NodePropertySource.PROPERTY_STAFF_ASSIGNMENT_RULE);
            if (staffAssignment instanceof Node) {
                this.staffAssignmentButton.setEnabled(true);
                this.staffAssignmentRule.setText(((Node)staffAssignment).getStaffAssignmentRule());
            } else {
                this.staffAssignmentButton.setEnabled(false);
                this.staffAssignmentRule.setText((String)staffAssignment);
            }
            this.staffAssignmentRule.setData((Object)NodePropertySource.PROPERTY_STAFF_ASSIGNMENT_RULE);
        }
    }

    private void makeSARVisible(boolean visible) {
        this.staffAssignmentButton.setVisible(visible);
        this.staffAssignmentLabel.setVisible(visible);
        this.staffAssignmentRule.setVisible(visible);
        this.nameButton.setVisible(visible);
        this.descriptionButton.setVisible(visible);
        this.staffAssignmentRule.getParent().redraw();
    }

    private void makeDataTypeVisible(boolean visible) {
        this.dataTypeLabel.setVisible(visible);
        this.dataTypeCombo.setVisible(visible);
        this.dataTypeText.setVisible(false);
        this.userdefinedLabel.setVisible(visible);
        this.userdefinedText.setVisible(visible);
        this.identifierLabel.setVisible(visible);
        this.identifierText.setVisible(visible);
        this.identifierButton.setVisible(visible);
        this.publicLabel.setVisible(visible);
        this.publicCombo.setVisible(visible);
        this.publicText.setVisible(visible);
        this.dataTypeCombo.getParent().redraw();
    }

    void storeValueOfTextField(Text textField) {
        String propertyID = (String)textField.getData();
        String value = textField.getText();
        AbstractPropertySource properties = (AbstractPropertySource)this.part.getAdapter(IPropertySource.class);
        properties.setPropertyValue(propertyID, value);
    }

    private void createNameControls(Composite composite) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, "Name:");
        this.name = this.getWidgetFactory().createText(composite, "");
        this.nameButton = this.getWidgetFactory().createButton(composite, "Edit...", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.name, -5);
        data.top = new FormAttachment((Control)this.name, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment((Control)this.nameButton, -5);
        data.top = new FormAttachment(0, 14);
        data.width = 200;
        this.name.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.name, 0, 0x1000000);
        data.height = buttonHeight;
        this.nameButton.setLayoutData((Object)data);
        this.name.addModifyListener(this.listener);
        this.name.addFocusListener(this.focusListener);
        this.name.addKeyListener(this.keyListener);
        this.nameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Template template;
                SystemDataConsumerDialogue dialogue = new SystemDataConsumerDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialogue.setTitleAndMessage("Node Name", "Node Name", null);
                NodePropertySource properties = (NodePropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                String oldName = (String)properties.getPropertyValue(NodePropertySource.PROPERTY_NAME);
                Node node = (Node)NodeBasicsSection.this.part.getModel();
                if (node != null && dialogue.open(oldName, false, (DependencyProvider)new NodeDependencyProvider(template = NodeBasicsSection.this.part.getTemplate(), node.getID()))) {
                    properties.setPropertyValue(NodePropertySource.PROPERTY_NAME, dialogue);
                    NodeBasicsSection.this.name.setText(dialogue.getConsumerString());
                }
            }
        });
    }

    private void createDescriptionControls(Composite composite) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        CLabel descriptionLabel = this.getWidgetFactory().createCLabel(composite, "Description:");
        this.description = this.getWidgetFactory().createText(composite, "", 576);
        this.descriptionButton = this.getWidgetFactory().createButton(composite, "Edit...", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.description, -5);
        data.top = new FormAttachment((Control)this.description, 0, 128);
        descriptionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment((Control)this.descriptionButton, -5);
        data.top = new FormAttachment((Control)this.name, 4);
        data.height = 50;
        data.width = 200;
        this.description.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.description, 0, 128);
        data.height = buttonHeight;
        this.descriptionButton.setLayoutData((Object)data);
        this.description.addModifyListener(this.listener);
        this.description.addFocusListener(this.focusListener);
        this.description.addKeyListener(this.keyListener);
        this.descriptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Template template;
                SystemDataConsumerDialogue dialogue = new SystemDataConsumerDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialogue.setTitleAndMessage("Node Description", "Node Description", null);
                NodePropertySource properties = (NodePropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                String oldDesc = (String)properties.getPropertyValue(NodePropertySource.PROPERTY_DESCRIPTION);
                Node node = (Node)NodeBasicsSection.this.part.getModel();
                if (node != null && dialogue.open(oldDesc, true, (DependencyProvider)new NodeDependencyProvider(template = NodeBasicsSection.this.part.getTemplate(), node.getID()))) {
                    properties.setPropertyValue(NodePropertySource.PROPERTY_DESCRIPTION, dialogue);
                    NodeBasicsSection.this.description.setText(dialogue.getConsumerString());
                }
            }
        });
    }

    private void createStaffAssignmentControls(Composite composite) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        this.staffAssignmentLabel = this.getWidgetFactory().createCLabel(composite, "Staff Assignment:");
        this.staffAssignmentRule = this.getWidgetFactory().createText(composite, "");
        this.staffAssignmentRule.setEditable(false);
        this.staffAssignmentButton = this.getWidgetFactory().createButton(composite, "Edit...", 8);
        this.staffAssignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
                if (providers.length == 0) {
                    throw new RuntimeException("There are no registered Staff Assignment Rule Dialogue providers!");
                }
                StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getService().getOrgModelManager());
                NodePropertySource properties = (NodePropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                Object staffAssignment = properties.getPropertyValue(NodePropertySource.PROPERTY_STAFF_ASSIGNMENT_RULE);
                if (!$assertionsDisabled && !(staffAssignment instanceof Node)) {
                    throw new AssertionError();
                }
                Node node = (Node)staffAssignment;
                if (node != null) {
                    Template template = NodeBasicsSection.this.part.getTemplate();
                    dialogue.open(node.getStaffAssignmentRule(), (DependencyProvider)new NodeDependencyProvider(template, node.getID()));
                    properties.setPropertyValue(NodePropertySource.PROPERTY_STAFF_ASSIGNMENT_RULE, dialogue);
                    NodeBasicsSection.this.staffAssignmentRule.setText(template.getNode(node.getID()).getStaffAssignmentRule());
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.staffAssignmentRule, -5);
        data.top = new FormAttachment((Control)this.staffAssignmentRule, 0, 0x1000000);
        this.staffAssignmentLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment((Control)this.staffAssignmentButton, -5);
        data.top = new FormAttachment((Control)this.description, 4);
        data.width = 200;
        this.staffAssignmentRule.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.staffAssignmentRule, 0, 0x1000000);
        data.height = buttonHeight;
        this.staffAssignmentButton.setLayoutData((Object)data);
    }

    private void createDataTypeControls(Composite composite) {
        this.dataTypeLabel = this.getWidgetFactory().createCLabel(composite, "Data Type:");
        this.dataTypeCombo = this.getWidgetFactory().createCCombo(composite, 8);
        ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
        int n = adeptDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.AdeptDataType dataElementType = adeptDataTypeArray[n2];
            this.dataTypeCombo.add(dataElementType.toString());
            ++n2;
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.description, 4);
        this.dataTypeCombo.setLayoutData((Object)data);
        this.dataTypeCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DataElementPropertySource properties = (DataElementPropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                properties.setPropertyValue(DataElementPropertySource.PROPERTY_TYPE, NodeBasicsSection.this.dataTypeCombo.getSelectionIndex());
                if (NodeBasicsSection.this.dataTypeCombo.getSelectionIndex() == ProcessConstants.AdeptDataType.USERDEFINED.ordinal()) {
                    if (NodeBasicsSection.this.userdefinedText.getText().equals("")) {
                        NodeBasicsSection.this.userdefinedText.setEditable(true);
                    }
                } else {
                    properties.setPropertyValue(DataElementPropertySource.PROPERTY_USER_DEFINED_TYPE, "");
                    NodeBasicsSection.this.userdefinedText.setText("");
                    NodeBasicsSection.this.userdefinedText.setEditable(false);
                }
            }
        });
        this.dataTypeText = this.getWidgetFactory().createText(composite, "");
        this.dataTypeText.setEditable(false);
        this.dataTypeText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.dataTypeCombo, -5);
        data.top = new FormAttachment((Control)this.dataTypeCombo, 0, 0x1000000);
        this.dataTypeLabel.setLayoutData((Object)data);
        this.userdefinedText = this.getWidgetFactory().createText(composite, "");
        this.userdefinedText.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.dataTypeCombo, 4);
        this.userdefinedText.setLayoutData((Object)data);
        this.userdefinedLabel = this.getWidgetFactory().createCLabel(composite, "User Defined Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.userdefinedText, -5);
        data.top = new FormAttachment((Control)this.userdefinedText, 0, 0x1000000);
        this.userdefinedLabel.setLayoutData((Object)data);
        Composite identifierComposite = this.getWidgetFactory().createComposite(composite);
        data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.userdefinedText, 4);
        identifierComposite.setLayoutData((Object)data);
        GridLayout identifierLayout = new GridLayout(2, false);
        identifierLayout.marginWidth = 1;
        identifierLayout.marginHeight = 1;
        identifierComposite.setLayout((Layout)identifierLayout);
        this.identifierText = this.getWidgetFactory().createText(identifierComposite, "");
        this.identifierText.setEditable(false);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.identifierText.setLayoutData((Object)gridData);
        this.identifierButton = this.getWidgetFactory().createButton(identifierComposite, "Select", 8);
        this.identifierButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ADEPT2ClientService service = Activator.getService();
                SessionToken session = service.getSessionToken();
                Shell parent = NodeBasicsSection.this.identifierButton.getShell();
                String pluginID = Activator.getPluginID();
                DataElement dataElement = (DataElement)((DataElementEditPart)NodeBasicsSection.this.part).getModel();
                try {
                    Collection identifiers = service.getActivityRepository().getIdentifierManager().getLatestIdentifiers(session, false);
                    UUID identifierID = dataElement.getIdentifierID();
                    dataElement.getName();
                    SelectIdentifierDialogue dialogue = new SelectIdentifierDialogue(session, parent, pluginID, identifiers, service.getFilterFactory(), identifierID, true, null);
                    if (dialogue.open() == 0) {
                        Identifier newIdentifier = dialogue.getIdentifier();
                        if (newIdentifier == null) {
                            DataElementPropertySource properties = (DataElementPropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                            properties.setPropertyValue(DataElementPropertySource.PROPERTY_IDENTIFIER, ProcessConstants.IDENTIFIER_NOT_SET);
                            NodeBasicsSection.this.identifierText.setText("<not set>");
                        } else if (!newIdentifier.getID().equals(identifierID)) {
                            DataElementPropertySource properties = (DataElementPropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                            properties.setPropertyValue(DataElementPropertySource.PROPERTY_IDENTIFIER, newIdentifier.getID());
                            NodeBasicsSection.this.identifierText.setText(newIdentifier.getName());
                        }
                    }
                }
                catch (ADEPT2ServiceException ex) {
                    String msg = "Could not create identifier selection dialogue. A problem occurred while getting the available identifiers from the activity repository.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    return;
                }
            }
        });
        gridData = new GridData(4, 0x1000000, false, false);
        this.identifierButton.setLayoutData((Object)gridData);
        this.identifierLabel = this.getWidgetFactory().createCLabel(composite, "Identifier:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)identifierComposite, -5);
        data.top = new FormAttachment((Control)identifierComposite, 0, 0x1000000);
        this.identifierLabel.setLayoutData((Object)data);
        this.publicCombo = this.getWidgetFactory().createCCombo(composite, 8);
        this.publicCombo.add("true");
        this.publicCombo.add("false");
        data = new FormData();
        data.left = new FormAttachment(0, 125);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)identifierComposite, 4);
        this.publicCombo.setLayoutData((Object)data);
        this.publicCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DataElementPropertySource properties = (DataElementPropertySource)NodeBasicsSection.this.part.getAdapter(IPropertySource.class);
                properties.setPropertyValue(DataElementPropertySource.PROPERTY_PUBLIC, NodeBasicsSection.this.publicCombo.getSelectionIndex());
            }
        });
        this.publicText = this.getWidgetFactory().createText(composite, "");
        this.publicText.setEditable(false);
        this.publicText.setLayoutData((Object)data);
        this.publicLabel = this.getWidgetFactory().createCLabel(composite, "Is Public:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.publicCombo, -5);
        data.top = new FormAttachment((Control)this.publicCombo, 0, 0x1000000);
        this.publicLabel.setLayoutData((Object)data);
    }
}

