/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.scheduling.DataElementSelectionMessageDialogue;
import java.util.LinkedList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RelativeTimeWidget
extends Composite {
    static final String[] RELATIVE_TIME_OPTION_ITEMS = new String[]{"Activation", "Instance Start", "Value from Data Element..."};
    private static final String RELATIVE_TIME_COMBO_DATA_ELEMENT = "RelativeTimeDataElement";
    private final Spinner weekSpinner;
    private final Spinner daySpinner;
    private final Spinner hourSpinner;
    private final Spinner minuteSpinner;
    private final Spinner secondSpinner;
    final Combo typeCombo;
    Template template;

    public RelativeTimeWidget(Composite parent, int style, FormToolkit toolkit, SelectionListener defaultSelectionListener, Template template, boolean showSeconds) {
        super(parent, style);
        this.template = template;
        int columns = showSeconds ? 11 : 9;
        this.setLayout((Layout)new GridLayout(columns, false));
        this.typeCombo = new Combo((Composite)this, 8);
        this.typeCombo.setItems(RELATIVE_TIME_OPTION_ITEMS);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = RelativeTimeWidget.this.typeCombo.getSelectionIndex();
                if (selectionIndex == 1) {
                    DataElement instanceCreationDE = null;
                    for (DataElement dataElement : RelativeTimeWidget.this.template.getDataElements()) {
                        if (!dataElement.getIdentifierID().equals(SystemDataProducer.INSTANCE_CREATION_DATE.getParameterProperties().getIdentifierID())) continue;
                        instanceCreationDE = dataElement;
                        break;
                    }
                    if (instanceCreationDE != null) {
                        RelativeTimeWidget.this.typeCombo.setData(RelativeTimeWidget.RELATIVE_TIME_COMBO_DATA_ELEMENT, instanceCreationDE);
                    }
                }
                if (selectionIndex >= 2) {
                    LinkedList<DataElement> dataElements = new LinkedList<DataElement>();
                    for (DataElement dataElement : RelativeTimeWidget.this.template.getDataElements()) {
                        if (dataElement.getDataType() != ProcessConstants.AdeptDataType.DATE) continue;
                        dataElements.add(dataElement);
                    }
                    int selectedIndex = 0;
                    DataElementSelectionMessageDialogue dialogue = new DataElementSelectionMessageDialogue(RelativeTimeWidget.this.typeCombo.getShell(), dataElements, selectedIndex);
                    int res = dialogue.open();
                    if (res == 0) {
                        DataElement dataElement = (DataElement)dataElements.get(dialogue.getSelectedIndex());
                        RelativeTimeWidget.this.typeCombo.setData(RelativeTimeWidget.RELATIVE_TIME_COMBO_DATA_ELEMENT, (Object)dataElement);
                        RelativeTimeWidget.this.typeCombo.setItem(selectionIndex, "Value from Data Element: " + dataElement.getName());
                        RelativeTimeWidget.this.typeCombo.select(selectionIndex);
                    } else if (RelativeTimeWidget.this.typeCombo.getData(RelativeTimeWidget.RELATIVE_TIME_COMBO_DATA_ELEMENT) == null) {
                        RelativeTimeWidget.this.typeCombo.setItem(selectionIndex, "Value from Data Element...");
                        RelativeTimeWidget.this.typeCombo.select(0);
                    }
                }
            }
        });
        this.typeCombo.addSelectionListener(defaultSelectionListener);
        this.weekSpinner = new Spinner((Composite)this, 2048);
        this.weekSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.weekSpinner);
        this.weekSpinner.setMaximum(208);
        Label label = toolkit.createLabel((Composite)this, "weeks");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.weekSpinner.addSelectionListener(defaultSelectionListener);
        this.daySpinner = new Spinner((Composite)this, 2048);
        this.daySpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.daySpinner);
        this.daySpinner.setMaximum(6);
        label = toolkit.createLabel((Composite)this, "days");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.daySpinner.addSelectionListener(defaultSelectionListener);
        this.hourSpinner = new Spinner((Composite)this, 2048);
        this.hourSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.hourSpinner);
        this.hourSpinner.setMaximum(23);
        label = toolkit.createLabel((Composite)this, "hours");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.hourSpinner.addSelectionListener(defaultSelectionListener);
        this.minuteSpinner = new Spinner((Composite)this, 2048);
        this.minuteSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.minuteSpinner);
        this.minuteSpinner.setMaximum(59);
        label = toolkit.createLabel((Composite)this, "minutes");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.minuteSpinner.addSelectionListener(defaultSelectionListener);
        if (showSeconds) {
            this.secondSpinner = new Spinner((Composite)this, 2048);
            this.secondSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            toolkit.adapt((Composite)this.secondSpinner);
            this.secondSpinner.setMaximum(59);
            label = toolkit.createLabel((Composite)this, "seconds");
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.secondSpinner.addSelectionListener(defaultSelectionListener);
        } else {
            this.secondSpinner = null;
        }
        this.enableControls(false);
    }

    public DataElement getReferencedDataElement() {
        return (DataElement)this.typeCombo.getData(RELATIVE_TIME_COMBO_DATA_ELEMENT);
    }

    public void setReferencedDataElement(DataElement dataElement, boolean updateItem) {
        this.typeCombo.setData(RELATIVE_TIME_COMBO_DATA_ELEMENT, (Object)dataElement);
        if (updateItem) {
            int selectedIndex = this.typeCombo.getSelectionIndex();
            this.typeCombo.setItem(2, "Value from Data Element: " + dataElement.getName());
            this.typeCombo.select(selectedIndex);
        }
    }

    public void reset(Template template) {
        this.template = template;
        this.typeCombo.deselectAll();
        this.typeCombo.setData(RELATIVE_TIME_COMBO_DATA_ELEMENT, null);
    }

    public void setRelativeTime(long dueDate) {
        int seconds = (int)(dueDate / 1000L % 60L);
        int minutes = (int)(dueDate / 1000L / 60L % 60L);
        int hours = (int)(dueDate / 1000L / 60L / 60L % 24L);
        int days = (int)(dueDate / 1000L / 60L / 60L / 24L % 7L);
        int weeks = (int)(dueDate / 1000L / 60L / 60L / 24L / 7L);
        if (this.secondSpinner != null) {
            this.secondSpinner.setSelection(seconds);
        }
        this.minuteSpinner.setSelection(minutes);
        this.hourSpinner.setSelection(hours);
        this.daySpinner.setSelection(days);
        this.weekSpinner.setSelection(weeks);
    }

    public void enableControls(boolean enable) {
        this.weekSpinner.setEnabled(enable);
        this.daySpinner.setEnabled(enable);
        this.hourSpinner.setEnabled(enable);
        this.minuteSpinner.setEnabled(enable);
        if (this.secondSpinner != null) {
            this.secondSpinner.setEnabled(enable);
        }
        this.typeCombo.setEnabled(enable);
    }

    public int getWeeks() {
        return this.weekSpinner.getSelection();
    }

    public int getDays() {
        return this.daySpinner.getSelection();
    }

    public int getHours() {
        return this.hourSpinner.getSelection();
    }

    public int getMinutes() {
        return this.minuteSpinner.getSelection();
    }

    public int getSeconds() {
        if (this.secondSpinner != null) {
            return this.secondSpinner.getSelection();
        }
        return 0;
    }

    public int getTypeSelection() {
        return this.typeCombo.getSelectionIndex();
    }

    public void setTypeSelection(int index) {
        if (index < 0 || index >= RELATIVE_TIME_OPTION_ITEMS.length) {
            throw new IllegalArgumentException("Index not within time options.");
        }
        this.typeCombo.select(index);
    }
}

