/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.NodePropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.NodeBasicsSection;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RoutingSection
extends AbstractPropertySection {
    private Section delegationSection;
    Text delegationRule;
    private Button delegationButton;
    private Section enquirySection;
    Text enquiryRule;
    private Button enquiryButton;
    private Form form;
    DefaultNodeEditPart part;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Routing");
        this.getWidgetFactory().decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        this.delegationSection = this.getWidgetFactory().createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        this.delegationSection.setLayoutData((Object)td);
        this.delegationSection.setText("Possible delegation recipients");
        this.delegationSection.setDescription("Specify the possible delegation recipients for the activity assigned to this node.");
        Composite delegationClient = this.getWidgetFactory().createComposite((Composite)this.delegationSection);
        delegationClient.setLayout((Layout)new FormLayout());
        this.createDelegationControls(delegationClient);
        this.delegationSection.setClient((Control)delegationClient);
        this.enquirySection = this.getWidgetFactory().createSection(this.form.getBody(), 450);
        td = new TableWrapData(256);
        this.enquirySection.setLayoutData((Object)td);
        this.enquirySection.setText("Possible enquiry recipients");
        this.enquirySection.setDescription("Specify the possible enquiry recipients for the activity assigned to this node.");
        Composite enquiryClient = this.getWidgetFactory().createComposite((Composite)this.enquirySection);
        enquiryClient.setLayout((Layout)new FormLayout());
        this.createEnquiryControls(enquiryClient);
        this.enquirySection.setClient((Control)enquiryClient);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof DefaultNodeEditPart));
        this.part = (DefaultNodeEditPart)input;
    }

    public void refresh() {
        if (!NodeBasicsSection.elementStillExists(this.part)) {
            return;
        }
        if (!this.isValidEditPart(this.part)) {
            this.form.setText("Routing not available for this element.");
            this.setVisible(false);
        } else {
            this.form.setText("Routing");
            this.setVisible(true);
            AbstractPropertySource properties = (AbstractPropertySource)this.part.getAdapter(IPropertySource.class);
            this.delegationRule.setText((String)properties.getPropertyValue(NodePropertySource.PROPERTY_DELEGATION_RECIPIENTS));
            this.delegationButton.setEnabled(((NodePropertySource)this.part.getAdapter(IPropertySource.class)).arePropertiesChangeable(NodePropertySource.PROPERTY_DELEGATION_RECIPIENTS));
            this.delegationRule.setData((Object)NodePropertySource.PROPERTY_DELEGATION_RECIPIENTS);
            this.enquiryRule.setText((String)properties.getPropertyValue(NodePropertySource.PROPERTY_ENQUIRY_RECIPIENTS));
            this.enquiryButton.setEnabled(((NodePropertySource)this.part.getAdapter(IPropertySource.class)).arePropertiesChangeable(NodePropertySource.PROPERTY_ENQUIRY_RECIPIENTS));
            this.enquiryRule.setData((Object)NodePropertySource.PROPERTY_ENQUIRY_RECIPIENTS);
        }
    }

    private void setVisible(boolean visible) {
        this.delegationSection.setVisible(visible);
        this.enquirySection.setVisible(visible);
    }

    private void createDelegationControls(Composite composite) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        this.delegationRule = this.getWidgetFactory().createText(composite, "", 576);
        this.delegationRule.setEditable(false);
        this.delegationButton = this.getWidgetFactory().createButton(composite, "Change...", 8);
        this.delegationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
                if (providers.length == 0) {
                    throw new RuntimeException("There are no registered Staff Assignment Rule Dialogue providers!");
                }
                StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getService().getOrgModelManager());
                NodePropertySource properties = (NodePropertySource)RoutingSection.this.part.getAdapter(IPropertySource.class);
                String delegationRecipients = (String)properties.getPropertyValue(NodePropertySource.PROPERTY_DELEGATION_RECIPIENTS);
                dialogue.open(delegationRecipients);
                properties.setPropertyValue(NodePropertySource.PROPERTY_DELEGATION_RECIPIENTS, dialogue.getStaffAssignmentRule());
                RoutingSection.this.delegationRule.setText((String)properties.getPropertyValue(NodePropertySource.PROPERTY_DELEGATION_RECIPIENTS));
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment((Control)this.delegationButton, -12);
        data.top = new FormAttachment(0, 4);
        data.height = 50;
        data.width = 400;
        this.delegationRule.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.delegationRule, 0, 128);
        data.height = buttonHeight;
        this.delegationButton.setLayoutData((Object)data);
    }

    private void createEnquiryControls(Composite composite) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        this.enquiryRule = this.getWidgetFactory().createText(composite, "", 576);
        this.enquiryRule.setEditable(false);
        this.enquiryButton = this.getWidgetFactory().createButton(composite, "Change...", 8);
        this.enquiryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
                if (providers.length == 0) {
                    throw new RuntimeException("There are no registered Staff Assignment Rule Dialogue providers!");
                }
                StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getService().getOrgModelManager());
                NodePropertySource properties = (NodePropertySource)RoutingSection.this.part.getAdapter(IPropertySource.class);
                String enquiryRecipients = (String)properties.getPropertyValue(NodePropertySource.PROPERTY_ENQUIRY_RECIPIENTS);
                dialogue.open(enquiryRecipients);
                properties.setPropertyValue(NodePropertySource.PROPERTY_ENQUIRY_RECIPIENTS, dialogue.getStaffAssignmentRule());
                RoutingSection.this.enquiryRule.setText((String)properties.getPropertyValue(NodePropertySource.PROPERTY_ENQUIRY_RECIPIENTS));
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment((Control)this.enquiryButton, -12);
        data.top = new FormAttachment(0, 4);
        data.height = 50;
        data.width = 400;
        this.enquiryRule.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.enquiryRule, 0, 128);
        data.height = buttonHeight;
        this.enquiryButton.setLayoutData((Object)data);
    }

    private boolean isValidEditPart(DefaultNodeEditPart nodePart) {
        return nodePart != null && !(nodePart instanceof DataElementEditPart) && nodePart.getTemplate().getStartNode().getID() != ((Node)nodePart.getModel()).getID() && nodePart.getTemplate().getEndNode().getID() != ((Node)nodePart.getModel()).getID() && !ProcessModelTools.isNullNode((ProcessConstants.NodeType)nodePart.getTemplate().getNodeType(((Node)nodePart.getModel()).getID()));
    }
}

