/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AddNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.AddSystemDataFlow;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.RemoveNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.RemoveSystemDataFlow;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.plugindata.EscalationData;
import de.aristaflow.adept2.model.common.plugindata.MultiLevelEscalationData;
import de.aristaflow.adept2.model.common.plugindata.SchedulerData;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.common.viewer.UnresolvedParameterReferenceException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.CommonConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbsoluteTimeWidget;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.EscalationLevelDialogue;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.NodeBasicsSection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.RelativeTimeWidget;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.AbstractEscalationComposite;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.EscalationTools;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.scheduling.DataElementSelectionMessageDialogue;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.time.DateTimeFormat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SchedulingSection
extends AbstractPropertySection {
    public static final String VALUE_FROM_DATA_ELEMENT = "Value from Data Element";
    private static final String PRIORITY_COMBO_DATA_ELEMENT = "PriorityDataElement";
    public static final String ESCALATION_THRESHOLD = "Escalation after Activation in/at ...";
    public static final String ESCALATION_ACTION = "Escalation Action";
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    public Map<String, String> escalationActions = new HashMap<String, String>();
    DefaultNodeEditPart nodePart;
    Template template;
    Instance instance;
    volatile boolean isModified = false;
    boolean isToolTipShown = false;
    TableViewer escalationTableViewer;
    private Form form;
    private Section dueSection;
    private Section escalationSection;
    private Button relativeButton;
    private RelativeTimeWidget relativeTimeWidget;
    private Button absoluteButton;
    private AbsoluteTimeWidget absoluteTimeWidget;
    private Spinner effortDaySpinner;
    private Spinner effortHourSpinner;
    private Spinner effortMinuteSpinner;
    private Spinner toleranceSpinner;
    private Composite escalationAttributesContainer;
    MultiLevelEscalationData.LevelData actualLevelData = null;
    private Map<String, AbstractEscalationComposite> attributeComposites;
    List<MultiLevelEscalationData.LevelData> escalationTableModel = new ArrayList<MultiLevelEscalationData.LevelData>();
    Map<String, DataElement> escalationTableDataElements = new HashMap<String, DataElement>();
    Combo priorityCombo;
    private HashMap<String, String> schedulerDataAttributes;
    private HashMap<String, String> multiEscalationAttributes;
    private String oldPriorityParameterName;
    private String oldDueDateParameterName;
    private String oldDueDateRelativeParameterName;
    private Set<String> oldLevelDataParameterNames;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        this.form = toolkit.createForm(parent);
        this.form.setText("Scheduler");
        toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        this.dueSection = toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        this.dueSection.setLayoutData((Object)td);
        this.dueSection.setText("Due-Date and Effort");
        this.dueSection.setDescription("Specify the date or the relative time after completion of the predecessor activity on which the selected activity should be finished including the estimated effort it will require.");
        Composite dueClient = toolkit.createComposite((Composite)this.dueSection);
        dueClient.setLayout((Layout)new GridLayout(2, false));
        this.createDueGroupControls(dueClient);
        this.createPriorityGroupControls(dueClient);
        this.createEffortGroupControls(dueClient);
        this.dueSection.setClient((Control)dueClient);
        this.escalationSection = toolkit.createSection(this.form.getBody(), 450);
        td = new TableWrapData(256);
        this.escalationSection.setLayoutData((Object)td);
        this.escalationSection.setText("Escalation");
        this.escalationSection.setDescription("Specify escalation levels and activities");
        Composite separator = toolkit.createComposite((Composite)this.escalationSection);
        separator.setLayout((Layout)new GridLayout(2, false));
        this.escalationSection.setClient((Control)separator);
        Composite escalationMain = toolkit.createComposite(separator);
        escalationMain.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 350;
        gridData.minimumWidth = 350;
        escalationMain.setLayoutData((Object)gridData);
        this.initEscalationActions();
        this.createEscalationControls(escalationMain);
        this.escalationAttributesContainer = toolkit.createComposite(separator);
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 200;
        this.escalationAttributesContainer.setLayoutData((Object)gridData);
        this.escalationAttributesContainer.setLayout((Layout)new StackLayout());
        this.createAttributeComposites(this.escalationAttributesContainer);
        Group attributeGroup = toolkit.createGroup(this.escalationAttributesContainer, "Attributes");
        gridData = new GridData(4, 4, false, false);
        attributeGroup.setLayoutData((Object)gridData);
        attributeGroup.setLayout((Layout)new GridLayout(1, false));
        this.registerFocusListeners((Composite)this.form);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof DefaultNodeEditPart));
        if (this.isModified() && this.nodePart != null && this.isValidEditPart(this.nodePart)) {
            this.commitChanges();
        }
        this.nodePart = (DefaultNodeEditPart)input;
        if (this.nodePart.getInstance() != null) {
            this.instance = this.nodePart.getInstance();
            this.template = this.instance.getTemplate();
        } else {
            this.template = this.nodePart.getTemplate();
        }
        if (this.instance == null && !(this.template instanceof ChangeableTemplate) || this.instance != null && !(this.instance instanceof ChangeableInstance)) {
            this.form.setMessage("Read-only mode: Attributes of Template / Instance not changeable!");
            this.form.setEnabled(false);
        }
    }

    public void refresh() {
        if (!NodeBasicsSection.elementStillExists(this.nodePart)) {
            return;
        }
        this.oldDueDateParameterName = null;
        this.oldDueDateRelativeParameterName = null;
        this.oldPriorityParameterName = null;
        this.oldLevelDataParameterNames = new HashSet<String>();
        this.escalationTableModel.clear();
        this.escalationTableDataElements.clear();
        this.escalationTableViewer.setInput(null);
        StackLayout layout = (StackLayout)this.escalationAttributesContainer.getLayout();
        layout.topControl = null;
        this.escalationAttributesContainer.layout();
        this.relativeButton.setSelection(false);
        this.relativeTimeWidget.reset(this.template);
        this.relativeTimeWidget.enableControls(false);
        this.absoluteButton.setSelection(false);
        this.absoluteTimeWidget.reset(this.template);
        this.absoluteTimeWidget.enableControls(false);
        if (!this.isValidEditPart(this.nodePart)) {
            this.form.setText("Scheduler not available for this element.");
            this.dueSection.setVisible(false);
            this.escalationSection.setVisible(false);
        } else {
            String priorityString;
            DataElement dataElement;
            this.form.setText("Scheduler");
            this.dueSection.setVisible(true);
            this.escalationSection.setVisible(true);
            Node node = (Node)this.nodePart.getModel();
            if (node.getPluginData("SchedulerData") != null) {
                this.schedulerDataAttributes = new HashMap(node.getPluginData("SchedulerData").getPluginData());
            } else {
                this.schedulerDataAttributes = new HashMap();
                this.absoluteButton.setSelection(false);
                this.enableAbsoluteControls(false);
                this.relativeButton.setSelection(false);
                this.enableRelativeControls(false);
                this.setRelativeTime(0L);
                this.setAbsoluteDate(System.currentTimeMillis());
                this.setEffortTime(0L);
            }
            SchedulerData schedulerData = (SchedulerData)ModelViewer.createView(this.schedulerDataAttributes, SchedulerData.class);
            long dueDate = 0L;
            String dueDateRefString = this.schedulerDataAttributes.get("DueDateReference");
            String dueDateString = this.schedulerDataAttributes.get("DueDate");
            ParameterRef[] dueDateParam = dueDateString != null ? SystemDataTools.findParameterReferences((String)dueDateString) : new ParameterRef[]{};
            if (dueDateParam.length == 0) {
                dueDate = schedulerData.getDueDate();
            }
            if (dueDateParam.length == 0 && dueDate < 0L) {
                this.setRelativeTime(-dueDate);
                this.relativeButton.setSelection(true);
                this.absoluteButton.setSelection(false);
                this.enableRelativeControls(true);
                this.enableAbsoluteControls(false);
                this.setAbsoluteDate(System.currentTimeMillis());
                if (dueDateRefString != null) {
                    ParameterRef[] parameterRefs = SystemDataTools.findParameterReferences((String)dueDateRefString);
                    if (parameterRefs.length > 0) {
                        String paramName;
                        this.oldDueDateRelativeParameterName = paramName = parameterRefs[0].getName();
                        int paramConnector = node.getConnector(paramName, ActivityConstants.AccessType.SYSTEM_READ);
                        dataElement = this.template.getDataElement(node.getID(), paramConnector);
                        if (paramName.equals(SystemDataProducer.INSTANCE_CREATION_DATE.getParameterProperties().getName())) {
                            this.relativeTimeWidget.setReferencedDataElement(dataElement, false);
                            this.relativeTimeWidget.setTypeSelection(1);
                        } else {
                            this.relativeTimeWidget.setReferencedDataElement(dataElement, true);
                            this.relativeTimeWidget.setTypeSelection(2);
                        }
                    } else {
                        this.relativeTimeWidget.setTypeSelection(0);
                    }
                }
            } else if (dueDateParam.length == 1 || dueDate > 0L) {
                this.setAbsoluteDate(dueDate);
                this.absoluteButton.setSelection(true);
                this.relativeButton.setSelection(false);
                this.enableAbsoluteControls(true);
                this.enableRelativeControls(false);
                if (dueDateParam.length == 1) {
                    String paramName;
                    this.oldDueDateParameterName = paramName = dueDateParam[0].getName();
                    int paramConnector = node.getConnector(paramName, ActivityConstants.AccessType.SYSTEM_READ);
                    DataElement dataElement2 = this.template.getDataElement(node.getID(), paramConnector);
                    this.absoluteTimeWidget.setTypeSelection(1);
                    this.absoluteTimeWidget.setReferencedDataElement(dataElement2);
                    this.absoluteTimeWidget.enableAbsoluteStaticDateWidgets(false);
                } else {
                    this.absoluteTimeWidget.setTypeSelection(0);
                    this.absoluteTimeWidget.enableAbsoluteStaticDateWidgets(true);
                }
            }
            if ((priorityString = this.schedulerDataAttributes.get("Priority")) != null) {
                ParameterRef[] priorityParamRefs = SystemDataTools.findParameterReferences((String)priorityString);
                if (priorityParamRefs.length > 0) {
                    this.oldPriorityParameterName = priorityParamRefs[0].getName();
                    int connector = node.getConnector(this.oldPriorityParameterName, ActivityConstants.AccessType.SYSTEM_READ);
                    dataElement = this.template.getDataElement(node.getID(), connector);
                    this.priorityCombo.setData(PRIORITY_COMBO_DATA_ELEMENT, (Object)dataElement);
                    this.priorityCombo.setItem(WorklistConstants.Priority.values().length, "Value from Data Element: " + dataElement.getName());
                    this.priorityCombo.select(WorklistConstants.Priority.values().length);
                } else {
                    int priority = schedulerData.getPriority();
                    int i = 0;
                    while (i < WorklistConstants.Priority.values().length) {
                        if (priority == WorklistConstants.Priority.values()[i].getPriority()) {
                            this.priorityCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            long effort = schedulerData.getComplexity();
            this.setEffortTime(effort);
            this.multiEscalationAttributes = node.getPluginData("MultiLevelEscalationHandling") != null ? new HashMap(node.getPluginData("MultiLevelEscalationHandling").getPluginData()) : new HashMap();
            MultiLevelEscalationData multiLevelEscData = (MultiLevelEscalationData)ModelViewer.createView(this.multiEscalationAttributes, MultiLevelEscalationData.class);
            if (multiLevelEscData.getLevelData() != null) {
                MultiLevelEscalationData.LevelData[] levelDataArray = multiLevelEscData.getLevelData();
                int n = levelDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MultiLevelEscalationData.LevelData data = levelDataArray[n2];
                    this.escalationTableModel.add(data);
                    DataElement dataElement3 = null;
                    try {
                        data.getThreshold();
                        data.getThresholdReference();
                    }
                    catch (UnresolvedParameterReferenceException e) {
                        String levelDataParameterName = e.getParameterReferences()[0].getName();
                        this.oldLevelDataParameterNames.add(levelDataParameterName);
                        int connector = node.getConnector(levelDataParameterName, ActivityConstants.AccessType.SYSTEM_READ);
                        dataElement3 = this.template.getDataElement(node.getID(), connector);
                        this.escalationTableDataElements.put(levelDataParameterName, dataElement3);
                    }
                    ++n2;
                }
            }
            this.escalationTableViewer.setInput(this.escalationTableModel);
        }
    }

    private void setAbsoluteDate(long dueDate) {
        this.absoluteTimeWidget.setAbsoluteTime(dueDate);
    }

    private void setRelativeTime(long dueDate) {
        this.relativeTimeWidget.setRelativeTime(dueDate);
    }

    private void setEffortTime(long effort) {
        int minutes = (int)(effort / 1000L / 60L % 60L);
        int hours = (int)(effort / 1000L / 60L / 60L % 24L);
        int days = (int)(effort / 1000L / 60L / 60L / 24L % 7L);
        this.effortMinuteSpinner.setSelection(minutes);
        this.effortHourSpinner.setSelection(hours);
        this.effortDaySpinner.setSelection(days);
    }

    private boolean isModified() {
        return this.isModified;
    }

    void setModified() {
        if (!this.isModified) {
            this.isModified = true;
            UpdateManager updateManager = Activator.getService().getUpdateManager();
            if (this.instance != null) {
                updateManager.firePropertyChange((Object)this.instance, (Object)UpdateManager.ProcessProperties.PROCESS);
            } else {
                updateManager.firePropertyChange((Object)this.template, (Object)UpdateManager.ProcessProperties.PROCESS);
            }
            updateManager.sendPropertyChanges();
        }
    }

    private void initEscalationActions() {
        this.escalationActions.clear();
        this.escalationActions = EscalationTools.getEscalationPluginIDs();
    }

    void enableRelativeControls(boolean enable) {
        this.relativeTimeWidget.enableControls(enable);
    }

    void enableAbsoluteControls(boolean enable) {
        this.absoluteTimeWidget.enableControls(enable);
    }

    private void registerFocusListeners(Composite parentComposite) {
        Control[] controlArray = parentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                }
            });
            if (ctrl instanceof Composite) {
                this.registerFocusListeners((Composite)ctrl);
            }
            ++n2;
        }
    }

    private synchronized void commitChanges() {
        String parameterRefString;
        DataElement de;
        boolean usePriorityParameter;
        int priority;
        long dueDate;
        if (!this.isModified()) {
            throw new AssertionError((Object)"Called commit w/o being modified.");
        }
        if (this.actualLevelData != null) {
            this.updateAttributeCompositeValues(this.actualLevelData);
        }
        MultiLevelEscalationData.LevelData[] levelDataArray = new MultiLevelEscalationData.LevelData[this.escalationTableModel.size()];
        levelDataArray = this.escalationTableModel.toArray(levelDataArray);
        long firstEscalationDate = 1L;
        boolean useDueDateParameter = false;
        boolean useDueDateRelativeParameter = false;
        boolean useDueDateRelativeInstanceStartParameter = false;
        if (this.relativeButton.getSelection()) {
            int hours = this.relativeTimeWidget.getHours();
            int minutes = this.relativeTimeWidget.getMinutes();
            int days = this.relativeTimeWidget.getDays();
            int weeks = this.relativeTimeWidget.getWeeks();
            dueDate = -((long)minutes * 1000L * 60L + (long)hours * 1000L * 60L * 60L + (long)days * 1000L * 60L * 60L * 24L + (long)weeks * 1000L * 60L * 60L * 24L * 7L);
            if (this.relativeTimeWidget.getTypeSelection() == 2 && dueDate != 0L) {
                useDueDateRelativeParameter = true;
            } else if (this.relativeTimeWidget.getTypeSelection() == 1 && dueDate != 0L) {
                useDueDateRelativeInstanceStartParameter = true;
            }
        } else if (this.absoluteButton.getSelection()) {
            if (this.absoluteTimeWidget.getTypeSelection() == 0) {
                dueDate = this.absoluteTimeWidget.getAbsoluteTime();
            } else if (this.absoluteTimeWidget.getTypeSelection() == 1) {
                useDueDateParameter = true;
                dueDate = -1L;
            } else {
                dueDate = 0L;
            }
        } else {
            dueDate = 0L;
        }
        int selectionIndex = this.priorityCombo.getSelectionIndex();
        if (selectionIndex == -1) {
            priority = WorklistConstants.Priority.NOT_SET.getPriority();
            usePriorityParameter = false;
        } else if (selectionIndex >= 0 && selectionIndex < WorklistConstants.Priority.values().length) {
            WorklistConstants.Priority[] values = WorklistConstants.Priority.values();
            priority = values[selectionIndex].getPriority();
            usePriorityParameter = false;
        } else {
            usePriorityParameter = true;
            priority = -1;
        }
        Node node = (Node)this.nodePart.getModel();
        int hours = this.effortHourSpinner.getSelection();
        int minutes = this.effortMinuteSpinner.getSelection();
        int days = this.effortDaySpinner.getSelection();
        int tolerance = this.toleranceSpinner.getSelection();
        long effort = (long)minutes * 1000L * 60L + (long)hours * 1000L * 60L * 60L + (long)days * 1000L * 60L * 60L * 24L;
        String paramNameInstanceCreation = SystemDataProducer.INSTANCE_CREATION_DATE.getParameterProperties().getName();
        String priorityParameterName = null;
        String dueDateParameterName = null;
        String dueDateRelativeParameterName = null;
        SchedulerData schedulerData = (SchedulerData)ModelViewer.createView(this.schedulerDataAttributes, SchedulerData.class);
        schedulerData.setComplexity(effort);
        schedulerData.setDueDate(dueDate);
        if (useDueDateRelativeParameter) {
            de = this.relativeTimeWidget.getReferencedDataElement();
            dueDateRelativeParameterName = this.getExistingParameterRefName(node, de.getID());
            if (dueDateRelativeParameterName == null) {
                dueDateRelativeParameterName = de.getName();
            }
            parameterRefString = "%d:" + dueDateRelativeParameterName + "%";
            this.schedulerDataAttributes.put("DueDateReference", parameterRefString);
        } else if (useDueDateRelativeInstanceStartParameter) {
            String parameterRefString2 = "%d:" + paramNameInstanceCreation + "%";
            this.schedulerDataAttributes.put("DueDateReference", parameterRefString2);
        } else {
            schedulerData.setDueDateReference(0L);
        }
        if (useDueDateParameter) {
            de = this.absoluteTimeWidget.getReferencedDataElement();
            dueDateParameterName = this.getExistingParameterRefName(node, de.getID());
            if (dueDateParameterName == null) {
                dueDateParameterName = de.getName();
            }
            parameterRefString = "%d:" + dueDateParameterName + "%";
            this.schedulerDataAttributes.put("DueDate", parameterRefString);
        }
        DataElement priorityDataElement = (DataElement)this.priorityCombo.getData(PRIORITY_COMBO_DATA_ELEMENT);
        if (!usePriorityParameter) {
            schedulerData.setPriority(priority);
        } else {
            priorityParameterName = this.getExistingParameterRefName(node, priorityDataElement.getID());
            if (priorityParameterName == null) {
                priorityParameterName = priorityDataElement.getName();
            }
            parameterRefString = "%i:" + priorityParameterName + "%";
            this.schedulerDataAttributes.put("Priority", parameterRefString);
        }
        schedulerData.setTolerance(tolerance);
        HashMap escalationDataAttributes = new HashMap();
        EscalationData escalationData = (EscalationData)ModelViewer.createView(escalationDataAttributes, EscalationData.class);
        escalationData.setEscalationHandlingProcedureID("MultiLevelEscalationHandling");
        escalationData.setEscalationDate(firstEscalationDate);
        MultiLevelEscalationData multiData = (MultiLevelEscalationData)ModelViewer.createView(this.multiEscalationAttributes, MultiLevelEscalationData.class);
        multiData.setLevelData(levelDataArray);
        boolean priorityParameterExists = node.getSystemParameter(priorityParameterName, ActivityConstants.AccessType.SYSTEM_READ) != null;
        boolean dueDateParameterExists = node.getSystemParameter(dueDateParameterName, ActivityConstants.AccessType.SYSTEM_READ) != null;
        boolean dueDateRelativeParameterExists = node.getSystemParameter(dueDateRelativeParameterName, ActivityConstants.AccessType.SYSTEM_READ) != null;
        boolean dueDateRelativeInstanceStartParameterExists = node.getSystemParameter(paramNameInstanceCreation, ActivityConstants.AccessType.SYSTEM_READ) != null;
        boolean removeOldPriorityParameter = this.oldPriorityParameterName != null && !this.oldPriorityParameterName.equals(priorityParameterName);
        boolean removeOldDueDateParameter = this.oldDueDateParameterName != null && !this.oldDueDateParameterName.equals(dueDateParameterName);
        boolean removeOldDueDateRelative = this.oldDueDateRelativeParameterName != null && !this.oldDueDateRelativeParameterName.equals(paramNameInstanceCreation) && !this.oldDueDateRelativeParameterName.equals(dueDateRelativeParameterName);
        boolean removeOldDueDateRelativeInstanceStartParameter = this.oldDueDateRelativeParameterName != null && this.oldDueDateRelativeParameterName.equals(paramNameInstanceCreation) && !paramNameInstanceCreation.equals(dueDateRelativeParameterName);
        DefaultPluginData schedPluginData = new DefaultPluginData("SchedulerData", this.schedulerDataAttributes);
        DefaultPluginData escalationPluginData = new DefaultPluginData("EscalationData", escalationDataAttributes);
        DefaultPluginData multiPluginData = new DefaultPluginData("MultiLevelEscalationHandling", this.multiEscalationAttributes);
        if (levelDataArray.length == 0) {
            multiPluginData = null;
            escalationPluginData = null;
        }
        UpdateManager updateManager = Activator.getService().getUpdateManager();
        CheckReport checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.template, (String)"localhost"));
        String transactionLabel = String.format("Changing scheduling of Node %s", node.getName());
        if (this.instance == null) {
            StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (UpdateManager)updateManager);
            SessionToken session = Activator.getService().getSessionToken();
            if (UpdatePluginDataContainer.isPossible((Template)this.template, (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"SchedulerData", (String)"SchedulerData", (PluginData)schedPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"SchedulerData", (String)"SchedulerData", (PluginData)schedPluginData, (UpdateManager)updateManager);
            }
            if (UpdatePluginDataContainer.isPossible((Template)this.template, (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationData", (String)"EscalationData", (PluginData)escalationPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationData", (String)"EscalationData", (PluginData)escalationPluginData, (UpdateManager)updateManager);
            }
            if (UpdatePluginDataContainer.isPossible((Template)this.template, (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationHandling", (String)"MultiLevelEscalationHandling", (PluginData)multiPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationHandling", (String)"MultiLevelEscalationHandling", (PluginData)multiPluginData, (UpdateManager)updateManager);
            }
            HashSet<String> parameterRefsToBeRemoved = new HashSet<String>(this.oldLevelDataParameterNames);
            for (String name : parameterRefsToBeRemoved) {
                boolean parameterReferenceExists = AddNodeSystemParameter.parameterReferenceExists((Object)node, (Method[])Node.class.getMethods(), (String)name);
                if (parameterReferenceExists) continue;
                this.removeParameterConnection(session, false, true, node, updateManager, checkReport, name);
            }
            this.removeParameterConnection(session, usePriorityParameter, removeOldPriorityParameter, node, updateManager, checkReport, this.oldPriorityParameterName);
            DataElement dueDateDataElement = this.absoluteTimeWidget.getReferencedDataElement();
            this.removeParameterConnection(session, useDueDateParameter, removeOldDueDateParameter, node, updateManager, checkReport, this.oldDueDateParameterName);
            DataElement dueDateRefDataElement = this.relativeTimeWidget.getReferencedDataElement();
            this.removeParameterConnection(session, useDueDateRelativeParameter, removeOldDueDateRelative, node, updateManager, checkReport, this.oldDueDateRelativeParameterName);
            int i = 0;
            while (i < levelDataArray.length) {
                block52: {
                    try {
                        levelDataArray[i].getThreshold();
                        levelDataArray[i].getThresholdReference();
                    }
                    catch (UnresolvedParameterReferenceException e) {
                        boolean exists;
                        String parameterReferenceName = e.getParameterReferences()[0].getName();
                        DataElement dataElement = this.escalationTableDataElements.get(parameterReferenceName);
                        boolean bl = exists = node.getConnector(parameterReferenceName, ActivityConstants.AccessType.SYSTEM_READ) != Integer.MIN_VALUE;
                        if (dataElement != null) {
                            boolean useParameter = true;
                            this.addParameterConnection(session, useParameter, exists, node, dataElement, updateManager, checkReport, parameterReferenceName, dataElement.getIdentifierID(), dataElement.getDataType());
                        }
                        ProcessModelParameter sysPar = SystemDataProducer.INSTANCE_CREATION_DATE.getParameterProperties();
                        if (!exists) {
                            ProcessModelParameter parameter = Activator.getService().getProcessModelFactory().createProcessModelParameter(sysPar.getName(), sysPar.getDescription(), sysPar.getDataType(), sysPar.getUDTName(), sysPar.getIdentifierID(), sysPar.isOptional(), sysPar.isVirtual(), sysPar.isFailure(), sysPar.getDefaultValue(), sysPar.getConfiguration(), (PluginDataContainer)sysPar, sysPar.getUserAttributes());
                            if (AddNodeSystemParameter.isPossible((Template)this.template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (CheckReport)checkReport)) {
                                AddNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (UpdateManager)updateManager);
                            }
                        }
                        if (!AddSystemDataFlow.isPossible((Template)this.template, (int)this.template.getStartNode().getID(), (SystemDataProducer)SystemDataProducer.INSTANCE_CREATION_DATE, (int)node.getID(), (String)paramNameInstanceCreation, (CheckReport)checkReport)) break block52;
                        AddSystemDataFlow.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)this.template.getStartNode().getID(), (SystemDataProducer)SystemDataProducer.INSTANCE_CREATION_DATE, (int)node.getID(), (String)paramNameInstanceCreation, (UpdateManager)updateManager);
                    }
                }
                ++i;
            }
            this.addParameterConnection(session, usePriorityParameter, priorityParameterExists, node, priorityDataElement, updateManager, checkReport, priorityParameterName, CommonConstants.IDENTIFIER_ID_PRIORITY, ProcessConstants.AdeptDataType.INTEGER);
            this.addParameterConnection(session, useDueDateParameter, dueDateParameterExists, node, dueDateDataElement, updateManager, checkReport, dueDateParameterName, ProcessConstants.UNIVERSAL_IDENTIFIER_ID, ProcessConstants.AdeptDataType.DATE);
            this.addParameterConnection(session, useDueDateRelativeParameter, dueDateRelativeParameterExists, node, dueDateRefDataElement, updateManager, checkReport, dueDateRelativeParameterName, ProcessConstants.UNIVERSAL_IDENTIFIER_ID, ProcessConstants.AdeptDataType.DATE);
            ProcessModelParameter sysPar = SystemDataProducer.INSTANCE_CREATION_DATE.getParameterProperties();
            if (useDueDateRelativeInstanceStartParameter) {
                if (!dueDateRelativeInstanceStartParameterExists) {
                    ProcessModelParameter parameter = Activator.getService().getProcessModelFactory().createProcessModelParameter(sysPar.getName(), sysPar.getDescription(), sysPar.getDataType(), sysPar.getUDTName(), sysPar.getIdentifierID(), sysPar.isOptional(), sysPar.isVirtual(), sysPar.isFailure(), sysPar.getDefaultValue(), sysPar.getConfiguration(), (PluginDataContainer)sysPar, sysPar.getUserAttributes());
                    if (AddNodeSystemParameter.isPossible((Template)this.template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (CheckReport)checkReport)) {
                        AddNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (UpdateManager)updateManager);
                    }
                }
                if (AddSystemDataFlow.isPossible((Template)this.template, (int)this.template.getStartNode().getID(), (SystemDataProducer)SystemDataProducer.INSTANCE_CREATION_DATE, (int)node.getID(), (String)paramNameInstanceCreation, (CheckReport)checkReport)) {
                    AddSystemDataFlow.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)this.template.getStartNode().getID(), (SystemDataProducer)SystemDataProducer.INSTANCE_CREATION_DATE, (int)node.getID(), (String)paramNameInstanceCreation, (UpdateManager)updateManager);
                }
            } else if (removeOldDueDateRelativeInstanceStartParameter) {
                boolean parameterReferenceExists = AddNodeSystemParameter.parameterReferenceExists((Object)node, (Method[])Node.class.getMethods(), (String)paramNameInstanceCreation);
                if (!parameterReferenceExists && RemoveSystemDataFlow.isPossible((Template)this.template, (int)node.getID(), (String)paramNameInstanceCreation, (CheckReport)checkReport)) {
                    RemoveSystemDataFlow.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)node.getID(), (String)paramNameInstanceCreation, (UpdateManager)updateManager);
                }
                if (!parameterReferenceExists && RemoveNodeSystemParameter.isPossible((Template)this.template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (String)sysPar.getName(), (CheckReport)checkReport)) {
                    RemoveNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (String)sysPar.getName(), (UpdateManager)updateManager);
                }
            }
            if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
                this.logger.severe("Unable to perform all changes:\n" + checkReport.getReportSummary());
            }
            EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (UpdateManager)updateManager, (String)transactionLabel);
        } else {
            StartTransaction.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (UpdateManager)updateManager);
            if (UpdatePluginDataContainer.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"SchedulerData", (String)"SchedulerData", (PluginData)schedPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"SchedulerData", (String)"SchedulerData", (PluginData)schedPluginData, (UpdateManager)updateManager);
            }
            if (UpdatePluginDataContainer.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationData", (String)"EscalationData", (PluginData)escalationPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationData", (String)"EscalationData", (PluginData)escalationPluginData, (UpdateManager)updateManager);
            }
            if (UpdatePluginDataContainer.isPossible((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationHandling", (String)"MultiLevelEscalationHandling", (PluginData)multiPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (PluginDataContainer)((PluginDataContainer)this.nodePart.getModel()), (String)"EscalationHandling", (String)"MultiLevelEscalationHandling", (PluginData)multiPluginData, (UpdateManager)updateManager);
            }
            EndTransaction.performOperation((ChangeableInstance)((ChangeableInstance)this.instance), (UpdateManager)updateManager, (String)transactionLabel);
        }
        this.isModified = false;
    }

    private void addParameterConnection(SessionToken session, boolean useParameter, boolean parameterExists, Node node, DataElement dataElement, UpdateManager updateManager, CheckReport checkReport, String parameterName, UUID parameterIdentifierID, ProcessConstants.AdeptDataType parameterType) {
        if (useParameter) {
            if (!parameterExists) {
                ProcessModelParameter parameter = Activator.getService().getProcessModelFactory().createProcessModelParameter(parameterName, "", parameterType, "", parameterIdentifierID, false, false, false, null, null, null, null);
                if (AddNodeSystemParameter.isPossible((Template)this.template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (CheckReport)checkReport)) {
                    AddNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (UpdateManager)updateManager);
                }
            }
            if (this.template.getDataEdge(node.getID(), dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ) == null && InsertDataEdge.isPossible((Template)this.template, (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (CheckReport)checkReport)) {
                InsertDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (UpdateManager)updateManager);
            }
        }
    }

    private void removeParameterConnection(SessionToken session, boolean useParameter, boolean parameterExists, Node node, UpdateManager updateManager, CheckReport checkReport, String parameterName) {
        if (!useParameter && parameterExists) {
            Method[] methods = Node.class.getMethods();
            boolean parameterReferenceExists = AddNodeSystemParameter.parameterReferenceExists((Object)node, (Method[])methods, (String)parameterName);
            DataElement dataElement = this.template.getDataElement(node.getID(), node.getConnector(parameterName, ActivityConstants.AccessType.SYSTEM_READ));
            if (!parameterReferenceExists && DeleteDataEdge.isPossible((Template)this.template, (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (CheckReport)checkReport)) {
                DeleteDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (UpdateManager)updateManager);
            }
            if (!parameterReferenceExists && RemoveNodeSystemParameter.isPossible((Template)this.template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (String)parameterName, (CheckReport)checkReport)) {
                RemoveNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (String)parameterName, (UpdateManager)updateManager);
            }
        }
    }

    private void createDueGroupControls(Composite composite) {
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        Group dueGroup = toolkit.createGroup(composite, "Due-Date");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        dueGroup.setLayoutData((Object)gridData);
        dueGroup.setLayout((Layout)new GridLayout(2, false));
        this.relativeButton = toolkit.createButton((Composite)dueGroup, "relative to", 16);
        SelectionAdapter defaultSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulingSection.this.setModified();
            }
        };
        this.relativeTimeWidget = new RelativeTimeWidget((Composite)dueGroup, 0, (FormToolkit)toolkit, (SelectionListener)defaultSelectionListener, this.template, false);
        toolkit.adapt((Composite)this.relativeTimeWidget);
        GridData rtwGridData = new GridData();
        this.relativeTimeWidget.setLayoutData(rtwGridData);
        this.absoluteButton = toolkit.createButton((Composite)dueGroup, "absolute date ", 16);
        this.absoluteTimeWidget = new AbsoluteTimeWidget((Composite)dueGroup, 0, (FormToolkit)toolkit, (SelectionListener)defaultSelectionListener, this.template);
        toolkit.adapt((Composite)this.absoluteTimeWidget);
        this.relativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    SchedulingSection.this.enableRelativeControls(true);
                    SchedulingSection.this.setModified();
                } else {
                    SchedulingSection.this.enableRelativeControls(false);
                    SchedulingSection.this.setModified();
                }
            }
        });
        this.absoluteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    SchedulingSection.this.enableAbsoluteControls(true);
                    SchedulingSection.this.setModified();
                } else {
                    SchedulingSection.this.enableAbsoluteControls(false);
                    SchedulingSection.this.setModified();
                }
            }
        });
    }

    private void createPriorityGroupControls(Composite composite) {
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        final Group priorityGroup = toolkit.createGroup(composite, "Priority");
        priorityGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout(1, false);
        priorityGroup.setLayout((Layout)gridLayout);
        this.priorityCombo = new Combo((Composite)priorityGroup, 8);
        int i = 0;
        while (i < WorklistConstants.Priority.values().length) {
            this.priorityCombo.add(WorklistConstants.Priority.toString(null, (int)WorklistConstants.Priority.values()[i].getPriority()));
            ++i;
        }
        this.priorityCombo.add("Value from Data Element...");
        this.priorityCombo.select(0);
        GridData layoutData = new GridData(4, 0x1000000, false, false);
        this.priorityCombo.setLayoutData((Object)layoutData);
        this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulingSection.this.setModified();
                int selectionIndex = SchedulingSection.this.priorityCombo.getSelectionIndex();
                if (selectionIndex >= WorklistConstants.Priority.values().length) {
                    LinkedList<DataElement> dataElements = new LinkedList<DataElement>();
                    for (DataElement dataElement : SchedulingSection.this.template.getDataElements()) {
                        if (!dataElement.getIdentifierID().equals(CommonConstants.IDENTIFIER_ID_PRIORITY)) continue;
                        dataElements.add(dataElement);
                    }
                    int selectedIndex = 0;
                    DataElementSelectionMessageDialogue dialogue = new DataElementSelectionMessageDialogue(priorityGroup.getShell(), dataElements, selectedIndex);
                    int res = dialogue.open();
                    if (res == 0) {
                        DataElement dataElement = (DataElement)dataElements.get(dialogue.getSelectedIndex());
                        SchedulingSection.this.priorityCombo.setData(SchedulingSection.PRIORITY_COMBO_DATA_ELEMENT, (Object)dataElement);
                        SchedulingSection.this.priorityCombo.setItem(selectionIndex, "Value from Data Element: " + dataElement.getName());
                        SchedulingSection.this.priorityCombo.select(selectionIndex);
                    } else if (SchedulingSection.this.priorityCombo.getData(SchedulingSection.PRIORITY_COMBO_DATA_ELEMENT) == null) {
                        SchedulingSection.this.priorityCombo.setItem(selectionIndex, "Value from Data Element...");
                        SchedulingSection.this.priorityCombo.select(0);
                    }
                }
            }
        });
    }

    private void createEffortGroupControls(Composite composite) {
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        Group effortGroup = toolkit.createGroup(composite, "Estimated Effort");
        effortGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        effortGroup.setLayout((Layout)gridLayout);
        this.effortDaySpinner = new Spinner((Composite)effortGroup, 2048);
        this.effortDaySpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.effortDaySpinner);
        this.effortDaySpinner.setMaximum(365);
        Label label = toolkit.createLabel((Composite)effortGroup, "days");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.effortDaySpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulingSection.this.setModified();
            }
        });
        this.effortHourSpinner = new Spinner((Composite)effortGroup, 2048);
        this.effortHourSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.effortHourSpinner);
        this.effortHourSpinner.setMaximum(23);
        label = toolkit.createLabel((Composite)effortGroup, "hours");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.effortHourSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulingSection.this.setModified();
            }
        });
        this.effortMinuteSpinner = new Spinner((Composite)effortGroup, 2048);
        this.effortMinuteSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.effortMinuteSpinner);
        this.effortMinuteSpinner.setMaximum(59);
        label = toolkit.createLabel((Composite)effortGroup, "minutes");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.effortMinuteSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulingSection.this.setModified();
            }
        });
        label = toolkit.createLabel((Composite)effortGroup, "Tolerance:");
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.toleranceSpinner = new Spinner((Composite)effortGroup, 2048);
        this.toleranceSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolkit.adapt((Composite)this.toleranceSpinner);
        this.toleranceSpinner.setMaximum(99);
        label = toolkit.createLabel((Composite)effortGroup, "%");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.toleranceSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulingSection.this.setModified();
            }
        });
    }

    private void createEscalationControls(Composite composite) {
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        Table escalationTable = this.getWidgetFactory().createTable(composite, 65540);
        GridData data = new GridData(4, 4, true, true);
        data.verticalSpan = 2;
        escalationTable.setLayoutData((Object)data);
        this.escalationTableViewer = new TableViewer(escalationTable);
        this.escalationTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SchedulingSection.this.actualLevelData != null) {
                    SchedulingSection.this.updateAttributeCompositeValues(SchedulingSection.this.actualLevelData);
                }
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selection.getFirstElement();
                    if (selection.getFirstElement() instanceof MultiLevelEscalationData.LevelData) {
                        SchedulingSection.this.actualLevelData = (MultiLevelEscalationData.LevelData)selection.getFirstElement();
                        SchedulingSection.this.openAttributeComposite(SchedulingSection.this.actualLevelData);
                    }
                }
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
        escalationTable.setLayout((Layout)tableLayout);
        TableColumn thresholdColumn = new TableColumn(escalationTable, 16384);
        thresholdColumn.setText(ESCALATION_THRESHOLD);
        TableColumn actionColumn = new TableColumn(escalationTable, 16384);
        actionColumn.setText(ESCALATION_ACTION);
        escalationTable.setHeaderVisible(true);
        this.escalationTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.escalationTableViewer.setLabelProvider((IBaseLabelProvider)new EscalationTableLabelProvider());
        this.escalationTableViewer.setColumnProperties(new String[]{ESCALATION_THRESHOLD, ESCALATION_ACTION});
        Button addButton = toolkit.createButton(composite, "add", 8);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EscalationLevelDialogue dialog = new EscalationLevelDialogue(SchedulingSection.this.getPart().getSite().getShell(), SchedulingSection.this.escalationActions, (FormToolkit)SchedulingSection.this.getWidgetFactory(), SchedulingSection.this.template, (Node)SchedulingSection.this.nodePart.getModel());
                MultiLevelEscalationData.LevelData newLevelData = dialog.open();
                if (newLevelData != null) {
                    DataElement referencedDataElement = dialog.getReferencedDataElement();
                    String levelParameterName = dialog.getParameterReferenceName();
                    SchedulingSection.this.escalationTableModel.add(newLevelData);
                    if (levelParameterName != null) {
                        SchedulingSection.this.escalationTableDataElements.put(levelParameterName, referencedDataElement);
                    }
                    SchedulingSection.this.escalationTableViewer.add((Object)newLevelData);
                    SchedulingSection.this.setModified();
                }
            }
        });
        addButton.setLayoutData((Object)new GridData(4, 1024, false, false));
        Button removeButton = toolkit.createButton(composite, "remove", 8);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SchedulingSection.this.escalationTableViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof StructuredSelection) {
                    StructuredSelection sel = (StructuredSelection)selection;
                    Object obj = sel.getFirstElement();
                    SchedulingSection.this.escalationTableModel.remove(obj);
                    try {
                        ((MultiLevelEscalationData.LevelData)obj).getThreshold();
                        ((MultiLevelEscalationData.LevelData)obj).getThresholdReference();
                    }
                    catch (UnresolvedParameterReferenceException ex) {
                        SchedulingSection.this.escalationTableDataElements.remove(ex.getParameterReferences()[0].getName());
                    }
                    SchedulingSection.this.escalationTableViewer.remove(obj);
                    SchedulingSection.this.setModified();
                }
            }
        });
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
    }

    private void createAttributeComposites(Composite parent) {
        this.attributeComposites = EscalationTools.createAttributeComposites(parent);
    }

    protected void openAttributeComposite(MultiLevelEscalationData.LevelData data) {
        String pluginID = data.getEscalationPluginData().getPluginID();
        Map escalationAttributes = data.getEscalationPluginData().getPluginData();
        AbstractEscalationComposite comp = this.attributeComposites.get(pluginID);
        comp.setInput(escalationAttributes);
        StackLayout layout = (StackLayout)this.escalationAttributesContainer.getLayout();
        layout.topControl = comp;
        this.escalationAttributesContainer.layout();
        this.escalationSection.layout();
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.isValidEditPart(this.nodePart) && this.isModified()) {
            this.commitChanges();
        }
    }

    private boolean isValidEditPart(DefaultNodeEditPart nodePart) {
        if (!NodeBasicsSection.elementStillExists(nodePart)) {
            return false;
        }
        return !(nodePart instanceof DataElementEditPart) && nodePart.getTemplate().getStartNode().getID() != ((Node)nodePart.getModel()).getID() && nodePart.getTemplate().getEndNode().getID() != ((Node)nodePart.getModel()).getID() && !ProcessModelTools.isNullNode((ProcessConstants.NodeType)nodePart.getTemplate().getNodeType(((Node)nodePart.getModel()).getID()));
    }

    protected void updateAttributeCompositeValues(MultiLevelEscalationData.LevelData levelData) {
        String pluginID = levelData.getEscalationPluginData().getPluginID();
        Map<String, String> attributes = this.attributeComposites.get(pluginID).getInput();
        DefaultPluginData pluginData = new DefaultPluginData(pluginID, attributes);
        levelData.setEscalationPluginData((PluginData)pluginData);
        this.setModified();
    }

    private String getExistingParameterRefName(Node node, int dataElementID) {
        int connector = this.template.getConnector(node.getID(), dataElementID, ActivityConstants.AccessType.SYSTEM_READ);
        if (connector != Integer.MIN_VALUE) {
            return node.getParameterName(connector);
        }
        return null;
    }

    class EscalationTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EscalationTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof MultiLevelEscalationData.LevelData)) {
                throw new RuntimeException("getColumnText: element is not of type LevelData!");
            }
            MultiLevelEscalationData.LevelData levelData = (MultiLevelEscalationData.LevelData)element;
            switch (columnIndex) {
                case 0: {
                    String formatDateTime;
                    String relativeRefname = null;
                    try {
                        levelData.getThresholdReference();
                    }
                    catch (UnresolvedParameterReferenceException e) {
                        relativeRefname = e.getParameterReferences()[0].getName();
                    }
                    try {
                        long threshold = levelData.getThreshold();
                        formatDateTime = DateTimeFormat.formatDateTime((long)threshold);
                    }
                    catch (UnresolvedParameterReferenceException e) {
                        formatDateTime = "Use date from " + e.getParameterReferences()[0].getName();
                    }
                    formatDateTime = relativeRefname != null ? String.valueOf(formatDateTime) + " after " + relativeRefname : String.valueOf(formatDateTime) + " after activation";
                    return formatDateTime;
                }
                case 1: {
                    PluginData data = levelData.getEscalationPluginData();
                    return SchedulingSection.this.escalationActions.get(data.getPluginID());
                }
            }
            return "Invalid column: " + columnIndex;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

