/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.orgmodelmanager.ModelExplorer;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.dialogues.QualifiedAgentDialogue;
import de.aristaflow.adept2.ui.i18n.TranslateAction;
import de.aristaflow.adept2.ui.i18n.TranslateActionCallback;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.TemplatePropertySource;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TemplateBasicsSection
extends AbstractPropertySection {
    private static final int BASIC_LABEL_WIDTH = 185;
    private IAction translateAction;
    private Text name;
    private Text instanceNameTemplate;
    private Text description;
    Text supervisor;
    private Button supervisorButton;
    boolean modified = false;
    private Form form;
    TemplateEditPart editPart;
    AbstractPropertySource properties;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            TemplateBasicsSection.this.modified = true;
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 && TemplateBasicsSection.this.modified) {
                Text textField = (Text)e.getSource();
                TemplateBasicsSection.this.storeValueOfTextField(textField);
                TemplateBasicsSection.this.modified = false;
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (TemplateBasicsSection.this.modified) {
                Text textField = (Text)e.getSource();
                TemplateBasicsSection.this.storeValueOfTextField(textField);
                TemplateBasicsSection.this.modified = false;
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Template Basics");
        this.getWidgetFactory().decorateFormHeading(this.form);
        this.translateAction = new TranslateAction(this.form.getShell(), (ModelViewerProvider)Activator.getService(), new TranslateActionCallback(){

            public ChangeableTemplate getTemplate() {
                return (ChangeableTemplate)TemplateBasicsSection.this.editPart.getTemplate();
            }

            public Class<?> getLocalisedProcessModelClass() {
                return Template.class;
            }

            public PluginDataContainer getPluginDataContainer() {
                return TemplateBasicsSection.this.editPart.getTemplate();
            }

            public Collection<PluginData> getPluginData() {
                if (TemplateBasicsSection.this.editPart.getModel() instanceof PluginDataContainer) {
                    return ((PluginDataContainer)TemplateBasicsSection.this.editPart.getModel()).getPluginDatas().values();
                }
                return null;
            }
        }, Activator.getService().getUpdateManager());
        this.form.getToolBarManager().add(this.translateAction);
        this.form.getToolBarManager().update(false);
        this.form.getBody().setLayout((Layout)new FillLayout());
        Composite composite = this.getWidgetFactory().createFlatFormComposite(this.form.getBody());
        this.createNameControls(composite);
        this.createInstanceNameControls(composite);
        this.createDescriptionControls(composite);
        this.createSupervisorControls(composite);
        this.setEditableStateOfFields();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof TemplateEditPart) {
            this.editPart = (TemplateEditPart)input;
            this.properties = (AbstractPropertySource)((TemplateEditPart)input).getAdapter(IPropertySource.class);
            if (!(this.properties.getTemplate() instanceof ChangeableTemplate)) {
                this.form.setText("Template Basics (read only)");
            }
        } else if (input instanceof BranchEditPart) {
            BranchEditPart branchEditPart = (BranchEditPart)input;
            this.properties = (AbstractPropertySource)((BranchEditPart)input).getAdapter(IPropertySource.class);
            this.editPart = (TemplateEditPart)branchEditPart.getViewer().getEditPartRegistry().get(this.properties.getTemplate());
            if (!(this.properties.getTemplate() instanceof ChangeableTemplate)) {
                this.form.setText("Template Basics (read only)");
            }
        } else {
            throw new RuntimeException("TemplateBasicsSection.setInput was called with an unexpected edit part: " + input);
        }
    }

    public void refresh() {
        if (this.properties == null) {
            return;
        }
        this.name.removeModifyListener(this.listener);
        this.name.removeFocusListener(this.focusListener);
        this.name.removeKeyListener(this.keyListener);
        this.instanceNameTemplate.removeModifyListener(this.listener);
        this.instanceNameTemplate.removeFocusListener(this.focusListener);
        this.instanceNameTemplate.removeKeyListener(this.keyListener);
        this.description.removeModifyListener(this.listener);
        this.description.removeFocusListener(this.focusListener);
        this.description.removeKeyListener(this.keyListener);
        this.translateAction.setEnabled(this.properties.getTemplate() instanceof ChangeableTemplate);
        String nameID = TemplatePropertySource.PROPERTY_NAME;
        this.name.setText((String)this.properties.getPropertyValue(nameID));
        this.name.setData((Object)nameID);
        this.name.addFocusListener(this.focusListener);
        this.name.addModifyListener(this.listener);
        this.name.addKeyListener(this.keyListener);
        String instanceNameID = TemplatePropertySource.PROPERTY_INSTANCE_NAME_TEMPLATE;
        String instanceNameTemplateString = (String)this.properties.getPropertyValue(instanceNameID);
        if (instanceNameTemplateString == null) {
            instanceNameTemplateString = "";
        }
        this.instanceNameTemplate.setText(instanceNameTemplateString);
        this.instanceNameTemplate.setData((Object)instanceNameID);
        this.instanceNameTemplate.addFocusListener(this.focusListener);
        this.instanceNameTemplate.addModifyListener(this.listener);
        this.instanceNameTemplate.addKeyListener(this.keyListener);
        String descID = TemplatePropertySource.PROPERTY_DESCRIPTION;
        this.description.setText((String)this.properties.getPropertyValue(descID));
        this.description.setData((Object)descID);
        this.description.addFocusListener(this.focusListener);
        this.description.addModifyListener(this.listener);
        Object agent = this.properties.getPropertyValue(TemplatePropertySource.PROPERTY_SUPERVISOR_AGENT);
        if (agent != null) {
            this.supervisor.setText(agent.toString());
        } else {
            this.supervisor.setText("<not set>");
        }
        this.setEditableStateOfFields();
    }

    private void setEditableStateOfFields() {
        if (this.properties != null && this.properties.getTemplate() instanceof ChangeableTemplate) {
            this.name.setEditable(true);
            this.instanceNameTemplate.setEditable(true);
            this.description.setEditable(true);
            this.supervisor.setEditable(true);
            this.supervisorButton.setEnabled(true);
        } else {
            this.name.setEditable(false);
            this.instanceNameTemplate.setEditable(false);
            this.description.setEditable(false);
            this.supervisor.setEditable(false);
            this.supervisorButton.setEnabled(false);
        }
    }

    void storeValueOfTextField(Text textField) {
        String propertyID = (String)textField.getData();
        String value = textField.getText();
        this.properties.setPropertyValue(propertyID, value);
    }

    private void createNameControls(Composite composite) {
        this.name = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 185);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 14);
        data.width = 200;
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(this.listener);
        this.name.addFocusListener(this.focusListener);
        this.name.addKeyListener(this.keyListener);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.name, -5);
        data.top = new FormAttachment((Control)this.name, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    private void createInstanceNameControls(Composite composite) {
        this.instanceNameTemplate = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 185);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.name, 4);
        data.width = 200;
        this.instanceNameTemplate.setLayoutData((Object)data);
        this.instanceNameTemplate.addModifyListener(this.listener);
        this.instanceNameTemplate.addFocusListener(this.focusListener);
        this.instanceNameTemplate.addKeyListener(this.keyListener);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, "Instance Name Template:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.instanceNameTemplate, -5);
        data.top = new FormAttachment((Control)this.instanceNameTemplate, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    private void createDescriptionControls(Composite composite) {
        this.description = this.getWidgetFactory().createText(composite, "", 576);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 185);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.instanceNameTemplate, 4);
        data.height = 50;
        data.width = 200;
        this.description.setLayoutData((Object)data);
        this.description.addModifyListener(this.listener);
        this.description.addFocusListener(this.focusListener);
        this.description.addKeyListener(this.keyListener);
        CLabel descriptionLabel = this.getWidgetFactory().createCLabel(composite, "Description:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.description, -5);
        data.top = new FormAttachment((Control)this.description, 0, 128);
        descriptionLabel.setLayoutData((Object)data);
    }

    private void createSupervisorControls(final Composite composite) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        CLabel label = this.getWidgetFactory().createCLabel(composite, "Template Supervisor:");
        this.supervisor = this.getWidgetFactory().createText(composite, "");
        this.supervisor.setEditable(false);
        this.supervisorButton = this.getWidgetFactory().createButton(composite, "Change...", 8);
        this.supervisorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ADEPT2ClientService clientService = Activator.getService();
                ResourceBundle messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.processvisualisation.views.PVPBundle", clientService.getActiveAgent().getLocale());
                HashSet<QualifiedAgent> possibleAgents = new HashSet<QualifiedAgent>();
                try {
                    SessionToken session = clientService.getSessionToken();
                    ModelExplorer modelExplorer = clientService.getOrgModelManager().getModelExplorer();
                    for (Entity entity : modelExplorer.getEntities(session, EntityType.AGENT, new String[0])) {
                        List orgPositionEntities = modelExplorer.getRelatedEntities(session, EntityType.AGENT, entity.getInteger("id"), RelationType.ORG_POSITION_OCCUPATION, false, new String[0]);
                        for (Entity orgPosition : orgPositionEntities) {
                            possibleAgents.add(new QualifiedAgent(entity.getInteger("id"), entity.getString("userName"), orgPosition.getInteger("id"), orgPosition.getString("name")));
                        }
                    }
                }
                catch (DataSourceException e) {
                    String message = "Error in the data source. Data source not available";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                }
                possibleAgents.add(clientService.getActiveAgent().getQualifiedAgent());
                QualifiedAgentDialogue dia = new QualifiedAgentDialogue(composite.getShell(), possibleAgents, messages, "SupervisorQA", false, false, false, clientService.getActiveAgent().getQualifiedAgent());
                if (dia.open() == 0) {
                    QualifiedAgent agent = (QualifiedAgent)dia.getSelectedAgents().toArray()[0];
                    TemplateBasicsSection.this.properties.setPropertyValue(TemplatePropertySource.PROPERTY_SUPERVISOR_AGENT, agent);
                    TemplateBasicsSection.this.supervisor.setText(TemplateBasicsSection.this.properties.getTemplate().getSupervisorAgent().toString());
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.supervisor, -5);
        data.top = new FormAttachment((Control)this.supervisor, 0, 0x1000000);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 185);
        data.right = new FormAttachment((Control)this.supervisorButton, -5);
        data.top = new FormAttachment((Control)this.description, 4);
        data.width = 200;
        this.supervisor.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.supervisor, 0, 0x1000000);
        data.height = buttonHeight;
        this.supervisorButton.setLayoutData((Object)data);
    }
}

